# - Find Base
# Find the native Base headers and libraries.
#
#  Base_INCLUDE_DIRS - where to find Base/dbBase.h, etc.
#  Base_LIBRARIES    - List of libraries when using Base.
#  Base_FOUND        - True if Base found.

# Look for the header file.
SET(CMAKE_INCLUDE_PATH ${CMAKE_INSTALL_PREFIX}/include)
SET(CMAKE_LIBRARY_PATH ${CMAKE_INSTALL_PREFIX}/lib)

FIND_PATH(Base_INCLUDE_DIR NAMES dbBase.h)
MARK_AS_ADVANCED(Base_INCLUDE_DIRS)

# Look for the library.
FIND_LIBRARY(Base_LIBRARY NAMES Com)
MARK_AS_ADVANCED(Base_LIBRARIES)

# handle the QUIETLY and REQUIRED arguments and set Base_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Base DEFAULT_MSG Base_LIBRARY Base_INCLUDE_DIR)

MESSAGE(STATUS "Base include path: " ${Base_INCLUDE_DIR})

IF(Base_INCLUDE_DIR AND Base_LIBRARY)#Base_FOUND)
  SET(Base_FOUND TRUE)
  SET(Base_LIBRARIES    ${Base_LIBRARY})
  SET(Base_INCLUDE_DIRS ${Base_INCLUDE_DIR})
ELSEIF(NOT Base_FOUND)
  SET(Base_FOUND FALSE)
  SET(Base_LIBRARIES)
  SET(Base_INCLUDE_DIRS)
ENDIF()

