from mantid.simpleapi import *
import json
import time
import sys
import numpy
import subprocess
import os
import matplotlib.pyplot as plt
import glob

def parseDaq(prepath,runno):
    for i in range(10):
        subprocess.check_call("python binary_hist.py "+runno+" "+str(i+1)+" "+prepath+" &", shell=True)
    for i in range(10):
        while not os.path.exists(prepath+"/tmpData/module"+str(i+1)+".dat"):
            print "no data"
            time.sleep(3)
        print "module",str(i+1)," exists!"
 
def parseMonitor(prepath, runno, monitor, pixels):
    _cmd="./main "+runno+" "+monitor+" "+str(pixels)+" "+prepath
    subprocess.check_call(_cmd, shell=True)
    while not os.path.exists(prepath+"/tmpData/"+monitor+".dat"):
        print "no data"
        time.sleep(3)
    print "finish parse monitor binary data for ", monitor
    
def getDaq(prepath, moduleList):
    from xml.etree import ElementTree as ET
    root = ET.parse('configure.xml')
    tof  = root.find('tofInformation')
    m_tofstart= int(tof.attrib['tofstart'])
    m_tofstep = int(tof.attrib['tofstep'])
    m_tofbins = int(tof.attrib['tofbin'])
    tof = [m_tofstart+i*m_tofstep for i in xrange(m_tofbins+1)]
    mpid=[]
    value=[]
    for name in moduleList:
        for item in root.findall('type/component'):
            if name== item.attrib['name']:
                m_moduleinfo = item.attrib
                idstart = int(m_moduleinfo['idstart'])
                idsize  = int(m_moduleinfo['pixels'])
                _tmp = [idstart+i*1 for i in xrange(idsize)]
                for num in _tmp:
                    mpid.append(num)
        f0=open(prepath+'/tmpData/'+name+'.dat',"r")
        _tmpv=json.load(f0)
        v=[]
        for ix in _tmpv:
            for iy in ix:
                v.append(iy)
        for num in v:
            value.append(num)
    if len(mpid)*(len(tof)-1)==len(value):
        return mpid, tof ,value   
    else:
        print "daq data match failed!"
        _cmd="rm -rf "+prepath+"/tmpData"
        subprocess.check_call(_cmd, shell=True)
        sys.exit()

def getMonitor(prepath, monitor, pixels):
    mpid=[1+i for i in xrange(pixels)]
    tof=[0+i for i in xrange(40001)]
    f0=open(prepath+"/tmpData/"+monitor+".dat")
    _tmpv=json.load(f0)
    value=[]
    for ix in _tmpv:
        for iy in ix:
            value.append(iy)
    if len(mpid)*(len(tof)-1)==len(value):
        return mpid, tof ,value   
    else:
        print "monitor data match failed!"
        _cmd="rm -rf "+prepath+"/tmpData"
        subprocess.check_call(_cmd, shell=True)
        sys.exit()
    
def plotXY(wsname, runno):
    #SaveAscii(InputWorkspace=wsname, Filename=prepath+'/reductionData/'+wsname+'.dat')
    name=mtd[wsname]
    x=list(name.readX(0))
    x.pop()
    y=name.readY(0)
    #yerr=name.readE(0)
    #plt.errorbar(x,y,yerr=yerr)
    plt.plot(x,y)
    plt.title(wsname+": "+runno)
    plt.show()

# usage: python hist_nxs.py banknum 
if __name__ == '__main__':
    be = time.time()
    try:
        runnum=int(sys.argv[1])
    except:
        print "usage: python run.py 10"
        exit()
    runno="RUN"+str(runnum)
    prepath=sys.path[0]+"/RUN"+str(runnum).zfill(7)
    prepath2=sys.path[0]
    if os.path.exists(prepath):
	pass
    else:
	os.mkdir(prepath)
    tmp=prepath+'/tmpData'
    if os.path.exists(tmp):
    	_cmd="rm -rf "+prepath+"/tmpData/*"
    	subprocess.check_call(_cmd, shell=True)
    else:
        os.mkdir(tmp)

    print prepath
    # daq data
    moduleList=['module1','module2','module3','module4','module5','module6','module7','module8','module9','module10']
    # is daq file exist ?
    rawpath="/opt/CSNSDATA/TS1/BL01/DAQ/"+runno
    xmlfile=glob.glob(os.path.join(rawpath, '*.xml'))
    if len(xmlfile)==0:
        print "no data in ",runno, " for DAQ"
        sys.exit()
    else:
        pass
    parseDaq(prepath, runno)
    spid, stof, svalue = getDaq(prepath, moduleList)
    #mantid data processing
    LoadCSNSRaw(OutputWorkspace="sample", PixelID_bank=spid, TimeOfFlight_bank=stof, Counts_bank=svalue, PixelID_monitor=[0,1], TimeOfFlight_monitor=[0,16], Counts_monitor=[1,1])
    LoadInstrument(Workspace="sample_1", Filename=prepath2+'/paramData/detector.xml', RewriteSpectraMap='True')
    SaveNexus(InputWorkspace='sample_1', Filename=prepath+'/sample.nxs')
    ConvertUnits(InputWorkspace='sample_1', OutputWorkspace='tmp_wave', Target='Wavelength', AlignBins=True)
    SumSpectra(InputWorkspace='tmp_wave', OutputWorkspace="sample_I-Wavelength", IncludeMonitors=False)
    ConvertUnits(InputWorkspace='sample_I-Wavelength', OutputWorkspace='__tmp_q', Target='MomentumTransfer', AlignBins=True)
    Rebin(InputWorkspace='__tmp_q', OutputWorkspace='sample_I-Q', Params='0.01,0.004,2')
    SaveAscii(InputWorkspace="sample_I-Q", Filename=prepath+'/sample_I-Q.dat')
    SaveAscii(InputWorkspace="sample_I-Wavelength", Filename=prepath+'/sample_I-wave.dat')


    #plotXY("sample_I-Q", runno)
    #plotXY("sample_I-Wavelength", runno)
    # monitor data
    monitorList=['Monitor1','Monitor2','Monitor3']
    monitorPixel={}
    monitorPixel['monitor1']=1024
    monitorPixel['monitor2']=1
    monitorPixel['monitor3']=1
    runno="RUN"+str(runnum).zfill(7)
    for mname in monitorList:
        # is monitor file exist ?
        rawpath="/opt/CSNSDATA/TS1/BL01/Monitor/Histogram/"+mname+"/"+runno
        binfile=glob.glob(os.path.join(rawpath, '*.bin'))
        if len(binfile)==0:
            print "no data in ",runno, " for ",mname
    	    _cmd="rm -rf "+prepath+"/tmpData"
    	    subprocess.check_call(_cmd, shell=True)
            sys.exit()
        else:
            pass
        mname = mname.lower()
        pixels=int(monitorPixel[mname])
        parseMonitor(prepath, runno, mname, pixels)
        mpid=[]
        mtof=[]
        mvalue=[]
        mpid, mtof, mvalue = getMonitor(prepath, mname, pixels)
        # mantid data processing
        LoadCSNSRaw(OutputWorkspace=mname, PixelID_bank=[0,1], TimeOfFlight_bank=[0,8], Counts_bank=[1,1], PixelID_monitor=mpid, TimeOfFlight_monitor=mtof, Counts_monitor=mvalue)
        LoadInstrument(Workspace=mname+"_2", Filename=prepath2+'/paramData/'+mname+'.xml', RewriteSpectraMap='True')
        SaveNexus(InputWorkspace=mname+'_2', Filename=prepath+'/'+mname+'.nxs')
        ConvertUnits(InputWorkspace=mname+'_2', OutputWorkspace='__tmp_wave', Target='Wavelength', AlignBins=True)
        SumSpectra(InputWorkspace='__tmp_wave', OutputWorkspace="__tmp_wave", IncludeMonitors=True)
        Rebin(InputWorkspace='__tmp_wave', OutputWorkspace=mname+"_I-Wavelength", Params='0.01,0.002,10')
        SaveAscii(InputWorkspace=mname+"_I-Wavelength", Filename=prepath+'/'+mname+'_Iwave.dat')

    _cmd="rm -rf "+prepath+"/tmpData"
    subprocess.check_call(_cmd, shell=True)
        #plotXY(mname+"_I-Wavelength", runno)

    #print time.time()-be,' seconds'
