from mantid.simpleapi import *
import jsonArray
import time
import datetime
import json
#import multiprocessing
#from multiprocessing import Process, Manager
import shutil
import numpy as np
import path
import threading

#class neonIO(multiprocessing.Process):
class neonIO(threading.Thread):
    def __init__(self, neonRedis, refreshtime,myDict, logger, mypid):
        super(neonIO, self).__init__()
        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis
        self.neonRedis_read=neonRedis
        self.logger=logger
        self.mypid=mypid
        self.instname="./instrument/detector.xml"
        self.myDict=myDict
        self.confJudge = True

        self.command=-1
        self.commandList=['configure','unconfigure','start','pause','resume','stop','abort']
        self.statusList=['waiting','unconfigured','configuring','ready','running','paused','error']

        self.neonpathDetValue= []
        self.neonpathDetPid= []
        self.neonpathDetTof= []
        for num in range(10):
            self.neonpathDetValue.append("/SANS/workspace/detector/module"+str(num+1)+"/value")
            self.neonpathDetPid.append("/SANS/workspace/detector/module"+str(num+1)+"/pid")
            self.neonpathDetTof.append("/SANS/workspace/detector/module"+str(num+1)+"/tof")

        self.monPid=[]
        for i in range(1024):
            self.monPid.append(i+1)
        self.detPid=[]
        for i in range(15000):
            self.detPid.append(i+100001)


    def getCommand(self):
        #_path="/SANS/control/command/mantid1"
        _path="/SANS/control/command/mantid"
        try:
            _json=self.neonRedis_read.get(_path)
            _data=int(json.loads(_json))
        except:
            _data=-1
        return _data

    def setCommand(self, command):
        self.command=command

    def setStatus(self, status):
        path="/SANS/stateMachine/status"
        self.neonRedis_write.set(path, json.dumps(status))

    def getStatus(self):
        path="/SANS/stateMachine/status"
        _json=self.neonRedis_read.get(path)
        data=int(json.loads(_json))
        return data


    def stateMachine(self, command, status):
        if command == 0:
            if status == 1:
                self.myDict["configure"]= True
                status = 3
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 1:
            if status == 3:
                self.myDict["configure"]=False
                status = 1
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 2:
            if status == 3:
                self.clearData()
                self.myDict["running"]=True
                status = 4
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 3:
            if status == 4:
                self.myDict['running']=False
                status = 5
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 4:
            if status == 5:
                self.myDict['running']=True
                status = 4
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 5:
            if status == 4:
                self.myDict['running']= False
                status = 3
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 6:
            self.myDict['running']=False
            self.myDict['configure']=False
            self.myDict['error']=False
            status = 1
        else:
            pass

        return status

    def processCommand(self):
        if self.myDict['error']:
            status = 6
            self.setStatus(status)
        _command=self.getCommand()
        if self.command==_command:
            pass
        else:
            self.setCommand(_command)
            self.logger.debug("new command: "+str(self.command))
            status=self.getStatus()
            self.logger.debug("before statemachine: "+str(status))
            tmp=self.stateMachine(self.command, status)
            self.setStatus(tmp)
            self.logger.debug("after statemachine: "+str(tmp))


    def getProtonCharge(self):
        data=[]
        path="/SANS/drone/proton_charge"
        _json=self.neonRedis_read.get(path)
        if _json is None:
            val=1
        else:
            data=jsonArray.jsonDecoder(_json)
            val=data[1][-1]
        if(type(val)==int):
            if val == 0:
                return 1
            else:
                return val
        else:
            return 1

    def setHB(self):
        tmp=self.neonRedis_read.get("/SANS/stateMachine/status")
        status=int(tmp)
        data={}
        data['timestamp']=time.strftime('%Y-%m-%dT%H:%M:%S.%03d+08:00')
        data['status']=status
        data['pid']=self.mypid
        self.neonRedis_write.set("/SANS/heartbeat/mantid", json.dumps(data))


    def get1Ddata(self, path):
        data=[]
        _json=self.neonRedis_read.get(path)
        data=jsonArray.jsonDecoder(_json)
        return data

    def get2Ddata(self, path):
        data = []
        _json=self.neonRedis_read.get(path)
        _array=jsonArray.jsonDecoder(_json)
        for ix in _array:
            for iy in ix:
                data.append(iy)
        return data



    def processWorkspace(self):
        self.processCommand()
        try:
            self.loadWorkspace()
            self.setHB()
        except:
            self.logger.error('error in load workspace')
        self.processCommand()
        #set monitor data
        try:
            self.setMonXY()
            self.setMonTofCounts('monitor1')
            self.setMonTofCounts('monitor2')
            self.setMonTofCounts('monitor3')
            self.setMonWaveCounts('monitor1')
            self.setMonWaveCounts('monitor2')
            self.setMonWaveCounts('monitor3')
            self.setTransData()
            self.setHB()
        except:
            self.logger.error('error in set monitor')
        self.processCommand()
        try:
            self.setDetXY()
            self.setTubes()
            self.setDetTofCounts()
            self.setDetWaveCounts()
            self.setDetIQ()
        except:
            self.logger.error('error in set detector')
        self.setHB()
 

    def setTubes(self):
	    for i in range(120):
	        CropWorkspace(InputWorkspace="sample_1", OutputWorkspace=str(i), StartWorkspaceIndex=i*125, EndWorkspaceIndex=i*125+124)
            SumSpectra(InputWorkspace=str(i), OutputWorkspace="tofCounts"+str(i), IncludeMonitors=False)
            name=mtd["tofCounts"+str(i)]
            counts=[]
            counts=name.readY(0)
            _tmp=name.readX(0)
            tof=[]
            path1="/SANS/workspace/MantidData/tube"+str(i+1)+"/tof"
            path2="/SANS/workspace/MantidData/tube"+str(i+1)+"/counts"
            for j in range(len(_tmp)-1):
                tof.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
            self.neonRedis_write.set(path1,jsonArray.jsonEncoder(tof))
            self.neonRedis_write.set(path2,jsonArray.jsonEncoder(counts))
            self.logger.debug("set I-tof for tube"+str(i+1))

    def setTransData(self):
        SmoothData(InputWorkspace="m2_wave",OutputWorkspace="m2", NPoints=5)
        Rebin(InputWorkspace="m2", OutputWorkspace="m2", Params='1.5, 0.01, 8.0')
        Rebin(InputWorkspace="m3_wave", OutputWorkspace="m3", Params='1.5, 0.01, 8.0')
        name1=mtd["m2"]
        name2=mtd["m3"]
        v2=name1.readY(0)
        v3=name2.readY(0)
        #self.neonRedis_write.set("/SANS/workspace/MantidData/tmp/counts1", jsonArray.jsonEncoder(v2))
        #self.neonRedis_write.set("/SANS/workspace/MantidData/tmp/counts2", jsonArray.jsonEncoder(v3))
        vres=[]
        for i in range(len(v2)):
            if(v2[i]==0):
                vres.append(v3[i])
            else:
                vres.append(v3[i]/v2[i])
            wave=[]
            _tmp=name1.readX(0)
            for j in range(len(_tmp)-1):
                wave.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
                #wave=wave[imax:]

        self.neonRedis_write.set("/SANS/workspace/MantidData/trans/wavelength", jsonArray.jsonEncoder(wave))
        self.neonRedis_write.set("/SANS/workspace/MantidData/trans/transmission", jsonArray.jsonEncoder(vres))
        self.logger.debug("set transmission!")



    def setMonWaveCounts(self,monitor):
        # set tof counts
        if monitor == "monitor1":
            try:
                ConvertUnits(InputWorkspace='monitor1_2', OutputWorkspace='__tmp', Target='Wavelength', AlignBins=True)
                SumSpectra(InputWorkspace='__tmp', OutputWorkspace="m1_wave", IncludeMonitors=True)
                name=mtd["m1_wave"]
            except:
                self.logger.warning('no monitor1 workspace!')
                name=None
        elif monitor == "monitor2":
            ConvertUnits(InputWorkspace='monitor2_2', OutputWorkspace='m2_wave', Target='Wavelength')
            name=mtd["m2_wave"]
        elif monitor == "monitor3":
            ConvertUnits(InputWorkspace='monitor3_2', OutputWorkspace='m3_wave', Target='Wavelength')
            name=mtd["m3_wave"]
        else:
            name=None
        
        if name is not None:
            wave=[]
            counts=[]
            counts=name.readY(0)
            _tmp=name.readX(0)
            for j in range(len(_tmp)-1):
                wave.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
            self.neonRedis_write.set("/SANS/workspace/MantidData/"+monitor+"/wavelength", jsonArray.jsonEncoder(wave))
            self.neonRedis_write.set("/SANS/workspace/MantidData/"+monitor+"/intensity", jsonArray.jsonEncoder(counts))
            self.logger.debug("set wave and counts data for "+monitor)
        else:
            self.logger.warning('failed in set wave counts for ', monitor)


    def setMonTofCounts(self, monitor):
        if monitor=='monitor1':
            try:
                SumSpectra(InputWorkspace='monitor1_2', OutputWorkspace="m1_tofCounts", IncludeMonitors=True)
                name=mtd['m1_tofCounts']
            except:
                self.logger.warning('no monitor1 workspace!')
                name=None
        elif monitor == 'monitor2':
            name=mtd['monitor2_2']
        elif monitor == 'monitor3':
            name=mtd['monitor3_2']
        else:
            name=None

        if name is not None:
            tof=[]
            counts=[]
            counts=name.readY(0)
            _tmp=name.readX(0)
            for j in range(len(_tmp)-1):
                tof.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
            self.neonRedis_write.set("/SANS/workspace/MantidData/"+monitor+"/tof", jsonArray.jsonEncoder(tof))
            self.neonRedis_write.set("/SANS/workspace/MantidData/"+monitor+"/counts", jsonArray.jsonEncoder(counts))
            self.logger.debug("set tof and counts data for "+monitor)
        else:
            self.logger.warning('failed in set tof counts for ', monitor)

    def setDetIQ(self):
        Q1D(DetBankWorkspace='sample_wave_PC', OutputWorkspace='sample_Q_PC', OutputBinning='0.001,0.001,2.0', SolidAngleWeighting=True)
        Q1D(DetBankWorkspace='sample_wave_mon', OutputWorkspace='sample_Q_mon', OutputBinning='0.001,0.001,2.0', SolidAngleWeighting=True)
        Q1D(DetBankWorkspace='sample_wave_rebin', OutputWorkspace='sample_Q_raw', OutputBinning='0.001,0.001,2.0', SolidAngleWeighting=True)
        self.set1DData("sample_Q_raw", "/SANS/workspace/MantidData/raw/q","/SANS/workspace/MantidData/raw/intensity")
        self.set1DData("sample_Q_PC", "/SANS/workspace/MantidData/reduction/PC/q","/SANS/workspace/MantidData/reduction/PC/intensity")
        self.set1DData("sample_Q_mon", "/SANS/workspace/MantidData/reduction/monitor/q","/SANS/workspace/MantidData/reduction/monitor/intensity")

        Qxy(InputWorkspace='sample_wave_rebin', OutputWorkspace='sample_Qxy', MaxQxy=0.25, DeltaQ=0.01, SolidAngleWeighting=False)
        self.setIQxy()

    def setDetTofCounts(self):
        SumSpectra(InputWorkspace='sample_1', OutputWorkspace="tofCounts", IncludeMonitors=False)
        Divide(LHSWorkspace="tofCounts", RHSWorkspace="__pro", OutputWorkspace="tofCounts_PC")
        self.set1DData("tofCounts", "/SANS/workspace/MantidData/raw/tof","/SANS/workspace/MantidData/raw/counts")
        self.set1DData("tofCounts_PC", "/SANS/workspace/MantidData/reduction/PC/tof","/SANS/workspace/MantidData/reduction/PC/counts")

    def setDetWaveCounts(self):
        ConvertUnits(InputWorkspace='sample_1', OutputWorkspace='sample_1_wave', Target='Wavelength', AlignBins=True)
        FindCenterOfMassPosition(InputWorkspace="sample_1_wave", Output="beam_center")
        self.setBeamCenter()
        name=mtd["sample_1_wave"]
        w=name.readX(0)
        max_w=w[len(w)-1]
        min_w=w[0]
        step=(max_w-min_w)/100
        self.param_a='0.001,'+str(-step)+','+str(max_w)
        self.logger.warning("wave: "+self.param_a)
        Rebin(InputWorkspace='sample_1_wave', OutputWorkspace='sample_wave_rebin', Params=self.param_a)

        Divide(LHSWorkspace="sample_wave_rebin", RHSWorkspace="__pro", OutputWorkspace="sample_wave_PC")
        SumSpectra(InputWorkspace='sample_wave_PC', OutputWorkspace="waveCounts_PC", IncludeMonitors=False)
        SumSpectra(InputWorkspace='sample_wave_rebin', OutputWorkspace="waveCounts_raw", IncludeMonitors=False)
        Rebin(InputWorkspace="m2_wave", OutputWorkspace="m2", Params=self.param_a)
        Divide(LHSWorkspace="sample_wave_rebin", RHSWorkspace="m2", OutputWorkspace="sample_wave_mon")
        ReplaceSpecialValues(InputWorkspace='sample_wave_mon',OutputWorkspace='waveCounts_mon', NaNValue=0, InfinityValue=0)        
        SumSpectra(InputWorkspace='waveCounts_mon', OutputWorkspace="waveCounts_mon", IncludeMonitors=False)
        self.set1DData("waveCounts_raw", "/SANS/workspace/MantidData/raw/wavelength","/SANS/workspace/MantidData/raw/wcounts")
        self.set1DData("waveCounts_PC", "/SANS/workspace/MantidData/reduction/PC/wavelength","/SANS/workspace/MantidData/reduction/PC/wcounts")
        self.set1DData("waveCounts_mon", "/SANS/workspace/MantidData/reduction/monitor/wavelength","/SANS/workspace/MantidData/reduction/monitor/wcounts")


    def loadWorkspace(self):
        #detector
        npid=len(self.detPid)
        ntof=len(self.detTof)
        nvalue=len(self.detValue)
        if npid*(ntof-1)== nvalue:
            LoadCSNSRaw(OutputWorkspace="sample", PixelID_bank=self.detPid, TimeOfFlight_bank=self.detTof, Counts_bank=self.detValue, PixelID_monitor=[1,2,3], TimeOfFlight_monitor=[0,8], Counts_monitor=[2,4,6])
            LoadInstrument(Workspace="sample_1", Filename=self.instname, RewriteSpectraMap='True')
            #SaveNexus(InputWorkspace='sample_1', Filename='./detector.nxs')
        else:
            self.logger.warning('data does not match for module!')
        #monitor
        npid=len(self.monPid)
        ntof=len(self.monTof)
        nvalue=len(self.mon1Value)
        if npid*(ntof-1)== nvalue:
            LoadCSNSRaw(OutputWorkspace="monitor1", PixelID_bank=[0,1], TimeOfFlight_bank=[0,8], Counts_bank=[1,1], PixelID_monitor=self.monPid, TimeOfFlight_monitor=self.monTof, Counts_monitor=self.mon1Value) 
            LoadInstrument(Workspace="monitor1_2", Filename='./instrument/monitor1.xml', RewriteSpectraMap='True')
            #SaveNexus(InputWorkspace='monitor1_2', Filename='./monitor1.nxs')
        else:
            self.logger.warning('data does not match for monitor1!')
        nvalue=len(self.mon2Value)
        if (ntof-1)== nvalue:
            LoadCSNSRaw(OutputWorkspace="monitor2", PixelID_bank=[0,1], TimeOfFlight_bank=[0,8], Counts_bank=[1,1], PixelID_monitor=[1], TimeOfFlight_monitor=self.monTof, Counts_monitor=self.mon2Value)
            LoadInstrument(Workspace="monitor2_2", Filename='./instrument/monitor2.xml', RewriteSpectraMap='True')
            #SaveNexus(InputWorkspace='monitor2_2', Filename='./monitor2.nxs')
        else:
            self.logger.warning('data does not match for monitor2!')
            nvalue=len(self.mon3Value)
        if (ntof-1)== nvalue:
            LoadCSNSRaw(OutputWorkspace="monitor3", PixelID_bank=[0,1], TimeOfFlight_bank=[0,8], Counts_bank=[1,1], PixelID_monitor=[2], TimeOfFlight_monitor=self.monTof, Counts_monitor=self.mon3Value)
            LoadInstrument(Workspace="monitor3_2", Filename='./instrument/monitor3.xml', RewriteSpectraMap='True')
            #SaveNexus(InputWorkspace='monitor3_2', Filename='./monitor3.nxs')
        else:
            self.logger.warning('data does not match for monitor3!')

        # proton charge 
        proton=self.getProtonCharge()
        CreateSingleValuedWorkspace(OutputWorkspace="__pro", DataValue=proton)

    def setBeamCenter(self):
        value=[]
        wname=mtd["beam_center"]
        x=(wname.row(0))['Value']
        y=(wname.row(1))['Value']
        value.append(x)
        value.append(y)
        _json_v=jsonArray.jsonEncoder(value)
        self.neonRedis_write.set("/SANS/workspace/MantidData/BeamCenter", _json_v)

    def set1DData(self,wsname, path1,path2):
        name=mtd[wsname]
        value=name.readY(0)
        _tmp=name.readX(0)
        x=[]
        y=[]
        for j in range(len(_tmp)-1):
            x.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        for i in value:
            y.append(i)
        self.neonRedis_write.set(path1,jsonArray.jsonEncoder(x))
        self.neonRedis_write.set(path2,jsonArray.jsonEncoder(y))


    def setIQxy(self):
        wname=mtd["sample_Qxy"]
        _tmp=wname.readX(0)
        qxy=[]
        for j in range(len(_tmp)-1):
            qxy.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        numHist=wname.getNumberHistograms()
        intensity=[[] for i in range(numHist)]
        for j in range(numHist):
            _n2=wname.readY(j)
            for p in _n2:
                intensity[j].append(p)
        self.neonRedis_write.set("/SANS/workspace/MantidData/IQxy/x",jsonArray.jsonEncoder(qxy))
        self.neonRedis_write.set("/SANS/workspace/MantidData/IQxy/y",jsonArray.jsonEncoder(qxy))
        self.neonRedis_write.set("/SANS/workspace/MantidData/IQxy/counts",jsonArray.jsonEncoder(intensity))

    
    def setMonXY(self):
        xaxis=[]
        yaxis=[]
        counts=[]
        name=mtd["monitor1_2"]
        for j in range(name.getNumberHistograms()):
            det=name.getDetector(j)
            pos=det.getRelativePos()
            xaxis.append(pos.X())
            yaxis.append(pos.Y())
            counts.append(sum(name.readY(j)))
        xaxis=list(set(xaxis))
        yaxis=list(set(yaxis))
        xaxis.sort()
        yaxis.sort()
        for i in range(len(xaxis)):
            xaxis[i]=xaxis[i]*1000
        for i in range(len(yaxis)):
            yaxis[i]=yaxis[i]*1000

        vaxis=[[] for m in range(len(yaxis))]
        n=0
        for j in range(len(yaxis)):
            for k in range(len(xaxis)):
                vaxis[j].append(counts[n])
                n=n+1
        self.neonRedis_write.set("/SANS/workspace/MantidData/monitor1/xy_image/x",jsonArray.jsonEncoder(xaxis))
        self.neonRedis_write.set("/SANS/workspace/MantidData/monitor1/xy_image/y",jsonArray.jsonEncoder(yaxis))
        self.neonRedis_write.set("/SANS/workspace/MantidData/monitor1/xy_image/value",jsonArray.jsonEncoder(vaxis))
        self.logger.debug("set xy data for  monitor1 !!!")

    def setDetXY(self):
        name=mtd["sample_1"]
        counts=[]
        xaxis=[]
        yaxis=[]
        for j in range(name.getNumberHistograms()):
            _det=name.getDetector(j)
            _pos=_det.getRelativePos()
            xaxis.append(_pos.X()-0.004)
            yaxis.append(_pos.Y()-0.004)
            counts.append(sum(name.readY(j)))
        xaxis=list(set(xaxis))
        yaxis=list(set(yaxis))
        xaxis.sort()
        yaxis.sort()
        xaxis.append(xaxis[-1]+0.008)
        yaxis.append(yaxis[-1]+0.008)
        for i in range(len(xaxis)):
            xaxis[i]=xaxis[i]*1000-500
        for i in range(len(yaxis)):
            yaxis[i]=yaxis[i]*1000-500
        vaxis=[[] for r in range(len(yaxis)-1)]
        num=0
        for p in range(len(yaxis)-1):
            for q in range(len(xaxis)-1):
                vaxis[p].append(counts[num])
                num=num+1
        self.neonRedis_write.set("/SANS/workspace/MantidData/xy_image/x", jsonArray.jsonEncoder(xaxis))
        self.neonRedis_write.set("/SANS/workspace/MantidData/xy_image/y", jsonArray.jsonEncoder(yaxis))
        self.neonRedis_write.set("/SANS/workspace/MantidData/xy_image/value", jsonArray.jsonEncoder(vaxis))
        self.logger.debug("set XY bank!")
        # set 128 tubes
        #nx=126
        #ny=2
        for num in range(120):
            Y=[]
            Y.append(yaxis[num])
            Y.append(yaxis[num+1])
            Z=[[] for r in range(1)]
            for p in range(1):
                Z[p].extend(vaxis[num])
            _p1="/SANS/workspace/MantidData/tube"+str(num+1)+"/xy_image/x"
            _p2="/SANS/workspace/MantidData/tube"+str(num+1)+"/xy_image/y"
            _p3="/SANS/workspace/MantidData/tube"+str(num+1)+"/xy_image/value"
            self.neonRedis_write.set(_p1,jsonArray.jsonEncoder(xaxis))
            self.neonRedis_write.set(_p2,jsonArray.jsonEncoder(Y))
            self.neonRedis_write.set(_p3,jsonArray.jsonEncoder(Z))
        self.logger.debug("finish XY for 120 tubes!")

    def getData(self):
        # module data
        self.processCommand()
        self.detTof=[]
        self.detTof=self.get1Ddata(self.neonpathDetTof[0])
        npid=len(self.detPid)
        ntof=len(self.detTof)
        self.detValue=[]
        try:
            for i in range(10):
                self.detValue.extend(self.get2Ddata(self.neonpathDetValue[i]))
        except:
            self.logger.warning("no data for module")
            for i in range(npid*(ntof-1)):
                self.detValue.append(0)
        self.neonRedis_write.set("/SANS/workspace/MantidData/neutroncounts",json.dumps(sum(self.detValue)))
        self.setHB()
        self.logger.debug('finish get detector data!')
        # monitor data 
        self.processCommand()
        self.monTof=[]
        self.monTof=self.get1Ddata("/SANS/workspace/monitor2/tof")
        self.mon1Value=[]
        self.mon2Value=[]
        self.mon3Value=[]
        try:
            self.mon1Value=self.get2Ddata("/SANS/workspace/monitor1/value")
        except:
            self.logger.warning("no data for monitor1")
            for i in range(npid*(ntof-1)):
                self.mon1Value.append(0)
        try:
            self.mon2Value=self.get2Ddata("/SANS/workspace/monitor2/value")
        except:
            self.logger.warning("no data for monitor2")
            for i in range(len(self.monTof)-1):
                self.mon2Value.append(0)
        try:
            self.mon3Value=self.get2Ddata("/SANS/workspace/monitor3/value")
        except:
            self.logger.warning("no data for monitor3")
            for i in range(len(self.monTof)-1):
                self.mon3Value.append(0)
        self.neonRedis_write.set("/SANS/workspace/MantidData/monitor1/neutroncounts",json.dumps(sum(self.mon1Value)))
        self.neonRedis_write.set("/SANS/workspace/MantidData/monitor2/neutroncounts",json.dumps(sum(self.mon2Value)))
        self.neonRedis_write.set("/SANS/workspace/MantidData/monitor3/neutroncounts",json.dumps(sum(self.mon3Value)))
        self.logger.debug('finish get monitor data!')
        self.setHB()


    def clearData(self):
        clearList=[]

        path='/SANS/workspace/MantidData/neutroncounts'
        clearList.append(path)
        path='/SANS/workspace/MantidData/monitor2/neutroncounts'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/xy_image/x'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/xy_image/y'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/xy_image/value'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/raw/tof'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/raw/counts'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/raw/wavelength'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/raw/wcounts'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/raw/q'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/raw/intensity'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/reduction/monitor/q'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/reduction/monitor/intensity'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/reduction/PC/q'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/reduction/PC/intensity'
        clearList.append(path)
        path = '/SANS/workspace/MantidData/BeamCenter'
        clearList.append(path)
        for _tube in range(120):
            path = '/SANS/workspace/MantidData/tube' + str(_tube) + '/xy_image/x'
            clearList.append(path)
            path = '/SANS/workspace/MantidData/tube' + str(_tube) +'/xy_image/y'
            clearList.append(path)
            path = '/SANS/workspace/MantidData/tube' + str(_tube) +'/xy_image/value'
            clearList.append(path)
            path = '/SANS/workspace/MantidData/tube' + str(_tube) + '/tof'
            clearList.append(path)
            path = '/SANS/workspace/MantidData/tube' + str(_tube) + '/counts'
            clearList.append(path)
        path = '/SANS/workspace/MantidData/IQxy/x'


    def process(self):
        be=time.time()
        self.processCommand()
        if self.myDict['running']:
            self.getData()
            self.logger.debug("1: "+str(time.time()-be)+' seconds')
            if self.myDict['running']:
                self.processWorkspace()
                self.logger.debug('2:'+str(time.time()-be)+' seconds')
            else:
                pass        
        else:
            pass
        self.setHB()

    def run(self):            
        while True:
            self.process()
            #self.logger.debug(str(self.myDict['running']))
            time.sleep(self.refreshtime)
            #time.sleep(10)

