from mantid.simpleapi import *
import jsonArray
import time
import datetime
import json
#import multiprocessing
import threading
from multiprocessing import Process, Manager
import numpy
import shutil
#import logging
import math
import path
#class moduleIO(multiprocessing.Process):
class neonIO(threading.Thread):
    def __init__(self, neonRedis_write, neonRedis_read, refreshtime,detPixels,monPixels,tofbins,myDict, logger):
        super(neonIO, self).__init__()
        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis_write
        self.neonRedis_read=neonRedis_read
        self.myDict=myDict
        self.logger=logger
        self.confJudge=True
        self.detValue=[]
        self.monValue=[]
        self.detPixels=detPixels
        self.monPixels=monPixels
        self.tofbins=tofbins

    def getConf(self):
        be=time.time()
        path="/MR/control/configure"
        _json=self.neonRedis_read.get(path)
        _conf=json.loads(_json)
        return _conf

    def getROIcommand(self):
        #dict, pos=[x1,y1,x2,y2], roi=true or false
        path="/MR/workspace/MantidData/roi"
        _json=self.neonRedis_read.get(path)
        if _json is None:
            tmp={}
            tmp['roi']=False
            return tmp
        else:
            _tmp=jsonArray.jsonDecoder(_json)
            return _tmp

    def get1Ddata(self,path):
        data=[]
        _json=self.neonRedis_read.get(path)
        data=jsonArray.jsonDecoder(_json)
        return data

    def getDataFromNeon(self, path1, path2):
        #path1 is value to get, path2 is neutron counts to set
        be=time.time()
        value = []
        _json=self.neonRedis_read.get(path1)
        while _json is None:
            self.logger.warning("no 2D data in "+path1+str(datetime.datetime.now()))
            _json=self.neonRedis_read.get(path1)
            time.sleep(20)
        _array=jsonArray.jsonDecoder(_json)
        a=0
        for ix in _array:
            a=a+sum(ix)
            for iy in ix:
                value.append(iy)
        self.neonRedis_write.set(path2, json.dumps(a))
        return value

    def getProtonCharge(self):
        data=[]
        path="/MR/drone/proton_charge"
        _json=self.neonRedis_read.get(path)
        data=jsonArray.jsonDecoder(_json)
        val=data[1][-1]
        if(type(val)==int):
            if val == 0:
                return 1
            else:
                return val
        else:
            return 1

    def createWorkspace(self):
        be=time.time()
        #print len(self.detPid), len(self.tof), len(self.detValue), len(self.monPid), len(self.monValue)
        if self.detJudge:
            #LoadCSNSRaw(OutputWorkspace="sample", PixelID_bank=self.detPid, TimeOfFlight_bank=self.tof, Counts_bank=self.detValue, PixelID_monitor=self.monPid, TimeOfFlight_monitor=self.tof, Counts_monitor=self.monValue)
            LoadCSNSRaw(OutputWorkspace="sample", PixelID_bank=self.detPid, TimeOfFlight_bank=self.tof, Counts_bank=self.detValue, PixelID_monitor=[0,1], TimeOfFlight_monitor=[8,16], Counts_monitor=[1,1])
            LoadInstrument(Workspace="sample_1", Filename='./instrument/detector_real.xml', RewriteSpectraMap='True')
            SaveNexus(InputWorkspace='sample_1', Filename='./detector.nxs')
            RotateInstrumentComponent(Workspace="sample_1", ComponentName="Bank01", X=0, Y=1, Z=0, Angle=self.angle)
        else:
            pass
        if self.monJudge:
            LoadCSNSRaw(OutputWorkspace="monitor", PixelID_bank=[0,1], TimeOfFlight_bank=[8,16], Counts_bank=[1,1], PixelID_monitor=self.monPid, TimeOfFlight_monitor=self.tof, Counts_monitor=self.monValue)
            # monitor
            LoadInstrument(Workspace="monitor_2", Filename='./instrument/monitor01.xml', RewriteSpectraMap='True')
            SaveNexus(InputWorkspace='sample_2', Filename='./monitor1.nxs')
            #get I-tof I-wave
            #ConvertUnits(InputWorkspace='monitor_2',OutputWorkspace='__tmpD2',Target='dSpacing',AlignBins=True)
            ConvertUnits(InputWorkspace='monitor_2',OutputWorkspace='__tmpW2',Target='Wavelength',AlignBins=True)
            SumSpectra(InputWorkspace='__tmpW2', OutputWorkspace="MwaveCounts", IncludeMonitors=True)
            SumSpectra(InputWorkspace='monitor_2', OutputWorkspace="MtofCounts", IncludeMonitors=True)

            #SumSpectra(InputWorkspace='__tmpD2', OutputWorkspace="__tmpD2", IncludeMonitors=True)
            #ConvertUnits(InputWorkspace='__tmpD2',OutputWorkspace='MtofCounts',Target='TOF',AlignBins=True)
            #ConvertUnits(InputWorkspace='__tmpD2',OutputWorkspace='MwaveCounts',Target='Wavelength',AlignBins=True)
        else:
            pass
    def wsProcess(self, wsname):
        if self.detJudge:
            #get I-q I-tof
            #ConvertUnits(InputWorkspace=wsname,OutputWorkspace='__tmpD',Target='dSpacing',AlignBins=True)
            ConvertUnits(InputWorkspace=wsname,OutputWorkspace='__tmpW',Target='Wavelength',AlignBins=True)
            SumSpectra(InputWorkspace='__tmpW', OutputWorkspace="waveCounts", IncludeMonitors=False)
            SumSpectra(InputWorkspace=wsname, OutputWorkspace="tofCounts", IncludeMonitors=False)
            #SumSpectra(InputWorkspace='__tmpD', OutputWorkspace="__tmpD", IncludeMonitors=False)
            #ConvertUnits(InputWorkspace='__tmpD',OutputWorkspace='tofCounts',Target='TOF',AlignBins=True)

            #ConvertUnits(InputWorkspace='__tmpD',OutputWorkspace='qCounts',Target='MomentumTransfer',AlignBins=True)
            #Rebin(InputWorkspace="tofCounts",OutputWorkspace="tofCounts", Params='0,16,40000')
        else:
            pass

    def reduction(self):
        Rebin(InputWorkspace="MwaveCounts",OutputWorkspace="W2_rebin", Params='0.001,0.01,8')
        Rebin(InputWorkspace="waveCounts",OutputWorkspace="W_rebin", Params='0.001,0.01,8')
        Divide(LHSWorkspace="W_rebin", RHSWorkspace="W2_rebin", OutputWorkspace="nor_sam_wave")
        ConvertUnits(InputWorkspace='nor_sam_wave',OutputWorkspace='qCounts_M',Target='MomentumTransfer',AlignBins=True)
        proton=self.getProtonCharge()
        print proton
        print type(proton)
        CreateSingleValuedWorkspace(OutputWorkspace="__pro", DataValue=proton)
        Divide(LHSWorkspace="W_rebin", RHSWorkspace="__pro", OutputWorkspace="nor_sam_wave")
        ConvertUnits(InputWorkspace='nor_sam_wave',OutputWorkspace='qCounts_P',Target='MomentumTransfer',AlignBins=True)

    def setIQdataToNeon(self, wsname, path1, path2):
        name=mtd[wsname]
        tmpx=[]
        tmpv=[]
        tmpv=name.readY(0)
        _tmp=name.readX(0)
        for j in range(len(_tmp)-1):
            tmpx.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        #x=[]
        v=[]
        for ix in tmpv:
            v.append(ix)

        for i in range(len(tmpv)):
            if not numpy.isnan(tmpv[i]) and numpy.isfinite(tmpv[i]):
                pass
            else:
                v[i]=0
        self.neonRedis_write.set(path1, jsonArray.jsonEncoder(tmpx))
        self.neonRedis_write.set(path2, jsonArray.jsonEncoder(v))

    def set1DdataToNeon(self,wsname, path1, path2):
        name=mtd[wsname]
        x=[]
        v=[]
        v=name.readY(0)
        _tmp=name.readX(0)
        for j in range(len(_tmp)-1):
            x.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        self.neonRedis_write.set(path1, jsonArray.jsonEncoder(x))
        self.neonRedis_write.set(path2, jsonArray.jsonEncoder(v))

    def setPidCounts(self):
        pid=[]
        counts=[]
        name=mtd['sample_1']
        for j in range(name.getNumberHistograms()):
            pid.append(j)
            counts.append(sum(name.readY(j)))
        path1="/MR/workspace/MantidData/reduction/monitor/Itof/tof"
        path2 = "/MR/workspace/MantidData/reduction/monitor/Itof/counts"
        #path1="/MR/workspace/MantidData/detector/pid"
        #path2 = "/MR/workspace/MantidData/detector/counts"
        self.neonRedis_write.set(path1, jsonArray.jsonEncoder(pid))
        self.neonRedis_write.set(path2, jsonArray.jsonEncoder(counts))
        self.logger.debug("set pid counts for detector")

    def setItheta(self, wsname, start, step, bins, prepath):
        wname=mtd[wsname]
        counts=[]
        scaAngle=[]
        theta=[]
        for i in range(bins):
            scaAngle.append(start+step*i)
            counts.append(0)
        inst=wname.getInstrument()
        source=inst.getSource()
        sourcePos=source.getPos()
        sam=inst.getSample()
        samPos=sam.getPos()
        beamline=samPos-sourcePos
        numHist=wname.getNumberHistograms()
        for j in range(numHist):
            n2=sum(wname.readY(j))
            det=wname.getDetector(j)
            twoTheta=180/math.pi*det.getTwoTheta(samPos, beamline)
            theta.append(twoTheta)
            for i in range(len(scaAngle)-1):
                if twoTheta>=scaAngle[i] and twoTheta<scaAngle[i+1]:
                    counts[i]=counts[i]+n2
                else:
                    continue
        self.neonRedis_write.set(prepath+"raw/Itheta/theta",jsonArray.jsonEncoder(scaAngle))
        self.neonRedis_write.set(prepath+"raw/Itheta/counts",jsonArray.jsonEncoder(counts))
        self.logger.debug("set raw data for I-theta ")
        return theta

    def setIQxyz(self, theta):
        Rebin(InputWorkspace="sample_1",OutputWorkspace="__rebin", Params='0,64,40000')
        ConvertUnits(InputWorkspace='__rebin',OutputWorkspace='__rebin',Target='MomentumTransfer', AlignBins=False)
        wname=mtd['__rebin']
        qx=[]
        qy=[]
        qz=[]
        qv=[]
        for j in range(wname.getNumberHistograms()):
            det=wname.getDetector(j)
            twoTheta=theta[j]
            x=(det.getPos()).X()
            y=(det.getPos()).Y()
            cphi=math.cos(math.atan(y/x))
            sphi=math.sin(math.atan(y/x))
            stheta=math.sin(math.pi/180*twoTheta*0.5+math.pi/2.0)
            ctheta=math.cos(math.pi/180*twoTheta*0.5+math.pi/2.0)
            q_tmp=wname.readX(j)
            for k in range(len(q_tmp)-1):
                qx.append(q_tmp[k]*stheta*cphi)
                qy.append(q_tmp[k]*stheta*sphi)
                qz.append(q_tmp[k]*ctheta)
            value=wname.readY(j)
            for t in value:
                qv.append(t)
        self.neonRedis_write.set("/MR/workspace/MantidData/IQxyz/x",jsonArray.jsonEncoder(qx))
        self.neonRedis_write.set("/MR/workspace/MantidData/IQxyz/y",jsonArray.jsonEncoder(qy))
        self.neonRedis_write.set("/MR/workspace/MantidData/IQxyz/z",jsonArray.jsonEncoder(qz))
        self.neonRedis_write.set("/MR/workspace/MantidData/IQxyz/counts",jsonArray.jsonEncoder(qv))
        self.logger.debug("finish set IQxyz raw")

    def setXYData(self, wsname, prepath):
        counts=[]
        xaxis=[]
        yaxis=[]
        name=mtd[wsname]
        for j in range(name.getNumberHistograms()):
            counts.append(sum(name.readY(j)))
            #_det=name.getDetector(j)
            _pos=name.getDetector(j).getRelativePos()
            xaxis.append(_pos.X())
            yaxis.append(_pos.Y())
        xaxis=list(set(xaxis))
        yaxis=list(set(yaxis))
        xaxis.sort()
        yaxis.sort()
        for i in range(len(xaxis)):
            xaxis[i]=xaxis[i]*1000
        for i in range(len(yaxis)):
            yaxis[i]=yaxis[i]*1000
        vaxis=[[] for r in range(len(yaxis))]
        num=0
        for p in range(len(yaxis)):
            for q in range(len(xaxis)):
                vaxis[p].append(counts[num])
                num=num+1
        yaxis.append(yaxis[-1]+(yaxis[-1]-yaxis[-2]))
        xaxis.append(xaxis[-1]+(xaxis[-1]-xaxis[-2]))
        self.neonRedis_write.set(prepath+"/xy_image/x", jsonArray.jsonEncoder(xaxis))
        self.neonRedis_write.set(prepath+"/xy_image/y", jsonArray.jsonEncoder(yaxis))
        self.neonRedis_write.set(prepath+"/xy_image/value", jsonArray.jsonEncoder(vaxis))
        self.logger.debug("finish set XY data for monitor or detector")


    def roiProcess(self, pos):
        name=mtd['sample_1']
        XYdata=[[] for i in range(2)]
        for j in range(name.getNumberHistograms()):
            XYdata[0].append(name.getDetector(j).getRelativePos().X())
            XYdata[1].append(name.getDetector(j).getRelativePos().X())
        index=[]
        for i in range(len(XYdata[0])):
            if XYdata[1][i]>=pos[0] and XYdata[1][i]<=pos[2] and XYdata[2][i]>=pos[3] and XYdata[2][i] <=pos[1]:
                index.append(i)
        ExtractSpectra(InputWorkspace='sample_1', OutputWorkspace='roiWS', WorkspaceIndexList=index)


    def setTubeData(self, wsname):
        name=mtd[wsname]
        counts=[]
        xpos=[]
        ypos=[]
        xpos2=[]
        for j in range(name.getNumberHistograms()):
            counts.append(sum(name.readY(j)))
            _pos=name.getDetector(j).getRelativePos()
            xpos.append(_pos.X())
            ypos.append(_pos.Y())
        xpos=list(set(xpos))
        ypos=list(set(ypos))
        xpos.sort()
        ypos.sort()
        for i in range(len(xpos)):
            xpos[i]=xpos[i]*1000
        for i in range(len(ypos)):
            ypos[i]=ypos[i]*1000

        xsize=len(xpos)
        ystep=ypos[1]-ypos[0]
        for n in xpos:
            xpos2.append(n)
        xpos2.append(xpos[-1]+(xpos[-1]-xpos[-2]))
        # set 4 tubes xpos-counts
        for num in range(4):
            Y=[]
            Y.append(ypos[num]-ystep/2)
            Y.append(ypos[num]+ystep/2)
            Z=[[] for i in range(1)]
            Z[0]=counts[num*xsize:num*xsize+xsize]
            prepath="/MR/workspace/MantidData/detector/xy_image/tube"+str(num+1)
            self.neonRedis_write.set(prepath+"/pos",jsonArray.jsonEncoder(xpos))
            self.neonRedis_write.set(prepath+"/counts",jsonArray.jsonEncoder(counts[num*xsize:num*xsize+xsize]))
            self.neonRedis_write.set(prepath+"/x",jsonArray.jsonEncoder(xpos2))
            self.neonRedis_write.set(prepath+"/y",jsonArray.jsonEncoder(Y))
            #self.neonRedis_write.set(prepath+"/z",jsonArray.jsonEncoder(counts[num*xsize:num*xsize+xsize]))
            self.neonRedis_write.set(prepath+"/z",jsonArray.jsonEncoder(Z))
        self.logger.debug("finish XY for 4 tubes")

    def dataSet(self):
        if self.confRoi['roi']:
            self.set1DdataToNeon("tofCounts", "/MR/workspace/MantidData/ROI/raw/Itof/tof","/MR/workspace/MantidData/ROI/raw/Itof/counts")
            self.set1DdataToNeon("waveCounts", "/MR/workspace/MantidData/ROI/raw/Iwave/wavelength","/MR/workspace/MantidData/ROI/raw/Iwave/counts")
            self.setIQdataToNeon("qCounts_M", "/MR/workspace/MantidData/ROI/reduction/monitor/IQ/q","/MR/workspace/MantidData/ROI/reduction/monitor/IQ/counts")
            self.setIQdataToNeon("qCounts_P", "/MR/workspace/MantidData/ROI/reduction/PC/IQ/q","/MR/workspace/MantidData/ROI/reduction/PC/IQ/counts")
            tmp=self.setItheta("roiWS", 7, 0.1, 50, "/MR/workspace/MantidData/ROI/")
        else:
            if self.detJudge:
                self.set1DdataToNeon("tofCounts", "/MR/workspace/MantidData/raw/Itof/tof","/MR/workspace/MantidData/raw/Itof/counts")
                self.setIQdataToNeon("qCounts_M", "/MR/workspace/MantidData/reduction/monitor/IQ/q","/MR/workspace/MantidData/reduction/monitor/IQ/counts")
                self.setIQdataToNeon("qCounts_P", "/MR/workspace/MantidData/reduction/PC/IQ/q","/MR/workspace/MantidData/reduction/PC/IQ/counts")
                self.set1DdataToNeon("waveCounts", "/MR/workspace/MantidData/raw/Iwave/wavelength","/MR/workspace/MantidData/raw/Iwave/counts")
            else:
                pass
        if self.monJudge:
            self.set1DdataToNeon("MtofCounts", "/MR/workspace/MantidData/monitor1/tof","/MR/workspace/MantidData/monitor1/counts")
            self.logger.warning("finish set monitor1 tof counts")
            self.set1DdataToNeon("MwaveCounts", "/MR/workspace/MantidData/monitor1/wave","/MR/workspace/MantidData/monitor1/wcounts")
            self.logger.warning("finish set monitor1 wave counts")
            self.setXYData("monitor_2", "/MR/workspace/MantidData/monitor1")

        else:
            pass
        # For Tab1 and Tab4 2D data: detector XY hot, monitor XY hot
        if self.detJudge:
            self.setXYData("sample_1", "/MR/workspace/MantidData/detector")
            # For Tab2 and Tab3 1D and 2D data: tube pos-counts and XY hot
            self.setTubeData("sample_1")
            # set Tab1 pid counts
            self.setPidCounts()
            # set Tab1 Itheta
            theta=[]
            theta=self.setItheta("sample_1", 7, 0.1, 50, "/MR/workspace/MantidData/")
            # set Tab6 IQxyz
            self.setIQxyz(theta)
        else:
            pass

    def process(self):
        if self.myDict['configure']:
            if self.confJudge:
                self.tof=[]
                self.detPid=[]
                self.monPid=[]
                try:
                    self.detPid=self.get1Ddata("/MR/workspace/detector/module01/pid")
                    self.tof=self.get1Ddata("/MR/workspace/detector/module01/tof")
                    self.detJudge=True
                except:
                    self.logger.warning("no data in get pid and tof for detector")
                    self.detJudge=False
                try:
                    self.monPid=self.get1Ddata("/MR/workspace/monitor1/pid")
                    self.tof=self.get1Ddata("/MR/workspace/monitor1/tof")
                    self.monJudge=True
                except:
                    self.logger.warning("no data in get pid and tof for monitor")
                    self.monJudge=False
                try:
                    self.conf=self.getConf()
                    self.angle=float(self.conf["detectorAngle"])
                except:
                    self.angle = 0
                self.logger.warning("angle="+str(self.angle))
                path.clearRedis(self.neonRedis_write)
                self.logger.debug("finish new configuring")
                self.confJudge=False
            else:
                pass
        else:
            self.confJudge=True
        
        if self.myDict['running']:
            be=time.time()
            self.logger.debug("start running program")
            try:
                self.detValue=self.getDataFromNeon("/MR/workspace/detector/module01/value", "/MR/workspace/MantidData/neutroncounts")
                self.detJudge=True
            except:
                self.logger.warning("no data in get data from neon for detector")
                self.detJudge=False
            try:
                self.monValue=self.getDataFromNeon("/MR/workspace/monitor1/value", "/MR/workspace/MantidData/monitor/neutroncounts")
                self.monJudge=True
            except:
                self.logger.warning("no data in get data from neon for monitor")
                self.monJudge=False
            if self.myDict['running']:
                if self.detJudge:
                    if (len(self.detValue)!=(len(self.tof)-1)*len(self.detPid)):
                        self.logger.warning("data size doesn't match for detector")
                        self.detJudge=False                        
                else:
                    pass
                if self.monJudge:
                    if(len(self.monValue)!=(len(self.tof)-1)*len(self.monPid)):
                        self.logger.warning("data size doesn't match for monitor")
                        self.monJudge=False
                if self.myDict['running']:
                    #try:
                    self.createWorkspace()
                    '''
                    except:
                        self.myDict['error']=True
                        self.myDict['running']=False
                        self.logger.error("error in create workspace!")
                    '''
                    self.confRoi=self.getROIcommand()
                    if self.myDict['running']:
                        if self.confRoi['roi']:
                            self.roiProcess(self.confRoi['pos'])
                            self.wsProcess('roiWS')
                        else:
                            self.wsProcess('sample_1')
                        #try:
                        self.reduction()
                        self.dataSet()
                        try:
                            shutil.move("./detector.nxs","./tmp/detetor.nxs" )
                        except:
                            self.logger.warning("no detector nexus file!!!")
                        try:
                            shutil.move("./monitor1.nxs","./tmp/monitor1.nxs" )
                        except:
                            self.logger.warning("no monitor nexus file!!!")

                        #DeleteWorkspace(Workspace='sample')
                        self.logger.debug("time is "+str(time.time()-be)+" seconds!!!")
                    '''
                    except:
                        self.myDict['error']=True
                        self.myDict['running']=False
                        self.logger.error("error in set data!")
                    '''
                else:
                    pass
            else:
                pass
        else:
            pass

    def run(self):
        while True:
            self.detJudge=True
            self.monJudge=True
            self.process()
            time.sleep(0.5)

