import jsonArray
import time
from multiprocessing import Process, Manager
import threading
import json
import logging

class getCommand(threading.Thread):
    def __init__(self, neonRedis_write, neonRedis_read, refreshtime,myDict, logger):
        super(getCommand, self).__init__()
        self.neonRedis_write = neonRedis_write
        self.neonRedis_read = neonRedis_read
        self.refreshtime = refreshtime
        self.myDict=myDict
        self.logger=logger
        self.command=-1
        self.commandList=['configure','unconfigure','start','pause','resume','stop','abort']
        self.statusList=['waiting','unconfigured','configuring','ready','running','paused','error']

    def getCommand(self):
        #_path="/MR/control/test"
        _path="/MR/control/command/mantid"
        try:
            _json=self.neonRedis_read.get(_path)
            _data=int(json.loads(_json))
        except:
            _data=-1
        return _data

    def setCommand(self, command):
        self.command=command

    def setStatus(self, status):
        path="/MR/stateMachine/status"
        self.neonRedis_write.set(path, json.dumps(status))
    
    def getStatus(self):
        path="/MR/stateMachine/status"
        _json=self.neonRedis_read.get(path)
        data=int(json.loads(_json))
        return data

    def clearData(self):
        clearList=[]

        path='/MR/workspace/MantidData/neutroncounts'
        clearList.append(path)
        path='/MR/workspace/MantidData/neutroncounts1'
        clearList.append(path)
        path='/MR/workspace/MantidData/neutroncounts2'
        clearList.append(path)
        path='/MR/workspace/MantidData/neutroncounts3'
        clearList.append(path)
        path='/MR/workspace/MantidData/neutroncounts4'
        clearList.append(path)
        path='/MR/workspace/MantidData/monitor/neutroncounts'
        clearList.append(path)

        for i in range (3):
            path = '/MR/workspace/MantidData/detector/xy_image/tube' + str(i + 1) + '/x'
            clearList.append(path)
            path = '/MR/workspace/MantidData/detector/xy_image/tube' + str(i + 1) + '/y'
            clearList.append(path)
            path = '/MR/workspace/MantidData/detector/xy_image/tube' + str(i + 1) + '/z'
            clearList.append(path)
        
        path = '/MR/workspace/MantidData/ROI/raw/Itof/tof'
        clearList.append(path)
        path = '/MR/workspace/MantidData/ROI/raw/Itof/counts'
        clearList.append(path)
        path = '/MR/workspace/MantidData/raw/Itof/tof'
        clearList.append(path)
        path = '/MR/workspace/MantidData/raw/Itof/counts'
        clearList.append(path)
        path = '/MR/workspace/MantidData/ROI/raw/Itheta/theta'
        clearList.append(path)
        path = '/MR/workspace/MantidData/ROI/raw/Itheta/counts'
        clearList.append(path)
        path = '/MR/workspace/MantidData/raw/Itheta/theta'
        clearList.append(path)
        path = '/MR/workspace/MantidData/raw/Itheta/counts'
        clearList.append(path)
        path = '/MR/workspace/MantidData/ROI/raw/Iwave/wavelength'
        clearList.append(path)
        path = '/MR/workspace/MantidData/ROI/raw/Iwave/counts'
        clearList.append(path)
        path = '/MR/workspace/MantidData/raw/Iwave/wavelength'
        clearList.append(path)
        path = '/MR/workspace/MantidData/raw/Iwave/counts'
        clearList.append(path)
        path = '/MR/workspace/MantidData/ROI/reduction/monitor/IQ/q'
        clearList.append(path)
        path = '/MR/workspace/MantidData/ROI/reduction/monitor/IQ/counts'
        clearList.append(path)
        path = '/MR/workspace/MantidData/reduction/monitor/IQ/q'
        clearList.append(path)
        path = '/MR/workspace/MantidData/reduction/monitor/IQ/counts'
        clearList.append(path)
        path = '/MR/workspace/MantidData/ROI/reduction/PC/IQ/q'
        clearList.append(path)
        path = '/MR/workspace/MantidData/ROI/reduction/PC/IQ/counts'
        clearList.append(path)
        path = '/MR/workspace/MantidData/reduction/PC/IQ/q'
        clearList.append(path)
        path = '/MR/workspace/MantidData/reduction/PC/IQ/counts'
        clearList.append(path)
        
        for i in range(4):
            path = '/MR/workspace/MantidData/detector/xy_image/tube' + str(i + 1) + '/pos'
            clearList.append(path)
            path = '/MR/workspace/MantidData/detector/xy_image/tube' + str(i + 1) + '/counts'
            clearList.append(path)
            path = '/MR/workspace/MantidData/detector/xy_image/tube' + str(i + 1) + '/x'
            clearList.append(path)
            path = '/MR/workspace/MantidData/detector/xy_image/tube' + str(i + 1) + '/y'
            clearList.append(path)
            path = '/MR/workspace/MantidData/detector/xy_image/tube' + str(i + 1) + '/z'
            clearList.append(path)

        path = '/MR/workspace/MantidData/monitor1/xy_image/x'
        clearList.append(path)
        path = '/MR/workspace/MantidData/monitor1/xy_image/y'
        clearList.append(path)
        path = '/MR/workspace/MantidData/monitor1/xy_image/value'
        clearList.append(path)
        path = '/MR/workspace/MantidData/monitor1/tof'
        clearList.append(path)
        path = '/MR/workspace/MantidData/monitor1/counts'
        clearList.append(path)
        path = '/MR/workspace/MantidData/monitor1/wave'
        clearList.append(path)
        path = '/MR/workspace/MantidData/monitor1/wcounts'
        clearList.append(path)
                             
        for p in clearList:
            #try:
            self.neonRedis_write.delete(p)
            #except:
            #    pass

    def stateMachine(self, command, status, commandList, statusList,myDict):

        if command == 0:
            if status == 1:
                self.clearData()
                myDict["configure"]= True
                status = 3
            else:
                print statusList[status]+" status cannot receive "+commandList[command]+" command"

        elif command == 1:
            if status == 3:
                myDict["configure"]=False
                status = 1
            else:
                print statusList[status]+" status cannot receive "+commandList[command]+" command"

        elif command == 2:
            if status == 3:
                self.clearData()
                myDict["running"]=True
                status = 4
            else:
                print statusList[status]+" status cannot receive "+commandList[command]+" command"

        elif command == 3:
            if status == 4:
                myDict['running']=False
                status = 5
            else:
                print statusList[status]+" status cannot receive "+commandList[command]+" command"

        elif command == 4:
            if status == 5:
                myDict['running']=True
                status = 4
            else:
                print statusList[status]+" status cannot receive "+commandList[command]+" command"
            

        elif command == 5:
            if status == 4:
                myDict['running']= False
                status = 3
            else:
                print statusList[status]+" status cannot receive "+commandList[command]+" command"

        elif command == 6:
            myDict['running']=False
            myDict['configure']=False
            myDict['error']=False
            status = 1
        else:
            pass

        return status

    def process(self):
        while True:
            if self.myDict['error']:
                status = 6
                self.setStatus(status)

            _command=self.getCommand()
            while type(_command)!=int:
                print "the type of command is not int!!!"
                time.sleep(5)
                _command=self.getCommand()
            if self.command==_command:
                pass
            else:
                self.setCommand(_command)
                print "new command: ", self.command
                status=self.getStatus()
                print "before statemachine: ", status
                tmp=self.stateMachine(self.command, status, self.commandList, self.statusList, self.myDict)
                self.setStatus(tmp)
                print "after statemachine: ",tmp
            time.sleep(self.refreshtime)

    def run(self):
        self.process()
