from mantid.simpleapi import *
import time
import jsonArray
import numpy as np
import redis
import sys
import math
from math import sqrt
#import matplotlib.pyplot as plt

def setBankRawI(neonRedis):    
    be=time.time()
    # set I-tof raw data for roi
    name=mtd['sample_rebin']
    num=name.getNumberHistograms()
    res=[[] for i in range(num)]
    for i in range(num):
        y=name.readY(i)
        res[i]=y
    t2=name.readX(0)
    t3=[]
    for j in range(len(t2)-1):
        t3.append(t2[j]+(t2[j+1]-t2[j])/2)
    pp1="/MR/workspace/MantidData/tmp/Itof/raw/tof"
    pp2="/MR/workspace/MantidData/tmp/Itof/raw/value"
    _j_t=jsonArray.jsonEncoder(t3)
    _j_v=jsonArray.jsonEncoder(res)
    neonRedis.set(pp1,_j_t)
    neonRedis.set(pp2,_j_v)
    print "set raw data for I-tof ROI"    
    # I-tof
    wname=mtd["sample_tof"]
    _tmp=wname.readX(0)
    tof=[]
    for j in range(len(_tmp)-1):
        tof.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
    value=wname.readY(0)
    _json_tof=jsonArray.jsonEncoder(tof)
    _json_v=jsonArray.jsonEncoder(value)
    p1="/MR/workspace/MantidData/raw/Itof/tof"
    p2="/MR/workspace/MantidData/raw/Itof/counts"
    neonRedis.set(p1,_json_tof)
    neonRedis.set(p2,_json_v)

    #set I-lamda raw data for roi I-Q
    name=mtd['sample_rebin_wave']
    num=name.getNumberHistograms()
    res=[[] for i in range(num)]
    for i in range(num):
        y=name.readY(i)
        res[i]=y
    t2=name.readX(0)
    t3=[]
    for j in range(len(t2)-1):
        t3.append(t2[j]+(t2[j+1]-t2[j])/2)
    pp1="/MR/workspace/MantidData/tmp/Iwave/raw/wave"
    pp2="/MR/workspace/MantidData/tmp/Iwave/raw/value"
    _j_t=jsonArray.jsonEncoder(t3)
    _j_v=jsonArray.jsonEncoder(res)
    neonRedis.set(pp1,_j_t)
    neonRedis.set(pp2,_j_v)
    print "set raw data for I-wave for ROI"

    # I-q
    wname=mtd["sample_raw_Q"]
    _tmp1=wname.readX(0)
    q=[]
    for j in range(len(_tmp1)-1):
        q.append(_tmp1[j]+(_tmp1[j+1]-_tmp1[j])/2)
    value1=wname.readY(0)
    _json_q=jsonArray.jsonEncoder(q)
    _json_v1=jsonArray.jsonEncoder(value1)
    p1="/MR/workspace/MantidData/raw/IQ/q"
    p2="/MR/workspace/MantidData/raw/IQ/counts"
    neonRedis.set(p1,_json_q)
    neonRedis.set(p2,_json_v1)

    # I-theta
    wname=mtd["sample_1"]
    counts=[]
    scaAngle=[]
    for i in range(50):
        scaAngle.append(7+0.3*i)
        counts.append(0)
    inst=wname.getInstrument()
    source=inst.getSource()
    sourcePos=source.getPos()
    sam=inst.getSample()
    samPos=sam.getPos()
    beamline=samPos-sourcePos
    numHist=wname.getNumberHistograms()
    testAngle=[]
    for j in range(numHist):
        n2=sum(wname.readY(j))
        #counts.append(n2)
        det=wname.getDetector(j)
        twoTheta=180/math.pi*det.getTwoTheta(samPos, beamline)
        testAngle.append(twoTheta)
        for i in range(len(scaAngle)-1):
            if twoTheta>=scaAngle[i] and twoTheta<scaAngle[i+1]:
                counts[i]=counts[i]+n2
            else:
                continue

    ptmp="/MR/workspace/MantidData/mapping/twoTheta"
    _j_theta=jsonArray.jsonEncoder(testAngle)
    neonRedis.set(ptmp, _j_theta)    

    _json_the=jsonArray.jsonEncoder(scaAngle)
    _json_v=jsonArray.jsonEncoder(counts)
    p1="/MR/workspace/MantidData/raw/Itheta/theta"
    p2="/MR/workspace/MantidData/raw/Itheta/counts"
    neonRedis.set(p1,_json_the)
    neonRedis.set(p2,_json_v)
    print "finish raw data set"

def setBankReduction(neonRedis):
    be=time.time()
    # I-Q
    ws=["sample_Q_byM", "sample_Q_byP"]
    path=["/MR/workspace/MantidData/reduction/monitor/IQ/","/MR/workspace/MantidData/reduction/PC/IQ/"]
    for i in range(2):
        name=mtd[ws[i]]
        value1=name.readY(0)
        _tmp=name.readX(0)
        print _tmp
        print value1[303],value1[304],value1[305]
        q=[]
        counts1=[]
        for j in range(len(_tmp)-1):
            q.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        for k in value1:
            counts1.append(k)
        _json_q=jsonArray.jsonEncoder(q)
        _json_counts=jsonArray.jsonEncoder(counts1)
        p1=path[i]+"q"
        p2=path[i]+"counts"
        neonRedis.set(p1,_json_q)
        neonRedis.set(p2,_json_counts)
        print p1,p2
    print "finish set IQ reduction"
    #I-tof
    ws2=["sample_tof_byM", "sample_tof_byP"]
    path2=["/MR/workspace/MantidData/reduction/monitor/Itof/","/MR/workspace/MantidData/reduction/PC/Itof/"]
    for i in range(2):
        name2=mtd[ws2[i]]
        value2=name2.readY(0)
        _tmp2=name2.readX(0)        
        tof=[]
        counts2=[]
        for j in range(len(_tmp2)-1):
            tof.append(_tmp2[j]+(_tmp2[j+1]-_tmp2[j])/2)
        for k in value2:
            counts2.append(k)
        _json_tof=jsonArray.jsonEncoder(tof)
        _json_counts2=jsonArray.jsonEncoder(counts2)
        p1=path2[i]+"tof"
        p2=path2[i]+"counts"
        print p1, p2
        neonRedis.set(p1,_json_tof)
        neonRedis.set(p2,_json_counts2)
    print "finish set I-tof redcution"

def setIQxyz(neonRedis):
    be=time.time()
    Rebin(InputWorkspace='ref_det_wave', OutputWorkspace='test', Params='1,0.005,9')
    ConvertUnits(InputWorkspace='test',OutputWorkspace='test_q',Target='MomentumTransfer', AlignBins=False)
    wname=mtd["test_q"]
    inst=wname.getInstrument()
    source=inst.getSource()
    sourcePos=source.getPos()
    sam=inst.getSample()
    samPos=sam.getPos()
    beamline=samPos-sourcePos
    numHist=wname.getNumberHistograms()
    qx=[]
    qy=[]
    qz=[]
    qv=[]
    print numHist,"number histograms"
    for j in range(numHist):
        det=wname.getDetector(j)
        twoTheta=det.getTwoTheta(samPos, beamline)
        pos=det.getPos()
        x=pos.X()
        y=pos.Y()
        cphi=math.cos(math.atan(y/x))
        sphi=math.sin(math.atan(y/x))
        stheta=math.sin(math.pi/180*twoTheta*0.5+math.pi/2.0)
        ctheta=math.cos(math.pi/180*twoTheta*0.5+math.pi/2.0)
        q_tmp=wname.readX(j)
        for q in q_tmp:
            qx.append(q*stheta*cphi)
            qy.append(q*stheta*sphi)
            qz.append(q*ctheta)
        value=wname.readY(j)
        for t in value:
            qv.append(t)
    axis=[]
    for i in range(100):
        axis.append(0.1+0.006*i)
    print "vv"
    vv=np.zeros([100,100,100])
    xind=0
    yind=0
    zind=0
    value=[[] for k in range(100*100*100)]
    be=time.time()
    print be
    for num in range(len(qv)):
        for i in range(99):
            if qx[num]>=axis[i] and qx[num]<axis[i+1]:
                xind=i
                break
        for i in range(99):
            if qy[num]>=axis[i] and qy[num]<axis[i+1]:
                yind=i
                break
        for i in range(99):
            if qz[num]>=axis[i] and qz[num]<axis[i+1]:
                zind=i
                break
        vv[xind,yind,zind]=vv[xind,yind,zind]+qv[num]
    print "iteration1 time: ",time.time()-be
    be=time.time()
    for l in range(100):
        for m in range(100):
            for n in range(100):
                point=[]
                point.append(axis[l])
                point.append(axis[m])
                point.append(axis[n])
                point.append(vv[l,m,n])
                value.append(point)            

    print num
    print "iteration2 time: ",time.time()-be

    print "===========I-Qxy============================"
    p1="/MR/workspace/MantidData/IQxyz/x"
    p2="/MR/workspace/MantidData/IQxyz/y"
    p3="/MR/workspace/MantidData/IQxyz/z"
    p4="/MR/workspace/MantidData/IQxyz/counts"
    _json_q=jsonArray.jsonEncoder(axis)
    _json_counts=jsonArray.jsonEncoder(vv)
    neonRedis.set(p1,_json_q)
    neonRedis.set(p2,_json_q)
    neonRedis.set(p3,_json_q)
    neonRedis.set(p4,_json_counts)
    print "finish set IQxyz raw!!!"

def setXYBankData(neonRedis, neonpathDetSet):
    be=time.time()
    name1=mtd["sample_1"]
    numHist=name1.getNumberHistograms()
    _tmpv=[]
    mapPid=[[] for k in range(numHist)]
    x=[]
    y=[]
    xaxis=[]
    yaxis=[]
    pid=[]
    for j in range(numHist):
        _det=name1.getDetector(j)
        _pos=_det.getPos()
        pid.append(_det.getID())
        _n2=sum(name1.readY(j))
        mapPid[j].append(_pos.X())
        mapPid[j].append(_pos.Y())
        x.append(_pos.X())
        y.append(_pos.Y())
        _tmpv.append(_n2)
    xaxis=list(set(x))
    yaxis=list(set(y))
    xaxis.sort()
    yaxis.sort()
    #print "get position"
    print len(xaxis), len(yaxis), len(_tmpv)
    vaxis=[[] for r in range(len(yaxis))]
    num=0
    for p in range(len(yaxis)):
        for q in range(len(xaxis)):
            vaxis[p].append(_tmpv[num])
            num=num+1
    print np.array(xaxis).shape, np.array(yaxis).shape, np.array(vaxis).shape
    #print np.array(xaxis)
    #print np.array(yaxis)
    #print np.array(vaxis)
    _json_pid=jsonArray.jsonEncoder(pid)
    _json_mapPid=jsonArray.jsonEncoder(mapPid)
    p11="/MR/workspace/MantidData/mapping/pid"
    p22="/MR/workspace/MantidData/mapping/xy"
    neonRedis.set(p11, _json_pid)
    neonRedis.set(p22, _json_mapPid)


    _json_x=jsonArray.jsonEncoder(xaxis)
    _json_y=jsonArray.jsonEncoder(yaxis)
    _json_v=jsonArray.jsonEncoder(vaxis)
    _p1=neonpathDetSet+"/xy_image/x"
    _p2=neonpathDetSet+"/xy_image/y"
    _p4=neonpathDetSet+"/xy_image/value"
    neonRedis.set(_p1, _json_x)
    neonRedis.set(_p2, _json_y)
    neonRedis.set(_p4, _json_v)
    print "finish XY Bank!", _p1, _p2, _p4

def setMonTofCounts(neonRedis, monitor):
    rawname=str(monitor)+"_rebin"
    name=mtd[rawname]
    counts=name.readY(0)
    tof=[]
    _tmp=name.readX(0)
    for j in range(len(_tmp)-1):
        tof.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
    print np.array(tof)
    print np.array(counts)
    _p1="/SANS/workspace/MantidData/"+monitor+"/tof"
    _p2="/SANS/workspace/MantidData/"+monitor+"/counts"
    _json_x=jsonArray.jsonEncoder(tof)
    _json_y=jsonArray.jsonEncoder(counts)
    print _p1, _p2
    neonRedis.set(_p1, _json_x)
    neonRedis.set(_p2, _json_y)
    co=sum(name.readY(0))
    print monitor, "  total neutron counts: ",co

def setXYMonitor(neonRedis, monitor):
    x=[]
    y=[]
    z=[]
    xaxis=[]
    yaxis=[]
    vtmp=[]
    rawName=monitor+"_2"   
    name=mtd[rawName]
    numHist=name.getNumberHistograms()
    print "hist of monitor: ", numHist
    for i in range(numHist):
        det=name.getDetector(i)
        pos=det.getRelativePos()
        #pos=det.getPos()
        n2=sum(name.readY(i))
        x.append(pos.X())
        y.append(pos.Y())
        #z.append(pos.Z())
        vtmp.append(n2)
    xaxis=list(set(x))
    yaxis=list(set(y))
    xaxis.sort()
    yaxis.sort()
    vaxis=[[] for m in range(len(yaxis))]
    n=0
    for j in range(len(yaxis)):
        for k in range(len(xaxis)):
            vaxis[j].append(vtmp[n])
            n=n+1
    _p1="/SANS/workspace/MantidData/"+monitor+"/axis_x"
    _p2="/SANS/workspace/MantidData/"+monitor+"/axis_y"
    _p3="/SANS/workspace/MantidData/"+monitor+"/value"
    print _p1, _p2, _p3
    _json_x=jsonArray.jsonEncoder(xaxis)
    _json_y=jsonArray.jsonEncoder(yaxis)
    _json_v=jsonArray.jsonEncoder(vaxis)
    neonRedis.set(_p1, _json_x)
    neonRedis.set(_p2, _json_y)
    neonRedis.set(_p3, _json_v)
    
