import redis
import jsonArray
import neonIO
import numpy as np
from numpy import *
import time

def roi(neonRedis,x1,y1,x2,y2):

    p11="/MR/workspace/MantidData/mapping/pid"
    p22="/MR/workspace/MantidData/mapping/xy"
    p33="/MR/workspace/MantidData/mapping/twoTheta"
    _j1=neonRedis.get(p11)
    _j2=neonRedis.get(p22)
    _j3=neonRedis.get(p33)
    wPid=jsonArray.jsonDecoder(_j1)
    xyPid=jsonArray.jsonDecoder(_j2)
    twoTheta=jsonArray.jsonDecoder(_j3)
    mapPid=[]
    pid=[]
    index=[]
    for i in range(len(wPid)):
        if xyPid[i][0]>=x1 and xyPid[i][0]<=x2 and xyPid[i][1]>=y2 and xyPid[i][1] <=y1:
            pid.append(wPid[i])
            mapPid.append((xyPid[i][0],xyPid[i][1]))
            index.append(i)
        else:
            continue
    pidNum=len(index)
    print "roi pixel num: ",pidNum
    #print index
    #==================I-tof=========================================================
    # get raw data for roi I-tof calculation
    pp1="/MR/workspace/MantidData/tmp/Itof/raw/tof"
    pp2="/MR/workspace/MantidData/tmp/Itof/raw/value"
    _j11=neonRedis.get(pp1)
    _j22=neonRedis.get(pp2)
    tof=jsonArray.jsonDecoder(_j11)
    res=jsonArray.jsonDecoder(_j22)
    
    tofNum=len(tof)
    #extract the roi
    value=[[] for i in range(pidNum)]
    num=0
    for i in index:
        value[num]=res[i]
        num=num+1
    #print sum(value),sum(res)
    # I-tof raw
    counts=[]
    for i in range(tofNum):
        tmp=0
        for j in range(pidNum):    
            tmp=tmp+value[j][i]
        counts.append(tmp)
    #use tof and counts to plot like path"/MR/workspace/MantidData/raw/Itof/tof","/MR/workspace/MantidData/raw/Itof/counts"
    #print tof, counts
    #==========================I-theta=====================================================
    counts=[]
    scaAngle=[]
    for i in range(50):
        scaAngle.append(8+0.1*i)
        counts.append(0)
    for num in index:
        n2=sum(res[num])
        for i in range(len(scaAngle)-1):
            if twoTheta[num]>=scaAngle[i] and twoTheta[num]<scaAngle[i+1]:
                counts[i]=counts[i]+n2
            else:
                continue
    #use scaAngle and counts to plot like path "/MR/workspace/MantidData/raw/Itheta/theta", "/MR/workspace/MantidData/raw/Itheta/counts"
    #print scaAngle, counts
    #==========================I-wave================================================
    #get raw data for roi I-q calculation
    pp1="/MR/workspace/MantidData/tmp/Iwave/raw/wave"
    pp2="/MR/workspace/MantidData/tmp/Iwave/raw/value"
    _j11=neonRedis.get(pp1)
    _j22=neonRedis.get(pp2)
    wave=jsonArray.jsonDecoder(_j11)
    res=jsonArray.jsonDecoder(_j22)
    waveNum=len(wave)
     
    #extract the roi
    value=[[] for i in range(pidNum)]
    num=0
    for i in index:
        value[num]=res[i]
        num=num+1
    be=time.time()
    qvalue=[[] for i in range(pidNum)]
    num=0
    for i in index:
        for j in range(len(wave)):
            tmpQ=4*math.pi/wave[j]*math.sin(math.pi/180*(twoTheta[i]/2))
            qvalue[num].append(tmpQ)
        num=num+1

    qNew=[]
    for num in range(100):
        qNew.append(0.10+num*0.05)
    #print time.time()-be
    vNew=np.zeros(len(wave))
    for i in range(pidNum):
        for j in range(len(wave)):
            for k in range(99):
                if qvalue[i][j]>=qNew[k] and qvalue[i][j]<qNew[k+1]:
                    vNew[k]=vNew[k]+value[i][j]
    #print time.time()-be
    #use qNew and vNew to plot like path "/MR/workspace/MantidData/raw/IQ/q", "/MR/workspace/MantidData/raw/IQ/counts"

