import redis
import jsonArray
import neonIO
import numpy as np
from numpy import *
import time

def roi(neonRedis,x1,y1,x2,y2):
    be=time.time()
    p11="/MR/workspace/MantidData/mapping/pid"
    p22="/MR/workspace/MantidData/mapping/xy"
    p33="/MR/workspace/MantidData/mapping/twoTheta"
    _j1=neonRedis.get(p11)
    _j2=neonRedis.get(p22)
    _j3=neonRedis.get(p33)
    wPid=jsonArray.jsonDecoder(_j1)
    xyPid=jsonArray.jsonDecoder(_j2)
    twoTheta=jsonArray.jsonDecoder(_j3)
    mapPid=[]
    index=[]
    for i in range(len(wPid)):
        if xyPid[i][0]>=x1 and xyPid[i][0]<=x2 and xyPid[i][1]>=y2 and xyPid[i][1] <=y1:
            mapPid.append((xyPid[i][0],xyPid[i][1]))
            index.append(i)
        else:
            continue
    pidNum=len(index)
    print "roi pixel num: ",pidNum,"  ", time.time()-be
    #print index
    #==================I-tof-raw=========================================================
    tofNew, countsNew=setItofData(neonRedis, "/MR/workspace/MantidData/tmp/raw/Itof", index)
    #use tof and counts to plot like path"/MR/workspace/MantidData/raw/Itof/tof","/MR/workspace/MantidData/raw/Itof/counts"
    #print tof, counts
    #====================I-tof-reduction================================================
    tofNew=[]
    countsNew=[]
    tofNew, countsNew=setItofData(neonRedis, "/MR/workspace/MantidData/tmp/reduction/monitor/Itof", index)
    print time.time()-be, " finish I-tof"
    #use tof and counts to plot like path"/MR/workspace/MantidData/reduction/monitor/Itof/tof","/MR/workspace/MantidData/reduction/monitor/Itof/counts"
    #==========================I-wave(I-Q)-raw================================================
    qNew, vNew=setIQData(neonRedis, "/MR/workspace/MantidData/tmp/Iwave/raw", index, twoTheta)
    #print qNew, vNew
    #====================I-wave(I-Q)-reduciton===============
    qNew=[]
    vNew=[]
    qNew, vNew=setIQData(neonRedis, "/MR/workspace/MantidData/tmp/reduction/monitor/Iwave", index, twoTheta)
    print time.time()-be, " finish I-Q"
    #print qNew, vNew
    #use qNew and vNew to plot like path "/MR/workspace/MantidData/reduction/monitor/IQ/q", "/MR/workspace/MantidData/reduction/monitor/IQ/counts"
    #==========================I-theta=====================================================
    scaAngle, counts=setIthetaData(neonRedis,"/MR/workspace/MantidData/tmp/raw/Itof/value", index, twoTheta)
    #use scaAngle and counts to plot like path "/MR/workspace/MantidData/raw/Itheta/theta", "/MR/workspace/MantidData/raw/Itheta/counts"
    print time.time()-be, " finish I-theta"
    print scaAngle, counts

def setIthetaData(neonRedis,path,index, twoTheta):
    _j22=neonRedis.get(path)
    res=jsonArray.jsonDecoder(_j22)
    
    counts=[]
    scaAngle=[]
    for i in range(50):
        scaAngle.append(8+0.1*i)
        counts.append(0)
    for num in index:
        n2=sum(res[num])
        for i in range(len(scaAngle)-1):
            if twoTheta[num]>=scaAngle[i] and twoTheta[num]<scaAngle[i+1]:
                counts[i]=counts[i]+n2
            else:
                continue
    return scaAngle, counts

def setIQData(neonRedis, path, index, twoTheta):
    p1=path+"/wave"
    p2=path+"/value"
    _j11=neonRedis.get(p1)
    _j22=neonRedis.get(p2)
    wave=jsonArray.jsonDecoder(_j11)
    res=jsonArray.jsonDecoder(_j22)
    #print p1
    #print wave
    #extract the roi
    pidNum=len(index)
    value=[[] for i in range(pidNum)]
    num=0
    for i in index:
        value[num]=res[i]
        num=num+1
    qvalue=[[] for i in range(pidNum)]
    num=0
    for i in index:
        for j in range(len(wave)):
            tmpQ=4*math.pi/wave[j]*math.sin(math.pi/180*(twoTheta[i]/2))
            qvalue[num].append(tmpQ)
        num=num+1
    qNew=[]
    for num in range(100):
        qNew.append(0.10+num*0.05)
    vNew=np.zeros(len(wave))
    for i in range(pidNum):
        for j in range(len(wave)):
            for k in range(99):
                if qvalue[i][j]>=qNew[k] and qvalue[i][j]<qNew[k+1]:
                    vNew[k]=vNew[k]+value[i][j]
    return qNew, vNew

def setItofData(neonRedis, path, index):
    pp1=path+"/tof"
    pp2=path+"/value"
    _j11=neonRedis.get(pp1)
    _j22=neonRedis.get(pp2)
    tof=jsonArray.jsonDecoder(_j11)
    res=jsonArray.jsonDecoder(_j22)
    
    tofNum=len(tof)
    pidNum=len(index)
    #extract the roi
    value=[[] for i in range(pidNum)]
    num=0
    for i in index:
        value[num]=res[i]
        num=num+1
    # I-tof raw
    counts=[]
    for i in range(tofNum):
        tmp=0
        for j in range(pidNum):    
            tmp=tmp+value[j][i]
        counts.append(tmp)
    return tof,counts    
