#!/usr/bin/python

import sip
sip.setapi(u'QDate', 2)
sip.setapi(u'QDateTime', 2)
sip.setapi(u'QTime', 2)
sip.setapi(u'QUrl', 2)
sip.setapi(u'QVariant', 2)
sip.setapi(u'QString', 2)
sip.setapi(u'QTextStream', 2)
from mayavi import mlab
import redis
import jsonArray
#import threading
import time
import numpy as np
import time
import sys


class connectNeon():

    def __init__(
        self,
        ip,
        port,
        timeout,
        ):

        self.status=False
        client=None
        self.server=None
        begin=time.time()

        while True:
            if not client:
                self.server = redis.Redis(host=ip, port=port, db=0)
                self.status=True
                #print "   INFO: NEON Started"
                break
            else:
                if time.time()-begin>timeout:
                    print "   ERROR: Connect NEON timeout"
                    sys.exit()
                    #break
                try:
                    print "   INFO: Attempt to connect NEON"
                    client=redis.client_list()
                except:
                    pass

    def getServer(self):
        return self.server



if __name__ == '__main__':
    # ======Try to connect NEON server
    ip="10.1.33.141"
    port=9000
    _neon=connectNeon(ip, port, 10.0)
    r=_neon.getServer()
    
    value=[]
    json1=r.get("/GPPD/workspace/MantidData/instrument/x")
    json2=r.get("/GPPD/workspace/MantidData/instrument/y")
    json3=r.get("/GPPD/workspace/MantidData/instrument/z")
    json4=r.get("/GPPD/workspace/MantidData/instrument/value")
    x=jsonArray.jsonDecoder(json1)
    y=jsonArray.jsonDecoder(json2)
    z=jsonArray.jsonDecoder(json3)
    v=jsonArray.jsonDecoder(json4)

    mlab.points3d(x, y, z, v, mode='point', scale_factor=0.5)
    #mlab.quiver3d(x, y, z, v, v, v, scalars=v, colormap="hot")
    #mlab.quiver3d(x, y, z, v, v, v, colormap="hot")
    mlab.show()


