#!/usr/bin/python
# -*- coding: utf-8 -*-

# for pyqt4

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for 2d plot

import matplotlib
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg as FigureCanvas
from matplotlib.figure import Figure
from matplotlib.ticker import MaxNLocator
from mpl_toolkits.mplot3d import Axes3D

class figureCanvas(FigureCanvas):

    def __init__(
        self,
        width=3,
        height=2,
        dpi=150,
        title='',
        xlabel='',
        ylabel='',
        isInteger=False,
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor=None,
            edgecolor=None,
            linewidth=2.0,
            frameon=False,
            tight_layout=False,
            )

        self.fig.patch.set_alpha(0.1)
        self.ax = self.fig.add_subplot(111, projection='3d')
        self.ax.tick_params(axis='both', which='major', labelsize=5)
        self.fig.subplots_adjust(left=0.05, bottom=0.05, right=0.95,
                                 top=0.95)

        self.ax.set_xlabel(xlabel, fontsize=5)
        self.ax.set_ylabel(ylabel, fontsize=5)
        self.xaxis_style = 'linear'
        self.yaxis_style = 'linear'
        self.ax.set_title(title)
       
        self.ax.xaxis.set_major_locator(MaxNLocator(integer=isInteger))

        FigureCanvas.__init__(self, self.fig)
        FigureCanvas.setSizePolicy(self, QtGui.QSizePolicy.Expanding,
                                   QtGui.QSizePolicy.Expanding)
        FigureCanvas.updateGeometry(self)

        self.draw()
