from mantid.simpleapi import *
import jsonArray
import time
import datetime
import json
#import multiprocessing
import threading
from multiprocessing import Process, Manager
import numpy
import shutil
#import logging
import math
import path
import subprocess
#class moduleIO(multiprocessing.Process):
class neonIO(threading.Thread):
    def __init__(self, neonRedis_write, neonRedis_read, refreshtime,myDict, logger):
        super(neonIO, self).__init__()
        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis_write
        self.neonRedis_read=neonRedis_read
        self.myDict=myDict
        self.logger=logger
        self.confJudge=True
        #self.detValue=[]
        #self.monValue=[]
        self.tof=[]
        self.detPid=[]
        for i in range(4600):
            self.detPid.append(100001+i)
        for i in range(501):
            self.tof.append(8000+i*64)        

    def getConf(self):
        be=time.time()
        path="/MR/control/configure"
        _json=self.neonRedis_read.get(path)
        _conf=json.loads(_json)


        return _conf

    def getSendOnline(self):
        path="/MR/workspace/MantidData/SendOnline"
        _json=self.neonRedis_read.get(path)
        if _json is None:
            return 0
        else:
            _tmp=jsonArray.jsonDecoder(_json)
            return _tmp

    def sendSendOnline(self):
        path="/MR/workspace/MantidData/SendOnline"
        self.neonRedis_write.set(path, json.dumps(0)) 

    def getROIcommand(self):
        path="/MR/workspace/MantidData/roi_mwpc"
        _json=self.neonRedis_read.get(path)
        if _json is None:
            tmp={}
            tmp['roi']=False
            return tmp
        else:
            _tmp=jsonArray.jsonDecoder(_json)
            return _tmp

    def get1Ddata(self,path):
        data=[]
        _json=self.neonRedis_read.get(path)
        data=jsonArray.jsonDecoder(_json)
        return data

    def getDataFromNeon(self, path1, path2):
        be=time.time()
        value = []
        _json=self.neonRedis_read.get(path1)
        _array=jsonArray.jsonDecoder(_json)
        a=0
        i = 0
        for ix in _array:
            a=a+sum(ix)
            for iy in ix:
                value.append(iy)
        self.neonRedis_write.set(path2, json.dumps(a))
        return value

    def getProtonCharge(self):
        data=[]
        path="/MR/drone/proton_charge"
        _json=self.neonRedis_read.get(path)
        data=jsonArray.jsonDecoder(_json)
        val=data[1][-1]
        if(type(val)==int):
            if val == 0:
                return 1
            else:
                return val
        else:
            return 1

    def createWorkspace(self):
        be=time.time()
        #print len(self.detPid), len(self.tof), len(self.detValue), len(self.monPid), len(self.monValue)
        if self.detJudge:
            LoadCSNSRaw(OutputWorkspace="sample", PixelID_bank=self.detPid, TimeOfFlight_bank=self.tof, Counts_bank=self.detValue, PixelID_monitor=[0,1], TimeOfFlight_monitor=[8,16], Counts_monitor=[1,1])
            #LoadInstrument(Workspace="sample_1", Filename='./instrument/detector.xml', RewriteSpectraMap='True')
            LoadInstrument(Workspace="sample_1", Filename='./instrument/detector_mwpc.xml', RewriteSpectraMap='True')
            #RotateInstrumentComponent(Workspace="sample_1", ComponentName="Bank01", X=0, Y=0, Z=1, Angle=90, RelativeRotation=False)
            #MoveInstrumentComponent(Workspace="sample_1", ComponentName="Bank01", X=0.017, Y=0, Z=0, RelativeRotation=False)
            judge=self.getSendOnline()
            if judge==0:
                pass
            else:
                SaveNexus(InputWorkspace='sample_1', Filename='./sample.nxs')
                print 'save nexus!'
                try:
                    _cmd = 'scp sample.nxs root@10.1.26.157:/userData/BL02/'
                    subprocess.check_call(_cmd, shell=True)
                    _cmd = 'scp sample.nxs zhanxz@10.1.252.40:/home/zhanxz/'
                    subprocess.check_call(_cmd, shell=True)
		    self.logger.debug('send online data to cloud!') 
                except:
                    self.logger.debug('error in scp!')
                self.sendSendOnline()                            

            if self.angle== 0:
                pass
            else:
                RotateInstrumentComponent(Workspace="sample_1", ComponentName="Bank01", X=0, Y=1, Z=0, Angle=self.angle)
        else:
            pass
        if self.monJudge:
            LoadCSNSRaw(OutputWorkspace="monitor", PixelID_bank=[0,1], TimeOfFlight_bank=[8,16], Counts_bank=[1,1], PixelID_monitor=self.monPid, TimeOfFlight_monitor=self.monTof, Counts_monitor=self.monValue)
            LoadInstrument(Workspace="monitor_2", Filename='./instrument/monitor01.xml', RewriteSpectraMap='True')
            SaveNexus(InputWorkspace='monitor_2', Filename='./monitor1.nxs')
            #get I-tof I-wave
            #ConvertUnits(InputWorkspace='monitor_2',OutputWorkspace='__tmpD2',Target='dSpacing',AlignBins=True)
            ConvertUnits(InputWorkspace='monitor_2',OutputWorkspace='__tmpW2',Target='Wavelength',AlignBins=True)
            SumSpectra(InputWorkspace='__tmpW2', OutputWorkspace="MwaveCounts", IncludeMonitors=True)
            SumSpectra(InputWorkspace='monitor_2', OutputWorkspace="MtofCounts", IncludeMonitors=True)
        else:
            pass

    def wsProcess(self, wsname):
        if self.detJudge:
            #get I-wave I-tof
            SumSpectra(InputWorkspace=wsname, OutputWorkspace="tofCounts", IncludeMonitors=False)
            name=mtd['tofCounts']
            a=sum(name.readY(0))
            self.neonRedis_write.set('/MR/workspace/MantidData/neutroncounts_roi', json.dumps(a)) 
            ConvertUnits(InputWorkspace=wsname,OutputWorkspace='__tmp',Target='Wavelength',AlignBins=True)
            #Rebin(InputWorkspace="__tmp",OutputWorkspace="sample_wave_rebin", Params='1.8,0.001,6.8')
            Rebin(InputWorkspace="__tmp",OutputWorkspace="sample_wave_rebin", Params='0.5,0.002,14.0')
            Qxy(InputWorkspace='sample_wave_rebin', OutputWorkspace='sample_Qxy', MaxQxy=0.25, DeltaQ=0.01, SolidAngleWeighting=False)
            ReplaceSpecialValues(InputWorkspace='sample_Qxy', OutputWorkspace='sample_Qxy',NaNValue=0, InfinityValue=0)
            SumSpectra(InputWorkspace='sample_wave_rebin', OutputWorkspace="waveCounts", IncludeMonitors=False)
            #ConvertUnits(InputWorkspace='waveCounts',OutputWorkspace='tofCounts',Target='TOF',AlignBins=True)
            
            #LoadInstrument(Workspace="tofCounts", Filename='./instrument/onePid.xml', RewriteSpectraMap='True')
            #ConvertUnits(InputWorkspace="tofCounts",OutputWorkspace='waveCounts',Target='Wavelength',AlignBins=True)
            proton=self.getProtonCharge()
            CreateSingleValuedWorkspace(OutputWorkspace="__pro", DataValue=proton)
            Divide(LHSWorkspace="waveCounts", RHSWorkspace="__pro", OutputWorkspace="nor_wave")
            ConvertUnits(InputWorkspace='nor_wave',OutputWorkspace='qCounts_P',Target='MomentumTransfer',AlignBins=True)
            Rebin(InputWorkspace="qCounts_P",OutputWorkspace="qCounts_P", Params='0.0005,0.001,0.4')
            #Rebin(InputWorkspace="tofCounts",OutputWorkspace="tofCounts", Params='0,16,40000')
        else:
            pass


    def setIQdataToNeon(self, wsname, path1, path2):
        name=mtd[wsname]
        tmpx=[]
        tmpv=[]
        tmpv=name.readY(0)
        _tmp=name.readX(0)
        for j in range(len(_tmp)-1):
            tmpx.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        #x=[]
        v=[]
        for ix in tmpv:
            v.append(ix)

        for i in range(len(tmpv)):
            if not numpy.isnan(tmpv[i]) and numpy.isfinite(tmpv[i]):
                pass
            else:
                v[i]=0
        self.neonRedis_write.set(path1, jsonArray.jsonEncoder(tmpx))
        self.neonRedis_write.set(path2, jsonArray.jsonEncoder(v))

    def set1DdataToNeon(self,wsname, path1, path2):
        name=mtd[wsname]
        x=[]
        v=[]
        v=name.readY(0)
        _tmp=name.readX(0)
        for j in range(len(_tmp)-1):
            x.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        self.neonRedis_write.set(path1, jsonArray.jsonEncoder(x))
        self.neonRedis_write.set(path2, jsonArray.jsonEncoder(v))

    def setPidCounts(self):
        pid=[]
        counts=[]
        name=mtd['sample_1']
        for j in range(name.getNumberHistograms()):
            pid.append(j)
            counts.append(sum(name.readY(j)))
        path1="/MR/workspace/MantidData/reduction/monitor/Itof/tof"
        path2 = "/MR/workspace/MantidData/reduction/monitor/Itof/counts"
        #path1="/MR/workspace/MantidData/detector/pid"
        #path2 = "/MR/workspace/MantidData/detector/counts"
        self.neonRedis_write.set(path1, jsonArray.jsonEncoder(pid))
        self.neonRedis_write.set(path2, jsonArray.jsonEncoder(counts))
        self.logger.debug("set pid counts for detector")

    def setItheta(self, wsname, start, step, bins, prepath):
        wname=mtd[wsname]
        counts=[]
        scaAngle=[]
        theta=[]
        for i in range(bins):
            scaAngle.append(start+step*i)
            counts.append(0)
        inst=wname.getInstrument()
        source=inst.getSource()
        sourcePos=source.getPos()
        sam=inst.getSample()
        samPos=sam.getPos()
        beamline=samPos-sourcePos
        numHist=wname.getNumberHistograms()
        for j in range(numHist):
            n2=sum(wname.readY(j))
            det=wname.getDetector(j)
            twoTheta=180/math.pi*det.getTwoTheta(samPos, beamline)
            theta.append(twoTheta)
            for i in range(len(scaAngle)-1):
                if twoTheta>=scaAngle[i] and twoTheta<scaAngle[i+1]:
                    counts[i]=counts[i]+n2
                else:
                    continue
        self.neonRedis_write.set(prepath+"raw/Itheta/theta",jsonArray.jsonEncoder(scaAngle))
        self.neonRedis_write.set(prepath+"raw/Itheta/counts",jsonArray.jsonEncoder(counts))
        self.logger.debug("set raw data for I-theta ")
        return theta

    def setIQxyz(self, theta):
        Rebin(InputWorkspace="sample_1",OutputWorkspace="__rebin", Params='0,64,40000')
        ConvertUnits(InputWorkspace='__rebin',OutputWorkspace='__rebin',Target='MomentumTransfer', AlignBins=False)
        wname=mtd['__rebin']
        qx=[]
        qy=[]
        qz=[]
        qv=[]
        for j in range(wname.getNumberHistograms()):
            det=wname.getDetector(j)
            twoTheta=theta[j]
            x=(det.getPos()).X()
            y=(det.getPos()).Y()
            cphi=math.cos(math.atan(y/x))
            sphi=math.sin(math.atan(y/x))
            stheta=math.sin(math.pi/180*twoTheta*0.5+math.pi/2.0)
            ctheta=math.cos(math.pi/180*twoTheta*0.5+math.pi/2.0)
            q_tmp=wname.readX(j)
            for k in range(len(q_tmp)-1):
                qx.append(q_tmp[k]*stheta*cphi)
                qy.append(q_tmp[k]*stheta*sphi)
                qz.append(q_tmp[k]*ctheta)
            value=wname.readY(j)
            for t in value:
                qv.append(t)
        self.neonRedis_write.set("/MR/workspace/MantidData/IQxyz/x",jsonArray.jsonEncoder(qx))
        self.neonRedis_write.set("/MR/workspace/MantidData/IQxyz/y",jsonArray.jsonEncoder(qy))
        self.neonRedis_write.set("/MR/workspace/MantidData/IQxyz/z",jsonArray.jsonEncoder(qz))
        self.neonRedis_write.set("/MR/workspace/MantidData/IQxyz/counts",jsonArray.jsonEncoder(qv))
        self.logger.debug("finish set IQxyz raw")

    
    def setIQxy(self):
        wname=mtd["sample_Qxy"]
        _tmp=wname.readX(0)
        qxy=[]
        for j in range(len(_tmp)-1):
            qxy.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        numHist=wname.getNumberHistograms()
        intensity=[[] for i in range(numHist)]
        for j in range(numHist):
            _n2=wname.readY(j)
            for p in _n2:
                intensity[j].append(p)
        self.neonRedis_write.set("/MR/workspace/MantidData/IQxy/x",jsonArray.jsonEncoder(qxy))
        self.neonRedis_write.set("/MR/workspace/MantidData/IQxy/y",jsonArray.jsonEncoder(qxy))
        self.neonRedis_write.set("/MR/workspace/MantidData/IQxy/counts",jsonArray.jsonEncoder(intensity))


    def setXYData(self, wsname, prepath):
        counts=[]
        xaxis=[]
        yaxis=[]
        name=mtd[wsname]
        v=[[] for i in range(name.getNumberHistograms())]
        for j in range(name.getNumberHistograms()):
            counts.append(sum(name.readY(j)))
            #_det=name.getDetector(j)
            _pos=name.getDetector(j).getRelativePos()
            #_pos=name.getDetector(j).getPos()
            xaxis.append(_pos.X())
            yaxis.append(_pos.Y())
            v[j].append((_pos.X())*100)
            v[j].append((_pos.Y())*100)
            v[j].append(sum(name.readY(j)))
        xaxis=list(set(xaxis))
        yaxis=list(set(yaxis))
        xaxis.sort()
        yaxis.sort()
        for i in range(len(xaxis)):
            xaxis[i]=xaxis[i]*1000
        for i in range(len(yaxis)):
            yaxis[i]=yaxis[i]*1000
        vaxis=[[] for r in range(len(yaxis))]
        num=0
        for p in range(len(yaxis)):
            for q in range(len(xaxis)):
                vaxis[p].append(counts[num])
                num=num+1
        self.neonRedis_write.set(prepath+"/xy_image/x", jsonArray.jsonEncoder(xaxis))
        self.neonRedis_write.set(prepath+"/xy_image/y", jsonArray.jsonEncoder(yaxis))
        self.neonRedis_write.set(prepath+"/xy_image/value", jsonArray.jsonEncoder(vaxis))
        self.neonRedis_write.set(prepath+"/xy_image/wechat", jsonArray.jsonEncoder(v))
        self.logger.debug("finish set XY data for monitor or detector")

    def roiProcess(self, pos):
        name=mtd['sample_1']
        Xdata=[]
        XYdata=[[] for i in range(2)]
        dataLen=name.getNumberHistograms()
        for j in range(dataLen):
            #Xdata.append(name.getDetector(j).getRelativePos().X()*1000)
            #Ydata.append(name.getDetector(j).getRelativePos().Y()*1000)
            XYdata[0].append(name.getDetector(j).getRelativePos().X()*1000)
            XYdata[1].append(name.getDetector(j).getRelativePos().Y()*1000)
        index=[]
        if pos[1]>pos[3]:
            ymax=pos[1]
            ymin=pos[3]
        else:
            ymax=pos[3]
            ymin=pos[1]
        if pos[0]>pos[2]:
            xmax=pos[0]
            xmin=pos[2]
        else:
            xmax=pos[2]
            xmin=pos[0]
            

        for i in range(dataLen):
            if XYdata[0][i]>=xmin and XYdata[0][i]<=xmax and XYdata[1][i]>=ymin and XYdata[1][i] <= ymax:
                index.append(i)
            else:
                pass
        self.logger.debug( "ROI: "+str(index))
        ExtractSpectra(InputWorkspace='sample_1', OutputWorkspace='roiWS', WorkspaceIndexList=index)

    def dataSet(self):
        if self.confRoi['roi']:
            self.logger.debug("set roi data!!!")
            self.set1DdataToNeon("tofCounts", "/MR/workspace/MantidData/ROI/raw/Itof/tof","/MR/workspace/MantidData/ROI/raw/Itof/counts")
            self.set1DdataToNeon("waveCounts", "/MR/workspace/MantidData/ROI/raw/Iwave/wavelength","/MR/workspace/MantidData/ROI/raw/Iwave/counts")
            #self.setIQdataToNeon("qCounts_M", "/MR/workspace/MantidData/ROI/reduction/monitor/IQ/q","/MR/workspace/MantidData/ROI/reduction/monitor/IQ/counts")
            self.setIQdataToNeon("qCounts_P", "/MR/workspace/MantidData/ROI/reduction/PC/IQ/q","/MR/workspace/MantidData/ROI/reduction/PC/IQ/counts")
            tmp=self.setItheta("roiWS", 7, 0.1, 50, "/MR/workspace/MantidData/ROI/")
        else:
            pass
        self.logger.debug("set whole data!!!")
        if self.detJudge:
            self.set1DdataToNeon("tofCounts", "/MR/workspace/MantidData/raw/Itof/tof","/MR/workspace/MantidData/raw/Itof/counts")
            #self.setIQdataToNeon("qCounts_M", "/MR/workspace/MantidData/reduction/monitor/IQ/q","/MR/workspace/MantidData/reduction/monitor/IQ/counts")
            self.setIQdataToNeon("qCounts_P", "/MR/workspace/MantidData/reduction/PC/IQ/q","/MR/workspace/MantidData/reduction/PC/IQ/counts")
            self.set1DdataToNeon("waveCounts", "/MR/workspace/MantidData/raw/Iwave/wavelength","/MR/workspace/MantidData/raw/Iwave/counts")
            print 'set IQ and Iwave to neon!'
        else:
            pass
        if self.monJudge:
            self.set1DdataToNeon("MtofCounts", "/MR/workspace/MantidData/monitor1/tof","/MR/workspace/MantidData/monitor1/counts")
            self.logger.warning("finish set monitor1 tof counts")
            self.set1DdataToNeon("MwaveCounts", "/MR/workspace/MantidData/monitor1/wave","/MR/workspace/MantidData/monitor1/wcounts")
            self.logger.warning("finish set monitor1 wave counts")
            self.setXYData("monitor_2", "/MR/workspace/MantidData/monitor1")

        else:
            pass
        # For Tab1 and Tab4 2D data: detector XY hot, monitor XY hot
        if self.detJudge:
            try:
                self.setXYData("sample_1", "/MR/workspace/MantidData/detector")
            except:
                self.logger.warning("error in set XY data")
            try:
                self.setIQxy()
            except:
                self.logger.warning("error in set IQxy data")
                # For Tab2 and Tab3 1D and 2D data: tube pos-counts and XY hot
                # set Tab1 pid counts
            try:
                self.setPidCounts()
            except:
                self.logger.warning("error in set pid counts data")
            # set Tab1 Itheta
            try:
                theta=[]
                theta=self.setItheta("sample_1", 7, 0.1, 50, "/MR/workspace/MantidData/")
            except:
                self.logger.warning("error in set Itheta data")
            
            # set Tab6 IQxyz(error:float division by zero)
            #self.setIQxyz(theta)
        else:
            pass

    def process(self):
        if self.myDict['configure']:
            if self.confJudge:
                try:
                    self.conf=self.getConf()
                except:
                    pass
                try:
                    self.delay=int(self.conf["detectorDelay"])
                    self.angle=float(self.conf["detectorAngle"])
                except:
                    self.delay = 0
                    self.angle = 0
                self.logger.warning("angle = "+str(self.angle)+"|| delay = "+ str(self.delay))
                '''
                self.tof=[]
                self.detPid=[]
                try:
                    self.detPid=self.get1Ddata("/MR/workspace/detector/module01/pid")
                    tmp=self.get1Ddata("/MR/workspace/detector/module01/tof")
                    for ix in tmp:
                        self.tof.append(ix+self.delay)
                    print detPid, self.tof
                    self.detJudge=True
                except:
                    self.logger.warning("no data in get pid and tof for detector")
                    self.detJudge=False
                '''
                self.monPid=[]
                self.monTof=[]
                try:
                    self.monPid=self.get1Ddata("/MR/workspace/monitor1/pid")
                    self.monTof=self.get1Ddata("/MR/workspace/monitor1/tof")
                    self.monJudge=True
                except:
                    self.logger.warning("no data in get pid and tof for monitor")
                    self.monJudge=False
                path.clearRedis(self.neonRedis_write)
                self.logger.debug("finish new configuring")
                #print "conf: ", self.tof
                
                self.confJudge=False
            else:
                pass
        else:
            self.confJudge=True
        
        if self.myDict['running']:
            be=time.time()
            be1=time.time()
            self.logger.debug("start running program")
            try:
                self.detValue=self.getDataFromNeon("/MR/workspace/detector/module01/value", "/MR/workspace/MantidData/neutroncounts")
                print time.time()-be1, "seconds in get raw data"
                self.detJudge=True
            except:
                self.logger.warning("no data in get data from neon for detector")
                self.detJudge=False
            try:
                self.monValue=self.getDataFromNeon("/MR/workspace/monitor1/value", "/MR/workspace/MantidData/monitor/neutroncounts")
                self.monJudge=True
            except:
                #self.logger.warning("no data in get data from neon for monitor")
                self.monJudge=False
            if self.myDict['running']:
                #print self.detValue
                #print self.detPid
                #print "running: ", self.tof
                if self.detJudge:
                    if (len(self.detValue)!=(len(self.tof)-1)*len(self.detPid)):
                        self.logger.warning("data size doesn't match for detector")
                        self.detJudge=False                        
                else:
                    pass
                if self.monJudge:
                    if(len(self.monValue)!=(len(self.monTof)-1)*len(self.monPid)):
                        print len(self.monValue), len(monTof), len(self.monPid) 
                        self.logger.warning("data size doesn't match for monitor")
                        self.monJudge=False
                if self.myDict['running']:
                    #try:
                    self.logger.debug("start create ws")
                    be1=time.time()
                    self.createWorkspace()
                    print time.time()-be1, 'seconds in createws!'
                    '''
                    except:
                        self.myDict['error']=True
                        self.myDict['running']=False
                        self.logger.error("error in create workspace!")
                    '''
                    self.confRoi=self.getROIcommand()
                    #self.confRoi['roi'] = True
                    if self.myDict['running']:
                        print "Judge ROI: ",self.confRoi['roi']
                        self.logger.debug("start process ws")
                        if self.confRoi['roi']:
                            print "position of ROI: ",self.confRoi['pos']
                            self.roiProcess(self.confRoi['pos'])
                            '''
                            SumSpectra(InputWorkspace='roiWS', OutputWorkspace="tCounts", IncludeMonitors=False)
                            name=mtd['tCounts']
                            a=sum(name.readY(0))
                            self.neonRedis_write.set('/MR/workspace/MantidData/neutroncounts', json.dumps(a)) 
                            '''
                            self.wsProcess('roiWS')
                        else:
                            be1=time.time()
                            self.wsProcess('sample_1')
                            print time.time()-be1, 'seconds in wsProcess!'
                        #try:
                        self.logger.debug("start set data")
                        be1=time.time()
                        self.dataSet()
                        print time.time()-be1, 'seconds in dataSet!'
                        #try:
                        #    shutil.move("./detector.nxs","./tmp/detetor.nxs" )
                        #except:
                        #    self.logger.warning("no detector nexus file!!!")
                        #    shutil.move("./monitor1.nxs","./tmp/monitor1.nxs" )
                        #except:
                        #    self.logger.warning("no monitor nexus file!!!")

                        #DeleteWorkspace(Workspace='sample')
                        self.logger.debug("finish time is "+str(time.time()-be)+" seconds!!!")
                    '''
                    except:
                        self.myDict['error']=True
                        self.myDict['running']=False
                        self.logger.error("error in set data!")
                    '''
                else:
                    pass
            else:
                pass
        else:
            pass

    def run(self):
        while True:
            self.detJudge=True
            self.monJudge=True
            try:
                self.process()
                time.sleep(0.5)
            except:
                pass

