from mantid.simpleapi import *
import redis
import jsonArray
import neonIO
import numpy as np
from numpy import *
import time
import multiprocessing
from multiprocessing import Process, Manager

class roiDataProcess(multiprocessing.Process):
    def __init__(self, neonRedis_write, neonRedis_read, refreshtime, myDict):
        super(roiDataProcess, self).__init__()

        self.neonRedis_write=neonRedis_write
        self.neonRedis_read=neonRedis_read
        self.refreshtime=refreshtime
        self.myDict=myDict

    def getROIcommand(self):
        #dict, pos=[x1,y1,x2,y2], roi=true or false
        path="/MR/workspace/MantidData/roi"
        _json=self.neonRedis.get(path)
        _tmp=jsonArray.jsonDecoder(_json)
        return _tmp

    def roi(self,x1,y1,x2,y2):
        if not self.myDict['pause']:
            be=time.time()
            p11="/MR/workspace/MantidData/mapping/pid"
            p22="/MR/workspace/MantidData/mapping/xy"
            _j1=self.neonRedis.get(p11)
            _j2=self.neonRedis.get(p22)
            wPid=jsonArray.jsonDecoder(_j1)
            xyPid=jsonArray.jsonDecoder(_j2)
            mapPid=[]
            index=[]
            for i in range(len(wPid)):
                if xyPid[i][0]>=x1 and xyPid[i][0]<=x2 and xyPid[i][1]>=y2 and xyPid[i][1] <=y1:
                    mapPid.append((xyPid[i][0],xyPid[i][1]))
                    index.append(i)
                else:
                    continue
            pidNum=len(index)
            print "roi pixel num: ",pidNum,"  ", time.time()-be
            if not self.myDict['pause']:
                be=time.time()
                judge=True
                while judge:
                    try:
                        LoadNexus(Filename="./tmp.nxs", OutputWorkspace='test')
                        judge=False
                    except:
                        time.sleep(5)
                print "finish load ws for roi ", time.time()-be
                if not self.myDict['pause']:
                    be=time.time()
                    ExtractSpectra(InputWorkspace='test', OutputWorkspace='roiWS', WorkspaceIndexList=index)
                    CloneWorkspace(InputWorkspace='roiWS',OutputWorkspace='tmp')
                    SumSpectra(InputWorkspace='tmp', OutputWorkspace='tof_raw')
                    ConvertUnits(InputWorkspace='tmp',OutputWorkspace='wave_raw', Target='Wavelength', AlignBins=True)
                    Q1D(DetBankWorkspace='wave_raw', OutputWorkspace='I_q', OutputBinning='0.05,0.02,5.0')
                    '''
                    # reduction
                    LoadNexus(Filename="./mon_wave.nxs", OutputWorkspace='mon')
                    LoadNexus(Filename="./inc_res.nxs", OutputWorkspace='inc')
                    st='0-'+str(pidNum-1)
                    GroupDetectors(InputWorkspace='wave_raw', Outputworkspace='sam1', WorkspaceIndexList=st)
                    Rebin(InputWorkspace='sam1', Outputworkspace='sam_reb', Params='2.1,0.01,7.3')
                    RebinToWorkspace(WorkspaceToRebin='mon', WorkspaceToMatch='sam_reb', OutputWorkspace='mon')
                    RebinToWorkspace(WorkspaceToRebin='inc', WorkspaceToMatch='sam_reb', OutputWorkspace='inc')
                    Divide(LHSWorkspace='sam_reb',RHSWorkspace='mon',OutputWorkspace='sam_res')
                    Divide(LHSWorkspace='sam_res',RHSWorkspace='inc',OutputWorkspace='result_wave')
                    ConvertUnits(InputWorkspace='result_wave',OutputWorkspace='tof_redu', Target='TOF', AlignBins=True)
                    ConvertUnits(InputWorkspace='result_wave', OutputWorkspace='IQ_redu', Target='MomentumTransfer', AlignBins=True)
                    print "finish reduction roi: ", time.time()-be
                    '''
                else:
                    pass
            else:
                pass
        else:
            pass

    def getItof(self,wsName):
        #get tof and counts data
        name=mtd[wsName]
        _tmp=name.readX(0)
        tof=[]
        for j in range(len(_tmp)-1):
            tof.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        counts=name.readY(0)
        #print counts
        return tof, counts

    def getItheta(self):
        be=time.time()
        wname=mtd['tmp']
        counts=[]
        scaAngle=[]
        for i in range(50):
            scaAngle.append(7+0.3*i)
            counts.append(0)
        inst=wname.getInstrument()
        source=inst.getSource()
        sourcePos=source.getPos()
        sam=inst.getSample()
        samPos=sam.getPos()
        beamline=samPos-sourcePos
        numHist=wname.getNumberHistograms()
        testAngle=[]
        for j in range(numHist):
            n2=sum(wname.readY(j))
            #counts.append(n2)
            det=wname.getDetector(j)
            twoTheta=180/math.pi*det.getTwoTheta(samPos, beamline)
            for i in range(len(scaAngle)-1):
                if twoTheta>=scaAngle[i] and twoTheta<scaAngle[i+1]:
                    counts[i]=counts[i]+n2
                else:
                    continue
        print "finish getItheta! ",time.time()-be
        return scaAngle, counts

    def getIQ(self,wsName):
        name=mtd[wsName]
        _tmp=name.readX(0)
        q=[]
        for j in range(len(_tmp)-1):
            q.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        counts=name.readY(0)
        return q, counts

    def setData(self,path1, path2, value1, value2):
        json1=jsonArray.jsonEncoder(value1)
        json2=jsonArray.jsonEncoder(value2)
        self.neonRedis.set(path1, json1)
        self.neonRedis.set(path2, json2)

    def setROIData(self):
        # I theta data
        theta,counts2=self.getItheta()
        self.setData(self.path+'/raw/Itheta/theta',self.path+'/raw/Itheta/counts',theta,counts2)
        if not self.myDict['pause']:
            # I tof raw data
            tofRaw,counts1=self.getItof('tof_raw')
            self.setData(self.path+'/raw/Itof/tof',self.path+'/raw/Itof/counts',tofRaw,counts1)
            # I q raw data
            qRaw, counts3=self.getIQ('I_q')
            self.setData(self.path+'/raw/IQ/q',self.path+'/raw/IQ/counts',qRaw,counts3)
            # I tof reduction data
            tofRedu,counts4=self.getItof('tof_redu')
            self.setData(self.path+'/reduction/monitor/Itof/tof', self.path+'/reduction/monitor/Itof/counts',tofRedu,counts4)
            self.setData(self.path+'/reduction/PC/Itof/tof',self.path+'/reduction/PC/Itof/tof',tofRedu,counts4)
            # I q reduction data
            qRedu,counts5=self.getIQ('IQ_redu')
            self.setData(self.path+'/reduction/monitor/IQ/q',self.path+'/reduction/monitor/IQ/counts',qRedu,counts5)
            self.setData(self.path+'/reduction/PC/Itof/tof',self.path+'/reduction/PC/Itof/tof',qRedu,counts5)
        else:
            pass
                        
    def process(self):
        self.conf=self.getROIcommand()
        if self.conf['roi']:
            xyPos=self.conf['pos']



        else:
            pass

        if self.myDict['started']:
            if self.myDict['processing']:
                if not self.myDict['pause']:
                    _command=self.getCommand()
                    if _command==None:
                        time.sleep(2)
                    else:         
                        self.command=_command       
                        print "=========================================="
                        if not self.myDict['pause']:
                            try:
                                self.roi(self.command[0],self.command[1],self.command[2],self.command[3])
                            except:
                                self.myDict['error']=True
                                self.myDict['pause']=False
                                self.myDict['processing']=False
                            if not self.myDict['pause']:
                                try:
                                    self.setROIData()
                                    self.myDict['roiProcFinish']=True
                                except:
                                    self.myDict['error']=True
                                    self.myDict['pause']=False
                                    self.myDict['processing']=False
                            else:
                                pass
                        else:
                            pass
                else:
                    pass
            else:
                pass
        else:
            pass
        
    def run(self):
        while True:
            self.process()
            time.sleep(self.refreshtime)

