import jsonArray
import time
import sys
#from xml.etree import ElementTree
import multiprocessing
from multiprocessing import Process, Manager
#import threading
import json


class scanData(multiprocessing.Process):
    def __init__(self, neonRedis, refreshtime, myDict):
        super(scanData, self).__init__()

        self.neonRedis=neonRedis
        self.refreshtime=refreshtime
        self.myDict=myDict
        self.num=0
        self.array=[[] for i in range(3)]
        self.conf={}
        self.confJudge=True
        self.neonpath="/MR/workspace/detector/module01/value" 
        #self.neonpath="/MR/workspace/sim/detector/module01/value"

    def getConf(self):
        be=time.time()
        path="/MR/control/configure"
        _json=self.neonRedis.get(path)
        while _json is None:
            print "no configure data!"
            _json=self.neonRedis.get(path)
            time.sleep(20)
        _conf=json.loads(_json)
        return _conf

    def getData(self):
        be=time.time()
        _json=self.neonRedis.get(self.neonpath)
        #print "json: ", type(_json)
        while _json is None:
            print "no 2D data in modulei01!"
            _json=self.neonRedis.get(self.neonpath)
            time.sleep(20)
        _array=jsonArray.jsonDecoder(_json)
        a=0
        for ix in _array:
            a=sum(ix)+a
        print "get getData = ",a," time: ",time.time()-be
        return a

    def initialData(self, pos):
        #pos=self.getConf()
        array=[[] for i in range(3)]
        for j in range(len(pos)):
            array[0].append(0)
            array[1].append(pos[j])
            array[2].append(0)
        return array

    def setData(self):
        path="/MR/workspace/MantidData/scan"
        json=jsonArray.jsonEncoder(self.array)
        self.neonRedis.set(path,json)

    def process(self):
        #print "state: ", self.myDict['state'], "; configure:", self.myDict['configure'],"; running: ",self.myDict['running'],"; started: ", self.myDict['started']
        if self.myDict['state']:
            if self.myDict['configure']:
                if self.confJudge:
                    self.conf=self.getConf()
                    if self.conf['runtype']=='scan':
                        print "scan!!!"
                        self.array=self.initialData(self.conf['positionPoint'])
                        self.confJudge=False
                        self.num=0
                        print "finish configure for scan!!"
                    else:
                        pass
                else:
                    pass
            else:
                self.confJudge=True

            if self.myDict['running']:
                if self.myDict['started']:
                    print "this is the ", self.num+1, " position!"
                    _data=self.getData()
                    self.array[0][self.num]=1
                    self.array[2][self.num]=_data
                    self.setData()
                else:
                    self.num=self.num+1
                    self.myDict['running']=False
                    #if self.num==len(self.array[0]):
                        #self.myDict['state']=False
            else:
                pass

        else:
            time.sleep(0.1)


    def run(self):
        while True:
            time.sleep(0.3)
            self.process()

