from mantid.simpleapi import *
import jsonArray
import time
import datetime
import json
import multiprocessing
from multiprocessing import Process, Manager
import numpy
import shutil

class moduleIO(multiprocessing.Process):
    def __init__(self, neonRedis_write, neonRedis_read, refreshtime, module, myDict):
        super(moduleIO, self).__init__()

        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis_write
        self.neonRedis_read=neonRedis_read
        self.module=module
        self.myDict=myDict
        self.confJudge=True
        self.neonpathDetValue="/GPPD/workspace/detector/"+self.module+"/value"
        self.neonpathDetSet="/GPPD/workspace/MantidData/"+self.module

    def getDataFromNeon(self):
        be=time.time()
        self.detValue = []
        _json=self.neonRedis_read.get(self.neonpathDetValue)
        while _json is None:
            print "no 2D data in module!",self.module," ", datetime.datetime.now()
            _json=self.neonRedis_read.get(self.neonpathDetValue)
            time.sleep(20)
        _array=jsonArray.jsonDecoder(_json)
        a=0
        for ix in _array:
            a=a+sum(ix)
            for iy in ix:
                self.detValue.append(iy)
        print "total neutrons: ",a, " ", self.module," ", datetime.datetime.now()
        path="/GPPD/workspace/MantidData/"+self.module+"/neutroncounts"
        self.neonRedis_write.set(path, json.dumps(a))

    def createWorkspace(self):
        be=time.time()
        LoadCSNSRaw(OutputWorkspace=self.module, PixelID_bank=self.detPid, TimeOfFlight_bank=self.detTof, Counts_bank=self.detValue, PixelID_monitor=[0,1], TimeOfFlight_monitor=[0,16], Counts_monitor=[1,1])
        #SaveNexus(InputWorkspace=self.module+'_1', Filename='./'+self.module+'.nxs')
        print "finish saving nexus for", self.module
        #time.sleep(60)
        _instname=str("./instrument/module/"+self.module+".xml")
        LoadInstrument(Workspace=self.module+"_1", Filename=_instname, RewriteSpectraMap='True')    
        #LoadCalFile(InputWorkspace=self.module+'_1', CalFilename='./instrument/calfile.cal', WorkspaceName=self.module+'_GPPD')
        #AlignDetectors(InputWorkspace=self.module+'_1', OutputWorkspace=self.module+'_alignD', OffsetsWorkspace=self.module+'_GPPD_offsets')
        #Rebin(InputWorkspace=self.module+'_alignD', OutputWorkspace=self.module+'_rebin', Params='0.3,0.001,4')
        ConvertUnits(InputWorkspace=self.module+'_1', OutputWorkspace=self.module+'_dfocus', Target='dSpacing', EMode='Elastic', AlignBins = True)
        SumSpectra(InputWorkspace=self.module+'_dfocus', OutputWorkspace=self.module+'_dfocus')
        #DiffractionFocussing(InputWorkspace=self.module+'_rebin', OutputWorkspace=self.module+'_dfocus', GroupingWorkspace=self.module+'_GPPD_group')
        Rebin(InputWorkspace=self.module+'_dfocus', OutputWorkspace=self.module+'_dfocus', Params='0.3,0.001,4')
        ConvertUnits(InputWorkspace=self.module+'_dfocus', OutputWorkspace=self.module+'_tof', Target='TOF')
        Rebin(InputWorkspace=self.module+'_tof', OutputWorkspace=self.module+'_tof', Params='1000,32,35000')

    def set1DdataToNeon(self,wsname, path1, path2):
        name=mtd[wsname]
        x=[]
        v=[]
        v=name.readY(0)
        _tmp=name.readX(0)
        for j in range(len(_tmp)-1):
            x.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        self.neonRedis_write.set(path1, jsonArray.jsonEncoder(x))
        self.neonRedis_write.set(path2, jsonArray.jsonEncoder(v))

    def setXYData(self, x, yaxis, counts):
        vaxis=[[] for r in range(len(yaxis))]
        num=0
        for p in range(len(yaxis)):
            for q in range(len(x)):
                vaxis[p].append(counts[num])
                num=num+1
        print self.neonpathDetSet+"/xy_image/x"
        print self.neonpathDetSet+"/xy_image/y"
        print self.neonpathDetSet+"/xy_image/value"
        self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/x", jsonArray.jsonEncoder(x))
        self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/y", jsonArray.jsonEncoder(yaxis))
        self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/value", jsonArray.jsonEncoder(vaxis))
        #numpy.savetxt("/home/mantid/online/simpleV/xy_"+self.module+".txt", vaxis, "%d")

    def dataSet(self):
        self.set1DdataToNeon(self.module+"_dfocus", "/GPPD/workspace/MantidData/"+self.module+"/d","/GPPD/workspace/MantidData/"+self.module+"/intensity")
        self.set1DdataToNeon(self.module+"_tof", "/GPPD/workspace/MantidData/"+self.module+"/tof","/GPPD/workspace/MantidData/"+self.module+"/counts")
        counts=[]
        xaxis=[]
        yaxis=[]
        zaxis=[]
        name=mtd[str(self.module+'_1')]
        for j in range(name.getNumberHistograms()):
            counts.append(sum(name.readY(j)))
            _det=name.getDetector(j)
            _pos=_det.getPos()
            xaxis.append(_pos.X())
            yaxis.append(_pos.Y())
            zaxis.append(_pos.Z())
        xaxis=list(set(xaxis))
        yaxis=list(set(yaxis))
        zaxis=list(set(zaxis))
        xaxis.sort()
        yaxis.sort()
        zaxis.sort()
        for i in range(len(yaxis)):
            yaxis[i]=yaxis[i]*1000
        for i in range(len(zaxis)):
            zaxis[i]=zaxis[i]*1000
        for i in range(len(xaxis)):
            xaxis[i]=xaxis[i]*1000
        mNum=int(self.module[6])
        if mNum==3 or mNum==4:
            self.setXYData(zaxis, yaxis, counts)
        else:
            self.setXYData(xaxis, yaxis, counts)
        print "set x,y value for all bank! ",self.module," ",datetime.datetime.now()
        DeleteWorkspace(Workspace=self.module)        
        DeleteWorkspace(Workspace=self.module+"_dfocus")        
        DeleteWorkspace(Workspace=self.module+"_tof")        
        #DeleteWorkspace(Workspace=self.module+"_GPPD_cal")        
        #DeleteWorkspace(Workspace=self.module+"_GPPD_offsets")        
        #DeleteWorkspace(Workspace=self.module+"_GPPD_mask")        
        #DeleteWorkspace(Workspace=self.module+"_GPPD_group")        

    def process(self):
        if self.myDict['configure']:
            if self.confJudge:
                self.detTof=[]
                self.detPid=[]
                for i in range(2501):
                    self.detTof.append(i*16)
                num=int(self.module[6:])
                for i in range(5328):
                    self.detPid.append(num*10000+i+1)
                print "finish new configuring for ",self.module 
                self.confJudge=False
            else:
                pass
                #print "has already configured for ",self.module 
        else:
            self.confJudge=True
        
        if self.myDict['running']:
            print "start running program"
            try:
                self.getDataFromNeon()
            except:
                self.myDict['error']=True
                self.myDict['running']=False
                print "error in get data from neon!"
            while (len(self.detValue)!=(len(self.detTof)-1)*len(self.detPid)):
                print "data size doesn't match! please waiting..."
                time.sleep(10)
                if self.myDict['running']:
                    self.getDataFromNeon()
                else:
                    break
            if self.myDict['running']:
                try:
                    print "   INFO: createWorkspace", datetime.datetime.now()
                    self.createWorkspace()
                except:
                    self.myDict['error']=True
                    self.myDict['running']=False
                    print "error in create workspace!"

                if self.myDict['running']:
                    try:
                        print "   INFO: dataSet", datetime.datetime.now()
                        self.dataSet()
                        #shutil.move("./"+self.module+".nxs","./tmp/"+self.module+".nxs" )
                    except:
                        self.myDict['error']=True
                        self.myDict['running']=False
                        print "error in set data!"
                else:
                    pass
            else:
                pass
        else:
            pass

    def run(self):
        while True:
            self.process()
            time.sleep(0.5)

