import jsonArray
import time
from multiprocessing import Process, Manager
import threading
import json

def stateMachine(command, status, commandList, statusList,myDict):
    
    if command == 0:
        if status == 1:
            myDict["configure"]= True
            status = 3
        else:
            print statusList[status]+" status cannot receive "+commandList[command]+" command"
    
    elif command == 1:
        if status == 3:
            myDict["configure"]=False
            status = 1
        else:
            print statusList[status]+" status cannot receive "+commandList[command]+" command"

    elif command == 2:
        if status == 3:
            myDict["running"]=True
            status = 4
        else:
            print statusList[status]+" status cannot receive "+commandList[command]+" command"

    elif command == 3:
        if status == 4:
            myDict['running']=False
            status = 5
        else:
            print statusList[status]+" status cannot receive "+commandList[command]+" command"

    elif command == 4:
        if status == 5:
            myDict['running']=True
            status = 4
        else:
            print statusList[status]+" status cannot receive "+commandList[command]+" command"

    elif command == 5:
        if status == 4:
            myDict['running']= False
            status = 3
        else:
            print statusList[status]+" status cannot receive "+commandList[command]+" command"
    
    elif command == 6:
        myDict['running']=False
        myDict['configure']=False
        myDict['error']=False
        status = 1
    else:
        pass

    return status

class getCommand(threading.Thread):
    def __init__(self, neonRedis, refreshtime, name, myDict, logger):
        super(getCommand, self).__init__()
        self.neonRedis_write = neonRedis
        self.neonRedis_read = neonRedis
        self.logger=logger
        self.refreshtime = refreshtime
        self.myDict=myDict
        self.name = name
        self.command=-1
        self.commandList=['configure','unconfigure','start','pause','resume','stop','abort']
        self.statusList=['waiting','unconfigured','configuring','ready','running','paused','error']

    def getCommand(self):
        #_path="/GPPD/control/test"
        _path="/GPPD/control/command/mantid/"+self.name
        try:
            _json=self.neonRedis_read.get(_path)
            _data=int(json.loads(_json))
        except:
            _data=-1
        return _data

    def setCommand(self, command):
        self.command=command

    def setStatus(self, status):
        path="/GPPD/stateMachine/status/"+self.name
        self.neonRedis_write.set(path, json.dumps(status))
    
    def getStatus(self):
        path="/GPPD/stateMachine/status/"+self.name
        _json=self.neonRedis_read.get(path)
        data=int(json.loads(_json))
        return data

    def process(self):
        while True:
            if self.myDict['error']:
                status = 6
                self.setStatus(status)

            _command=self.getCommand()
            while type(_command)!=int:
                self.logger.warning("the type of command is not int!!!")
                time.sleep(5)
                _command=self.getCommand()
            if self.command==_command:
                pass
            else:
                self.setCommand(_command)
                self.logger.debug("new command: "+str(self.command))
                status=self.getStatus()
                #print "before statemachine: ", status
                tmp=stateMachine(self.command, status, self.commandList, self.statusList, self.myDict)
                self.setStatus(tmp)
                #print "after statemachine: ",tmp
            time.sleep(self.refreshtime)

    def run(self):
        self.process()
