#!/usr/bin/python
from redis.sentinel import Sentinel
#import connect
import moduleIO
import monitorIO
from multiprocessing import Process, Manager
#from redis.sentinel import Sentinel
import dataReduction
import os
import glob
import getCommand
import heartBeat
import subprocess
import shlex
import sys

def run_this():
    mypid=str(os.getpid())
    myname=os.path.basename(__file__)
    _cmd="ps -C "+myname+" -o pid="
    pid=subprocess.check_output(_cmd, shell=True)
    pid=shlex.split(pid)
    print pid, mypid
    for p in pid:
        if p != mypid:
            try:
                _cmd="/usr/bin/kill -9 "+str(p)
                #_cmd = shlex.split(_cmd)
                subprocess.check_call(_cmd, shell=True)
                print "process  killed", p
                #logger.warning("Self process killed")
            except:
                print "process not killed", p
                #logger.warning("Self process not killed")
        else:
            pass
    print mypid
    print pid
    return mypid

class myLog():
    def __init__(self, name):
        import logging
        from logging.handlers import RotatingFileHandler
        logging.basicConfig(level=logging.DEBUG,
                format='%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s',
                datefmt='%a, %d %b %Y %H:%M:%S',
                filename='myMantid_'+name+'.log',
                filemode='w')

        self.logger = logging.getLogger('GPPD_monitor')
        hdlr = RotatingFileHandler(os.getcwd()+'/myMantid_'+name+'.log', maxBytes=10*1024*1024, backupCount=0)
        formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
        hdlr.setFormatter(formatter)
        self.logger.addHandler(hdlr)
        self.logger.setLevel(logging.DEBUG)

    def getLog(self):
        return self.logger

if __name__ == '__main__':
    #name = sys.argv[1]
    name = 'monitor'
    _log=myLog(name)
    logger= _log.getLog()
    #mypid=run_this()
    mypid=str(os.getpid())
    # ======Try to connect NEON server
    #ip_port = [('10.1.33.141', 9001)]
    ip_port = [('10.1.53.240', 9001)]
    passwd = 'sanlie;123'
    sentinel = Sentinel(ip_port, socket_timeout=10)
    r=sentinel.master_for('neonmaster', socket_timeout=30, password=passwd)

    #r = connect.connectNeon(ip_port, passwd, 10)
    #r = r.getRedisWrite()
    #r_read = r.getRedisRead()

    monitorList=['monitor1','monitor2','monitor3']
    #set command
    manager = Manager()
    myDict=manager.dict()
    myDict['configure'] = False
    myDict['running']= False
    myDict['error']=False
    print 'waiting . . .'
    init=1
    r.set("/GPPD/stateMachine/status/"+name,init)

    # create and start command thread and heartbeat thread
    myCommandThread=getCommand.getCommand(r, 0.1, name, myDict, logger)
    myCommandThread.start()
    print myCommandThread, " start!"
    # heartbeat process
    myHeartbeatThread=heartBeat.neonHeartBeat(r, 0.5, name, mypid)
    myHeartbeatThread.start()
    print myHeartbeatThread," start!"
    myPro = monitorIO.monitorIO(r, 1, monitorList, myDict,logger) 
    myPro.start()
