from mantid.simpleapi import *
import time
import redis
import datetime
import jsonArray
import multiprocessing
from multiprocessing import Process, Manager
import json
import numpy
#import shutil
import path
class reduction(multiprocessing.Process):
    def __init__(self, neonRedis, refreshtime, myDict, logger):
        super(reduction, self).__init__()
        self.logger=logger
        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis
        self.neonRedis_read=neonRedis
        self.myDict=myDict
        self.groupList1=['module131', 'module132', 'module133', 'module231', 'module232', 'module233']
        self.groupList2=['module322', 'module331', 'module332', 'module333', 'module341', 'module342', 'module343', 'module422', 'module431', 'module432', 'module433', 'module441', 'module442', 'module443']
        self.groupList3=['module521', 'module522', 'module523', 'module531', 'module532', 'module533', 'module541', 'module542', 'module543', 'module621', 'module622', 'module623', 'module631', 'module632', 'module633', 'module641', 'module642', 'module643']

    def get1Ddata(self, path):
        data=[]
        _json=self.neonRedis_read.get(path)
        while _json is None:
            self.logger.warning("no 1D data in data reduction"+path)
            time.sleep(5)
            _json=self.neonRedis_read.get(path)
        data=jsonArray.jsonDecoder(_json)
        #print data
        return data
    
    def getProtonCharge(self):
        data=[]
        path="/GPPD/drone/proton_charge"
        _json=self.neonRedis_read.get(path)
        if _json is None:
            return 1
        else:
            data=jsonArray.jsonDecoder(_json)
            #print data
            val=data[1][-1]
            if(type(val)==int):
                return val
            else:
                return 1
            #if val==0:
            #    return 1

 
    def mergeData(self,groupList, path):
        # merge raw I-d I-tof
        tmp2=[]
        value2=[]
        num=0
        print "start merge data in: " ,path
        for i in range(len(groupList)):
            data2=[]
            data2=self.get1Ddata(path+"/"+groupList[i]+"/intensity")
            print "num data2: ", len(data2), groupList[i]
            num=len(data2)
            tmp2.append(data2)
            #print groupList[i]

        print len(tmp2), len(tmp2[0])
        for j in range(num):
            ans2=0
            for k in range(len(groupList)):
                if not numpy.isnan(tmp2[k][j]) and numpy.isfinite(tmp2[k][j]):
                    ans2=ans2+tmp2[k][j]
                else:
                    pass
            value2.append(ans2)
            #print "ans2: ",ans2," ",j
        #print "length of value: ", len(value2)
        return value2
        
    def setGroupData(self, groupList, groupName):
        # set raw data
        value=self.mergeData(groupList, "/GPPD/workspace/MantidData")
        print "hello1"
        json_x2=self.neonRedis_read.get("/GPPD/workspace/MantidData/"+groupList[0]+"/d")
        num=0
        x2=jsonArray.jsonDecoder(json_x2)
        for i in range(len(x2)):
            if groupName == 'group03':
                if x2[i]>2.8:
                    num=i
                    break
            else:
                num=len(x2)
                break
        x22=x2[:num]
        value2=value[:num] 
        json_x22=jsonArray.jsonEncoder(x22)
        json_value2=jsonArray.jsonEncoder(value2)
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/raw/d", json_x22)
        #self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/PC/d", x2)
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/raw/intensity", json_value2)

        x1=[]
        for ix in x2:
            x1.append(ix*40000.0/2.8)
        for i in range(len(x1)):
            if x1[i]>40000:
                num=i
                break
        x11=x1[:num]
        value22=value[:num]
        print x11
        json_x11=jsonArray.jsonEncoder(x11)
        json_value22=jsonArray.jsonEncoder(value22)
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/raw/tof", json_x11)
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/raw/counts", json_value22)
        #print "hello3"
        #set nor data by PC
        for i in range(len(value)):
            value[i]=value[i]/self.proton
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/PC/counts", jsonArray.jsonEncoder(value))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/PC/intensity", jsonArray.jsonEncoder(value))
        print "hello4"
        #set nor data by monitor
        #value11,value22=self.mergeData(groupList, "/GPPD/workspace/MantidData/reduction")
        #x11= self.neonRedis_read.get("/GPPD/workspace/MantidData/reduction/"+groupList[0]+"/tof")
        #self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/monitor/tof", x11)
        #self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/monitor/counts", jsonArray.jsonEncoder(value11))
        
        #x22= self.neonRedis_read.get("/GPPD/workspace/MantidData/reduction/"+groupList[0]+"/d")
        #self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/monitor/d", x22)
        #self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/monitor/intensity", jsonArray.jsonEncoder(value22))
        

    def setNeutronCounts(self):
        num=0
        for name in self.groupList1:
            try:
                num+=int(json.loads(self.neonRedis_read.get("/GPPD/workspace/MantidData/"+name+"/neutroncounts")))
            except:
                self.logger.debug("no neutron counts in "+name)
        for name in self.groupList2:
            try:
                num+=int(json.loads(self.neonRedis_read.get("/GPPD/workspace/MantidData/"+name+"/neutroncounts")))
            except:
                self.logger.debug("no neutron counts in "+name)

        for name in self.groupList3:
            try:
                num+=int(json.loads(self.neonRedis_read.get("/GPPD/workspace/MantidData/"+name+"/neutroncounts")))
            except:
                self.logger.debug("no neutron counts in "+name)
        self.neonRedis_write.set("/GPPD/workspace/MantidData/neutroncounts", json.dumps(num))

    def process(self):
        if self.myDict['configure']:
            self.proton=self.getProtonCharge()
            if float(self.proton) == 0.0:
                self.proton = 1
            #path.clearRedis(self.neonRedis_write)
            #pass
        else:
            pass
        
        if self.myDict['running']:
            #try:
            self.logger.debug('start running processing')
            self.setNeutronCounts()
            #print 1111
            self.setGroupData(self.groupList1,"group01")
            #print 2222
            self.setGroupData(self.groupList2,"group02")
            self.setGroupData(self.groupList3,"group03")
            self.logger.debug("finish data focussing for 3 group!")
            #except:
            #    self.myDict['error']=True
            #    self.myDict['running']=False
            #    self.myDict['configure']=False
        else:
            pass

    def run(self):
        while True:
            time.sleep(self.refreshtime)
            self.process()
    
