#!/usr/bin/python
# -*- coding: utf-8 -*-

import math
import random
from math import atan
from numpy import *
from scipy import pi, log
import numpy as np
import time
import thread
import threading
from scipy.interpolate import interp1d
from scipy.interpolate import InterpolatedUnivariateSpline
from scipy.interpolate import UnivariateSpline
from time import gmtime, strftime
import json

from globalClass import *
from neon.Neon import *

class neonHeartBeatSender():

    def __init__(
        self,
	threadID,
        ip,
        port,
        bankID,
        freshTime,
        ):

        threading.Thread.__init__(self)
        self.paused = False
        self.pause_cond = threading.Condition(threading.Lock())

        self.can_run = threading.Event()
        self.threadID = threadID
        self.bankID = bankID
        self.freshTime = freshTime

        self.neon = NeonRedis(host=ip, port=port, db=0, isWritable=True)

	self.heartBeatCounts = 0
	self.heartBeat = None	

    def process(self):
	self.heartBeatCounts += 1 
	timeStamp = strftime("%Y-%m-%d %H:%M:%S", gmtime()) 
	
	self.heartBeat = u'{"timeStamp":timeStamp,"HeartBeat Counts" self.heartBeatCounts}'
	return self.heartBeat

    def run(self):
        while True:
            try:
		time.sleep(self.freshTime)
                self.process()
            except:
                break

    def pause(self):
        self.paused = True
        self.pause_cond.acquire()

    def resume(self):
        self.paused = False
        self.pause_cond.notify()
        self.pause_cond.release()

    def stop(self):
        self.paused = True
        self.pause_cond.acquire()
        self.can_run.set()

def isNeonConnector(ip, port):

    try:
        NeonRedis(ip, port, db=0, isWritable=True)
    except:
        return False

    return True


