#!/usr/bin/python
# -*- coding: utf-8 -*-

# for pyqt4

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for 2d plot

import matplotlib
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg as FigureCanvas
from matplotlib.figure import Figure


class CSNSCanvas(FigureCanvas):

    def __init__(
        self,
        width=3,
        height=2,
        dpi=150,
        title='',
        xlabel='',
        ylabel='',
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor='white',
            edgecolor=None,
            linewidth=1.0,
            frameon=False,
            tight_layout=False,
            )

        self.fig.patch.set_alpha(0.1)
        self.ax = self.fig.add_subplot(111)  # axisbg='r'
        self.ax.tick_params(axis='both', which='major', labelsize=5)
        self.fig.subplots_adjust(left=0.12, bottom=0.25, right=0.95,
                                 top=0.95)

        self.xtitle = ''
        self.ytitle = ''

        self.ax.set_xlabel(xlabel, fontsize=5)
        self.ax.set_ylabel(ylabel, fontsize=5)

        self.PlotTitle = title
        self.grid_status = True
        self.xaxis_style = 'linear'
        self.yaxis_style = 'linear'
        #self.ax.hold(True)

        # self.ax.patch.set_alpha(0)

        FigureCanvas.__init__(self, self.fig)
        FigureCanvas.setSizePolicy(self, QtGui.QSizePolicy.Expanding,
                                   QtGui.QSizePolicy.Expanding)
        FigureCanvas.updateGeometry(self)

        self.draw()


