from mantid.simpleapi import *
import jsonArray
from Queue import Queue
import time
import numpy as np
import redis
import sys
import datetime
import cStringIO
import setDataToNeon
import json
import random
import multiprocessing
from multiprocessing import Process, Manager

class moduleDataGet(multiprocessing.Process):
    def __init__(self, neonRedis, refreshtime, module, myDict):
        super(moduleDataGet, self).__init__()
        self.started=True
        self.confJudge=True

        self.myDict=myDict
        self.refreshtime=refreshtime
        self.neonRedis=neonRedis
        self.module=module
        self.prepath="/GPPD/workspace/test/detector/"
        self.neonpathDetValue=self.prepath+self.module+"/value"
        self.neonpathDetPid=self.prepath+self.module+"/pid"
        self.neonpathDetTof=self.prepath+self.module+"/tof"
        self.started=True
        self.stopped=False
        # set data path to neon
        self.neonpathDetSet="/GPPD/workspace/MantidData/"+self.module
        #self.myDict['state']=True


    def getconf(self):
        confxml=ElementTree.parse('./GPPD_configure.xml')
        root=confxml.getroot()
        det=confxml.findall("type")
        mName=[]
        for comp in det:
            bNode=comp.getiterator("component")
            bName=comp.attrib["name"]
            if bName=="Monitor":
                pass
            else:
                for mm in bNode:
                    mName.append(mm.attrib["name"])
        return mName

    def get1Ddata(self, path):
        be=time.time()
        data=[]
        _json=self.neonRedis.get(path)
        while _json is None:
            print "no 1D data in module!",self.module
            time.sleep(5)
            _json=self.neonRedis.get(path)
        _array=jsonArray.jsonDecoder(_json)
        for k in _array:
            data.append(int(k))
        #print (time.time()-be), "success in get 1D data in ",self.module
        return data
 
    def get2Ddata(self, path):
        be=time.time()
        data=[]
        _json=self.neonRedis.get(path)
        #print "json: ", type(_json)
        while _json is None:
            print "no 2D data in module!",self.module
            _json=self.neonRedis.get(path)
            time.sleep(20)
        _array=jsonArray.jsonDecoder(_json)
	    #print type(_array)
        for ix in _array:
            for iy in ix:
                data.append(int(iy))
        return data
    def getDataFromNeon(self):
        be=time.time()
        self.detValue=self.get2Ddata(self.neonpathDetValue)
        print "   INFO: get data from neon. ",time.time()-be
        print time.time()-be

    def createWorkspace(self):
        be=time.time()
        LoadCSNSRaw(OutputWorkspace=self.module, PixelID_bank=self.detPid, TimeOfFlight_bank=self.detTof, Counts_bank=self.detValue, PixelID_monitor=[0,1], TimeOfFlight_monitor=[0,16], Counts_monitor=[1,1])
        _instname=str("../instrument/idfData/"+self.module+".xml")
        LoadInstrument(Workspace=self.module+"_1", Filename=_instname, RewriteSpectraMap='True')
        #print "   INFO: Mantid Workspace updated. ",time.time()-be
        #print time.time()-be
    
    def dataSet(self):
        #self.get3DXYZMonitor()
        be=time.time()
        setDataToNeon.setPidCountsData(self.neonRedis, self.module, self.neonpathDetSet)
        setDataToNeon.setXYBankData(self.neonRedis,self.module, self.neonpathDetSet)
        #print "finish dataSet! ",time.time()-be

    def process(self):
        be=time.time()
        if self.myDict['state']:
            if self.myDict['configure']:
                if self.confJudge:
                    self.detPid=self.get1Ddata(self.neonpathDetPid)
                    self.detTof=self.get1Ddata(self.neonpathDetTof)
                    self.confJudge=False
                    print  "finish configuring for ",self.module
                else:
                    pass
            else:
                self.confJudge=True

            #if not self.myDict['start']:
                #self.started=True

            if self.myDict['running']:
                #if self.myDict['start'] and self.started:    
                    #setDataToNeon.setZero(self.neonRedis, self.neonpathDetSet)
                    #self.started=False                
                #else:
                    #pass
                if not self.myDict['pause']:
                    print "   INFO: getDataFromNeon for ", self.module
                    self.getDataFromNeon()
                    while (len(self.detValue)!=(len(self.detTof)-1)*len(self.detPid)):
                        print "data size doesn't match! please waiting..."
                        time.sleep(10)
                        self.getDataFromNeon()
                    if not self.myDict['pause']:
                        print "   INFO: createWorkspace", datetime.datetime.now()
                        self.createWorkspace()
                        if not self.myDict['pause']:
                            print "   INFO: dataSet", datetime.datetime.now()
                            self.dataSet()
                            print "===================================="
                            print self.module, " finish!!! ",time.time()-be, "seconds"
                        else:
                            pass
                    else:
                        pass
                else:
                    pass
            else:
                time.sleep(2)
        else:
            pass
            time.sleep(2)

    def run(self):
            
        while True:
            #if self.myDict['break']:
            #    break
            self.process()

class connectNeon():

    def __init__(
        self,
        ip,
        port,
        timeout,
        ):

        self.status=False
        client=None
        self.server=None
        begin=time.time()

        while True:
            if not client:
                self.server = redis.Redis(host=ip, port=port, db=0)
                self.status=True
                print "   INFO: NEON Started"
                break
            else:
                if time.time()-begin>timeout:
                    print "   ERROR: Connect NEON timeout"  
                    sys.exit()
                    #break
                try:
                    print "   INFO: Attempt to connect NEON"  
                    client=redis.client_list()
                except:
                    pass

    def getServer(self):
        return self.server
