from mantid.simpleapi import *
import jsonArray
import threading
import neonIO
import time
from Queue import Queue
import sys
import numpy as np
from canvas import *
import cStringIO
import configure
#import stateMachine
from PyQt4 import QtCore
#from constant import *

class getCommand(QtCore.QThread):
    def __init__(self, neonRedis, refreshtime):
        QtCore.QThread.__init__(self)
        self.neonRedis = neonRedis
        self.refreshtime = refreshtime
        self.command = ''
        self.call = True
    
    def getCommand(self):
        _path="/GPPD/stateMachine/command"
        _json=self.neonRedis.get(_path)
        return _json

    def setCommand(self, command):
        #constant.command=command
        self.command=command

    def process(self):
        while True:
            _be=time.time()
            _command=self.getCommand()
            if self.command==_command:
                self.call = False
                #print "no new command!"
                #constant.commandCall=False
            else:
                self.setCommand(_command)
                #print "new command: ", self.command
                #constant.commandCall=True
            time.sleep(self.refreshtime)

    def run(self):
        self.process()

def stateMachine(neonRedis, status, command, thread, started):
    if status == 'waiting':
        print 'waiting status cannot reveive any command'
        status='unconfigured'

    if command == 'configure':
        if status == 'unconfigured':
            status = 'configuring'
            print "status change to configuring"
            thread=neonIO.dataGet(neonRedis, 1)
            thread.start()
            thread.pause()
            status = 'ready'
            print "status change to ready"
        elif status == 'configuring':
            print "configuring status cannot receive configure command"
        elif status == 'ready':
            print "ready status cannot receive configure command"
        elif status == 'running':
            print "running status cannot receive configure command"
        elif _status == 'paused':
            print "paused status cannot receive configure command"
        #elif _status == 'stopped':
            #print "stopped status cannot receive configure command"
        started=False

    elif command == 'unconfigure':
        if status == 'unconfigured':
            print "unconfigured status cannot receive unconfigure command"
        elif status == 'configuring':
            print "configuring status cannot receive unconfigure command"
        elif status == 'ready':
            #thread.terminate()
            status = 'unconfigured'
            print "status change to unconfigured"
        elif status == 'running':
            print "running status cannot receive unconfigure command"
        elif status == 'paused':
            print "paused status cannot receive unconfigure command"
        #elif status == 'stopped':
            #print "stopped status cannot receive unconfigure command"
        started=False

    elif command == 'start':
        if status == 'unconfigured':
            print "unconfigured status cannot receive start command"
        elif status == 'configuring':
            print "configuring status cannot receive start command"
        elif status == 'ready':
            print "begin to run!!!"
            thread.resume()
            status = 'running'
            print "status change to running"
        elif status == 'running':
            print "running status cannot receive start command"
        elif status == 'paused':
            print "paused status cannot receive start command"
        #elif status == 'stopped':
            #print "stopped status cannot receive start command"
        started=False

    elif command == 'pause':
        if status == 'unconfigured':
            print "unconfigured status cannot receive pause command"
        elif status == 'configuring':
            print "configuring status cannot receive pause command"
        elif status == 'ready':
            print "ready status cannot receive pause command"
        elif status == 'running':
            thread.pause()
            status = 'paused'
            print "status change to paused"
        elif status == 'paused':
            print "paused status cannot receive pause command"
        #elif status == 'stopped':
            #print "stopped status cannot receive pause command"
        started=False

    elif command == 'resume':
        if status == 'unconfigured':
            print "unconfigured status cannot receive resume command"
        elif status == 'configuring':
            print "configuring status cannot receive resume command"
        elif status == 'ready':
            print "ready status cannot receive resume command"
        elif status == 'running':
            print "running status cannot receive resume command"
        elif status == 'paused':
            thread.resume()
            status = 'running'
            print "status change to runninig"
        #elif status == 'stopped':
            #print "stopped status cannot receive resume command"
        started=False

    elif command == 'stop':
        if status == 'unconfigured':
            print "unconfigured status cannot receive stop command"
        elif status == 'configuring':
            print "configuring status cannot receive stop command"
        elif status == 'ready':
            print "ready status cannot receive stop command"
        elif status == 'running':
            thread.stop()
            status = 'ready'
            print "status change to stopped"
        elif status == 'paused':
            print "paused status cannot receive stop command"
        #elif status == 'stopped':
            #print "stopped status cannot receive stop command"
        started=False

    elif command == 'abort':
        if status == 'unconfigured':
            print "unconfigured status cannot receive stop command"
        elif status == 'configuring':
            status = 'unconfigured'
            print "status change to unconfigured"
        elif status == 'ready':
            print "ready status cannot receive stop command"
        elif status == 'running':
            thread.stop()
            status = 'ready'
        elif status == 'paused':
            print "paused status cannot receive abort command"
        #elif status == 'stopped':
            #print "stopped status cannot receive abort command"
        started = False

    print "status: ", status
    return started, status, thread        
