class Configure():
    def __init__(self):
        # setting for Detector
        self.bankGroup=['Bank01', 'Bank02', 'Bank03', 'Bank04', 'Bank05', 'Bank06']
        self.bankList={'Bank01':[3,4], 'Bank02':[1,2], 'Bank03':[5], 'Bank04':[6], 'Bank05':[7], 'Bank06':[8]}
        #self.bankList={'Bank01':[1,2,3,4], 'Bank02':[5,6,7,8], 'Bank03':[1,2,3,4], 'Bank04':[5,6,7,8], 'Bank05':[1,2,3,4], 'Bank06':[5,6,7,8]}
        # setting for Monitor
        self.monitorGroup=['Monitor01', 'Monitor02', 'Monitor03']
        self.monitorList={'Monitor01':[1],'Monitor02':[2],'Monitor03':[3]}
        self.neonpathDetPid=[]
        self.neonpathDetTof=[]
        self.neonpathDetValue=[]
        self.neonpathMonPid=[]
        self.neonpathMonTof=[]
        self.neonpathMonValue=[]        
    
    def getBankInputPath(self):
        _n=len(self.bankGroup)
        _neonpathDetPid=[[] for k in range(_n)]
        _neonpathDetTof=[[] for k in range(_n)]
        _neonpathDetValue=[[] for k in range(_n)]
        _prefix="/GPPD/workspace/test/data/module"
        #_prefix="/GPPD/workspace/detector/module"
        for i in range(_n):
            #_neonpathDetPid.append([])
            _m=self.bankList[self.bankGroup[i]]
            print _m
            for j in _m:
                print j
                _neonpathDetPid[i].append(_prefix+str(j).zfill(2)+"/pid")
                _neonpathDetTof[i].append(_prefix+str(j).zfill(2)+"/tof")
                _neonpathDetValue[i].append(_prefix+str(j).zfill(2)+"/value")
        return _neonpathDetPid, _neonpathDetTof, _neonpathDetValue

    def getMonitorInputPath(self):
        _n=len(self.monitorGroup)
        _neonpathMonPid=[[] for k in range(_n)]
        _neonpathMonTof=[[] for k in range(_n)]
        _neonpathMonValue=[[] for k in range(_n)]
        _prefix="/GPPD/workspace/test/data/monitor"
        #_prefix="/GPPD/workspace/monitor"
        for i in range(_n):
            #_neonpathMonPid.append([])
            _m=self.monitorList[self.monitorGroup[i]]
            print _m
            for j in _m:
                _neonpathMonPid[i].append(_prefix+str(j).zfill(2)+"/pid")
                _neonpathMonTof[i].append(_prefix+str(j).zfill(2)+"/tof")
                _neonpathMonValue[i].append(_prefix+str(j).zfill(2)+"/value")
        return _neonpathMonPid, _neonpathMonTof, _neonpathMonValue

    def getBankOutputPath(self):
        _neonpathDetPidImg=[]
        _neonpathDetXYImg=[]
        _neonpathDetTofSet=[]
        _neonpathDetCountsSet=[]
        for i in range(len(self.bankGroup)):
            _neonpathDetPidImg.append("/GPPD/workspace/MantidData/bank"+str(i+1).zfill(2)+"/pid_image/")
            _neonpathDetXYImg.append("/GPPD/workspace/MantidData/bank"+str(i+1).zfill(2)+"/xy_image/")
            _neonpathDetTofSet.append("/GPPD/workspace/MantidData/group"+str(i+1).zfill(2)+"/tof")
            _neonpathDetCountsSet.append("/GPPD/workspace/MantidData/group"+str(i+1).zfill(2)+"/counts")
        return _neonpathDetPidImg, _neonpathDetXYImg, _neonpathDetTofSet, _neonpathDetCountsSet
    
    def getMonitorOutputPath(self):
        _neonpathMonPidImg=[]
        _neonpathMonTofSet=[]
        _neonpathMonCountsSet=[]
        _neonpathMonXSet=[]
        _neonpathMonYSet=[]
        _neonpathMonValueSet=[]
        for i in range(len(self.monitorGroup)):
            _neonpathMonPidImg.append("/GPPD/workspace/MantidData/monitor"+str(i+1).zfill(2)+"/pid_image")
            _neonpathMonTofSet.append("/GPPD/workspace/MantidData/monitor"+str(i+1).zfill(2)+"/tof")
            _neonpathMonCountsSet.append("/GPPD/workspace/MantidData/monitor"+str(i+1).zfill(2)+"/counts")
            _neonpathMonXSet.append("/GPPD/workspace/MantidData/monitor"+str(i+1).zfill(2)+"/axis_x")
            _neonpathMonYSet.append("/GPPD/workspace/MantidData/monitor"+str(i+1).zfill(2)+"/axis_y")
            _neonpathMonValueSet.append("/GPPD/workspace/MantidData/monitor"+str(i+1).zfill(2)+"/value")
        return _neonpathMonPidImg, _neonpathMonTofSet, _neonpathMonCountsSet, _neonpathMonXSet, _neonpathMonYSet, _neonpathMonValueSet

    def getConfigure(self):
        self.neonpathDetPid, self.neonpathDetTof, self.neonpathDetValue=self.getBankInputPath()
        self.neonpathMonPid, self.neonpathMonTof, self.neonpathMonValue=self.getMonitorInputPath()
        self.neonpathDetPidImg, self.neonpathDetXYImg, self.neonpathDetTofSet, self.neonpathDetCountsSet=self.getBankOutputPath()
        self.neonpathMonPidImg, self.neonpathMonTofSet, self.neonpathMonCountsSet, self.neonpathMonXSet, self.neonpathMonYSet, self.neonpathMonValueSet=self.getMonitorOutputPath() 
