from mantid.simpleapi import *
import jsonArray
import time
import datetime
import json
import multiprocessing
from multiprocessing import Process, Manager

class moduleIO(multiprocessing.Process):
    def __init__(self, neonRedis_write, neonRedis_read, refreshtime, module):
        super(moduleIO, self).__init__()

        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis_write
        self.neonRedis_read=neonRedis_read
        self.module=module
        self.neonpathDetValue="/GPPD/workspace/detector/"+self.module+"/value"
        self.neonpathDetPid="/GPPD/workspace/detector/"+self.module+"/pid"
        self.neonpathDetTof="/GPPD/workspace/detector/"+self.module+"/tof"
        self.neonpathDetSet="/GPPD/workspace/MantidData/"+self.module

    def get1Ddata(self, path):
        data=[]
        _json=self.neonRedis_read.get(path)
        while _json is None:
            print "no 1D data in module!",self.module," ",datetime.datetime.now()
            time.sleep(5)
            _json=self.neonRedis_read.get(path)
        data=jsonArray.jsonDecoder(_json)
        #for k in _array:
        #    data.append(k)
        return data
 
    def getDataFromNeon(self):
        be=time.time()
        self.detValue = []
        _json=self.neonRedis_read.get(self.neonpathDetValue)
        while _json is None:
            print "no 2D data in module!",self.module," ", datetime.datetime.now()
            _json=self.neonRedis_read.get(self.neonpathDetValue)
            time.sleep(20)
        _array=jsonArray.jsonDecoder(_json)
        a=0
        for ix in _array:
            a=a+sum(ix)
            for iy in ix:
                self.detValue.append(iy)
        print "total neutrons: ",a, " ", self.module," ", datetime.datetime.now()

    def createWorkspace(self):
        be=time.time()
        LoadCSNSRaw(OutputWorkspace=self.module, PixelID_bank=self.detPid, TimeOfFlight_bank=self.detTof, Counts_bank=self.detValue, PixelID_monitor=[0,1], TimeOfFlight_monitor=[0,16], Counts_monitor=[1,1])
        #SaveNexus(InputWorkspace=self.module+'_1', Filename='./'+self.module+'.nxs')
        _instname=str("./instrument/module/"+self.module+".xml")
        LoadInstrument(Workspace=self.module+"_1", Filename=_instname, RewriteSpectraMap='True')    

    def setXYData(self, x, yaxis, counts):
        vaxis=[[] for r in range(len(yaxis))]
        num=0
        for p in range(len(yaxis)):
            for q in range(len(x)):
                vaxis[p].append(counts[num])
                num=num+1
        print self.neonpathDetSet+"/xy_image/x"
        print self.neonpathDetSet+"/xy_image/y"
        print self.neonpathDetSet+"/xy_image/value"
        self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/x", jsonArray.jsonEncoder(x))
        self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/y", jsonArray.jsonEncoder(yaxis))
        self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/value", jsonArray.jsonEncoder(vaxis))

    def dataSet(self):
        pid=[]
        counts=[]
        xaxis=[]
        yaxis=[]
        zaxis=[]
        name=mtd[str(self.module+'_1')]
        for j in range(name.getNumberHistograms()):
            pid.append(j)
            counts.append(sum(name.readY(j)))
            _det=name.getDetector(j)
            _pos=_det.getPos()
            xaxis.append(_pos.X())
            yaxis.append(_pos.Y())
            zaxis.append(_pos.Z())
        # set pid-counts data
        print self.neonpathDetSet+"/pid_image/x"
        print self.neonpathDetSet+"/pid_image/value"
        self.neonRedis_write.set(self.neonpathDetSet+"/pid_image/x", jsonArray.jsonEncoder(pid))
        self.neonRedis_write.set(self.neonpathDetSet+"/pid_image/value", jsonArray.jsonEncoder(counts))
        print "finish set pid-counts detector data! ",self.module, " ", datetime.datetime.now()
        # set xy bank data
        xaxis=list(set(xaxis))
        yaxis=list(set(yaxis))
        zaxis=list(set(zaxis))
        xaxis.sort()
        yaxis.sort()
        zaxis.sort()
        for i in range(len(yaxis)):
            yaxis[i]=yaxis[i]*1000
        for i in range(len(zaxis)):
            zaxis[i]=zaxis[i]*1000
        for i in range(len(xaxis)):
            xaxis[i]=xaxis[i]*1000

        mNum=int(self.module[6])
        if mNum==3 or mNum==4:
            self.setXYData(zaxis, yaxis, counts)
        else:
            self.setXYData(xaxis, yaxis, counts)
        print "set x,y value for all bank! ",self.module," ",datetime.datetime.now()
        DeleteWorkspace(Workspace=self.module)        

    def process(self):
        self.detTof=[]
        for i in range(2501):
            self.detTof.append(i*16)
        self.detPid=self.get1Ddata(self.neonpathDetPid)
        print " get pid and tof data successfully for ",self.module, " ", datetime.datetime.now()
        self.getDataFromNeon()
        while (len(self.detValue)!=(len(self.detTof)-1)*len(self.detPid)):
            print "data size doesn't match! please waiting..."
            time.sleep(10)
            self.getDataFromNeon()
        print "   INFO: createWorkspace", datetime.datetime.now()
        self.createWorkspace()
        print "   INFO: dataSet", datetime.datetime.now()
        self.dataSet()

    def run(self):
            
        while True:
            self.process()
            time.sleep(0.5)

