from mantid.simpleapi import *
import jsonArray
import time
import datetime
import json
import multiprocessing
from multiprocessing import Process, Manager

class monitorIO(multiprocessing.Process):
    def __init__(self, neonRedis_write, neonRedis_read, refreshtime, monitorList):
        super(monitorIO, self).__init__()

        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis_write
        self.neonRedis_read=neonRedis_read

        self.monitorList=monitorList
        self.prepath="/GPPD/workspace/"

        self.neonpathMonValue=[]
        self.neonpathMonPid=[]
        self.neonpathMonTof=[]
            
        for name in self.monitorList:
            self.neonpathMonValue.append("/GPPD/workspace/gppd:"+name+"/value")
            self.neonpathMonPid.append("/GPPD/workspace/gppd:"+name+"/pid")
            #self.neonpathMonTof.append("/GPPD/workspace/gppd:"+name+"/tof")
        print "111111"
    def get1Ddata(self,monitor, path):
        data=[]
        _json=self.neonRedis_read.get(path)
        while _json is None:
            print "no 1D data in ",monitor," ",datetime.datetime.now()
            time.sleep(5)
            _json=self.neonRedis_read.get(path)
        data=jsonArray.jsonDecoder(_json)
        return data
 
    def getDataFromNeon(self, monitor, path):
        self.monValue=[]
        _json=self.neonRedis_read.get(path)
        #print "json: ", type(_json)
        while _json is None:
            print "no 2D data in ",monitor, " ", datetime.datetime.now()
            _json=self.neonRedis_read.get(path)
            time.sleep(10)
        _array=jsonArray.jsonDecoder(_json)
        a=0
        for ix in _array:
            a=a+sum(ix)
            for iy in ix:
                self.monValue.append(iy)
        print "get data from neon successfully ", monitor," Ncounts:", a," ",datetime.datetime.now()

    def createWorkspace(self, monitor):
        LoadCSNSRaw(OutputWorkspace=monitor, PixelID_bank=[0,1], TimeOfFlight_bank=[0,8], Counts_bank=[1,1], PixelID_monitor=self.monPid, TimeOfFlight_monitor=self.monTof, Counts_monitor=self.monValue)
        #SaveNexus(InputWorkspace=self.monitor+'_1', Filename='./'+self.monitor+'.nxs')
        #CloneWorkspace(InputWorkspace=self.monitor+"_2", OutputWorkspace=str(self.monitor))
        LoadInstrument(Workspace=monitor+"_2", Filename='./instrument/'+monitor+'.xml', RewriteSpectraMap='True')

    def dataSet(self, monitor):
        # set tof counts
        SumSpectra(InputWorkspace=monitor+'_2', OutputWorkspace="tofCounts", IncludeMonitors=True)
        name=mtd["tofCounts"]
        tof=[]
        counts=[]
        counts=name.readY(0)
        print "monitor counts: ",sum(counts)
        _tmp=name.readX(0)
        for j in range(len(_tmp)-1):
            tof.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/tof", jsonArray.jsonEncoder(tof))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/counts", jsonArray.jsonEncoder(counts))
        print "set tof and counts data for ", monitor, " ", datetime.datetime.now()
        # set XY data
        xaxis=[]
        yaxis=[]
        counts=[]
        name=mtd[monitor+"_2"]
        for j in range(name.getNumberHistograms()):
            det=name.getDetector(j)
            pos=det.getRelativePos()
            xaxis.append(pos.X())
            yaxis.append(pos.Y())
            counts.append(sum(name.readY(j)))
        xaxis=list(set(xaxis))
        yaxis=list(set(yaxis))
        xaxis.sort()
        yaxis.sort()
        vaxis=[[] for m in range(len(yaxis))]
        n=0
        for j in range(len(yaxis)):
            for k in range(len(xaxis)):
                vaxis[j].append(counts[n])
                n=n+1
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/axis_x",jsonArray.jsonEncoder(xaxis))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/axis_y",jsonArray.jsonEncoder(yaxis))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/value",jsonArray.jsonEncoder(vaxis))
        print "set xy data for ", monitor, " ", datetime.datetime.now()
        DeleteWorkspace(Workspace=monitor)
        DeleteWorkspace(Workspace='tofCounts')

    def process(self):
        self.monTof=[]
        for i in range(2501):
            self.monTof.append(i*16)
        for i in range(len(self.monitorList)):
            self.monPid=self.get1Ddata(self.monitorList[i], self.neonpathMonPid[i])
            print "get pid and tof for ",self.monitorList[i]," ",datetime.datetime.now()        
            self.getDataFromNeon(self.monitorList[i], self.neonpathMonValue[i])
            while (len(self.monValue)!=(len(self.monTof)-1)*len(self.monPid)):
                print "data size doesn't match! please waiting..."
                time.sleep(10)
                self.getDataFromNeon(self.monitorList[i], self.neonpathMonValue[i])
            print "   INFO: createWorkspace", datetime.datetime.now()
            self.createWorkspace(self.monitorList[i])
            print "   INFO: dataSet", datetime.datetime.now()
            self.dataSet(self.monitorList[i])

    def run(self):
        while True:
            self.process()
            time.sleep(0.5)

