from mantid.simpleapi import *
import time
import redis
import datetime
import jsonArray
import multiprocessing
from multiprocessing import Process, Manager


class reduction(multiprocessing.Process):
    def __init__(self, neonRedis_read, neonRedis_write, refreshtime, moduleList,groupname):
        super(reduction, self).__init__()

        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis_write
        self.neonRedis_read=neonRedis_read
        self.moduleList=moduleList
        self.group=groupname
        self.neonpathDetValue=[]
        self.neonpathDetPid=[]
        self.neonpathDetTof=[]
        self.neonpathDetSet="/GPPD/workspace/MantidData/"+self.group
        for name in self.moduleList:
            self.neonpathDetValue.append("/GPPD/workspace/detector/"+name+"/value")
            self.neonpathDetPid.append("/GPPD/workspace/detector/"+name+"/pid")
            self.neonpathDetTof.append("/GPPD/workspace/detector/"+name+"/tof")
        
    def get1Ddata(self, path):
        data=[]
        _json=self.neonRedis_read.get(path)
        while _json is None:
            print "no 1D data in ",path," ",datetime.datetime.now()
            time.sleep(5)
            _json=self.neonRedis_read.get(path)
        data=jsonArray.jsonDecoder(_json)
        return data

    def get2Ddata(self, path):
        data = []
        _json=self.neonRedis_read.get(path)
        while _json is None:
            print "no 2D data in ",path," ", datetime.datetime.now()
            _json=self.neonRedis_read.get(path)
            time.sleep(20)
        _array=jsonArray.jsonDecoder(_json)
        for ix in _array:
            for iy in ix:
                data.append(iy)
        return data

    def getTofData(self):
        self.detTof=[]
        for i in range(2501):
            self.detTof.append(i*16)

           
    def getDataFromNeon(self):
        self.getTofData() 
        self.detPid=[]
        self.detValue=[]
        for i in range(len(self.moduleList)):
            pathPid=self.neonpathDetPid[i]
            pathValue=self.neonpathDetValue[i]
            self.detPid.extend(self.get1Ddata(pathPid))
            self.detValue.extend(self.get2Ddata(pathValue))
        #print len(self.detPid)


    def createWorkspace(self):
        LoadCSNSRaw(OutputWorkspace=self.group, PixelID_bank=self.detPid, TimeOfFlight_bank=self.detTof, Counts_bank=self.detValue, PixelID_monitor=[0,1], TimeOfFlight_monitor=[0,16], Counts_monitor=[1,1])
        #SaveNexus(InputWorkspace=self.module+'_1', Filename='./'+self.module+'.nxs')
        _instname=str("./instrument/"+self.group+".xml")
        LoadInstrument(Workspace=self.group+"_1", Filename=_instname, RewriteSpectraMap='True')
        SumSpectra(InputWorkspace=self.group+"_1", OutputWorkspace="tofCounts", IncludeMonitors=False)
        ConvertUnits(InputWorkspace='tofCounts', OutputWorkspace='waveCounts', Target='Wavelength')


    def setTofCounts(self):
        name=mtd["tofCounts"]
        counts=name.readY(0)
        tof=[]
        _tmp=name.readX(0)
        for j in range(len(_tmp)-1):
            tof.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        p1=self.neonpathDetSet+"/tof"
        p2=self.neonpathDetSet+"/counts"

        _json_x=jsonArray.jsonEncoder(tof)
        _json_y=jsonArray.jsonEncoder(counts)

        self.neonRedis_write.set(p1, _json_x)
        self.neonRedis_write.set(p2, _json_y)
        print "set diffraction pattern successfully!", self.group," ", datetime.datetime.now()

    def process(self):
        self.getDataFromNeon()
        while (len(self.detValue)!=(len(self.detTof)-1)*len(self.detPid)):
            print "data size doesn't match! please waiting..."
            time.sleep(10)
            self.getDataFromNeon()

        self.createWorkspace()
        self.setTofCounts() 
    
    def run(self):
        while True:
            self.process()
            time.sleep(self.refreshtime)
    
