#!/usr/bin/python
import sys
import time
import threading
import subprocess
import logging
from logging.handlers import RotatingFileHandler
import os
import shlex
import connect
import json

logger = logging.getLogger('GPPDmantid')
hdlr = RotatingFileHandler(os.getcwd() + '/GPPDmantid.log', maxBytes=1, backupCount=0)
formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
hdlr.setFormatter(formatter)
logger.addHandler(hdlr)
logger.setLevel(logging.DEBUG)


class main(threading.Thread):   
    def __init__(self,  myRedis, mypid):
        threading.Thread.__init__(self)
        self.moduleList=['GPPD_module123','GPPD_module131','GPPD_module132','GPPD_module133','GPPD_module141','GPPD_module142','GPPD_module143','GPPD_module221','GPPD_module231','GPPD_module232','GPPD_module233','GPPD_module241','GPPD_module242','GPPD_module243','GPPD_module322','GPPD_module331','GPPD_module332','GPPD_module333','GPPD_module341','GPPD_module342','GPPD_module343','GPPD_module422','GPPD_module431','GPPD_module432','GPPD_module433','GPPD_module441','GPPD_module442','GPPD_module443','GPPD_module521','GPPD_module531','GPPD_module532','GPPD_module533','GPPD_module541','GPPD_module542','GPPD_module543','GPPD_module623','GPPD_module631','GPPD_module632','GPPD_module633','GPPD_module641','GPPD_module642','GPPD_module643','GPPD_monitor','GPPD_pattern']

        self.neonRedis = myRedis
        self.mypid = mypid
    

    def setHB(self):
        path = "/GPPD/heartbeat/mantid/control"
        data={}
        data['timestamp']=time.strftime('%Y-%m-%dT%H:%M:%S.%03d+08:00')
        data['pid']=self.mypid
        self.neonRedis.set(path, json.dumps(data))        

    def process(self):
        for _tmp in self.moduleList:
            try:
                _cmd = "ps -C " + _tmp + ".py -o pid="
                pid = subprocess.check_output(_cmd, shell=True)
                pid = shlex.split(pid)
            except:
                pid=[]

            #print pid
            
            if len(pid)==0:
                #start m
                
                #_cmd='rm -rf ./log/'+_tmp+'.log'
                #subprocess.Popen(_cmd, shell=True)
                logger.error(_tmp+": restart")
                _cmd='./'+_tmp+'.py &'
                subprocess.Popen(_cmd, shell=True)
            elif len(pid)==1:
                pass
            else:
                logger.error(_tmp+": multiple process")
                _cmd='pkill -9 '+_tmp
                subprocess.Popen(_cmd, shell=True)
                _cmd='./'+_tmp+'.py &'
                subprocess.Popen(_cmd, shell=True)
    
    def run(self):
        while True:
            self.process()
            self.setHB()
            time.sleep(10)

if __name__=="__main__":
    ip_port =  [('10.1.33.141', 9001), ('10.1.33.141',9001)]
    passwd = 'sanlie;123'

    r= connect.connectNeon(ip_port, passwd, 10)
    r_write = r.getRedisWrite()

    mypid=str(os.getpid())

    threadDaemon = main(r_write,mypid)
    threadDaemon.setDaemon(True)
    threadDaemon.start()
    threadDaemon.join()
    sys.exit()

