#!/usr/bin/python3
import connect
import moduleIO
import threading
from redis.sentinel import Sentinel
import os
import heartBeat
import subprocess
#import shlex
import sys

def run_this():
    mypid=str(os.getpid())
    myname=os.path.basename(__file__)
    _cmd="ps -C "+myname+" -o pid="
    pid=subprocess.check_output(_cmd, shell=True)
    pid=shlex.split(pid)
    print (pid, mypid)
    for p in pid:
        if p != mypid:
            try:
                _cmd="/usr/bin/kill -9 "+str(p)
                #_cmd = shlex.split(_cmd)
                subprocess.check_call(_cmd, shell=True)
                print ("process  killed", p)
                #logger.warning("Self process killed")
            except:
                print ("process not killed", p)
                #logger.warning("Self process not killed")
        else:
            pass
    return mypid

class myLog():
    def __init__(self, name):
        import logging
        from logging.handlers import RotatingFileHandler
        logging.basicConfig(level=logging.WARNING,
                format='%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s',
                datefmt='%a, %d %b %Y %H:%M:%S',
                #filename='myMantid_'+name+'.log',
                filename=os.getcwd()+'/log/'+name+'.log',
                filemode='a')

        self.logger = logging.getLogger('GPPD_module')
        #hdlr = logging.FileHandler(os.getcwd()+'/RMmantid.log', maxBytes=100, backupCount=5)
        hdlr = RotatingFileHandler(os.getcwd()+'/log/'+name+'.log', maxBytes=100, backupCount=0)
        #hdlr = RotatingFileHandler(os.getcwd()+'/myMantid_'+name+'.log', maxBytes=10*1024*1024, backupCount=0)
        #formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
        #hdlr.setFormatter(formatter)
        #self.logger.addHandler(hdlr)
        #self.logger.setLevel(logging.DEBUG)

    def getLog(self):
        return self.logger

if __name__ == '__main__':
    name = 'module231'

    #=======set logger file===========
    _log=myLog(name)
    logger= _log.getLog()
    #mypid=run_this()
    mypid=str(os.getpid())

    # ======Try to connect NEON server
    ip_port = [('10.1.33.141', 9001)]
    #ip_port = [('10.1.53.240', 9001)]
    passwd = 'sanlie;123'
    redisW=connect.connectNeon(ip_port, passwd, 1.0)
    r=redisW.getRedisRead()
    #sys.exit()
   
    
    #=======set heartBeat thread=============== 
    myThread1=(heartBeat.neonHeartBeat(r, 1.0, name, mypid))
    #=======set data process thread=========
    myThread2=(moduleIO.moduleIO(myThread1, r, 1, name, logger))
    myThread2.setDaemon(True)
    myThread1.start()
    myThread2.start()
    myThread1.join()
    myThread2.join()
