from mantid.simpleapi import *
import jsonArray
import threading
import neonIO
import time
#from Queue import Queue
import sys
#import numpy as np
import threading
from xml.etree import ElementTree

def getconf(path):
    confxml=ElementTree.parse(path)
    root=confxml.getroot()
    det=confxml.findall("type")
    mName=[]
    for comp in det:
        bNode=comp.getiterator("component")
        bName=comp.attrib["name"]
        if bName=="Monitor":
            pass
        else:
            for mm in bNode:
                mName.append(mm.attrib["name"])
    return mName

class getCommand(threading.Thread):
    def __init__(self, neonRedis, refreshtime, myDict, status):
        super(getCommand, self).__init__()
        self.myDict=myDict
        self.neonRedis = neonRedis
        self.refreshtime = refreshtime
        self.command = ''
        self.call = True
        self.status=status
    def getCommand(self):
        _path="/GPPD/stateMachine/command"
        _json=self.neonRedis.get(_path)
        return _json

    def setCommand(self, command):
        self.command=command

    def setStatus(self):
        path="/GPPD/stateMachine/Mantid/status"
        self.neonRedis.set(path, self.status)

    def process(self):
        while True:
            _be=time.time()
            _command=self.getCommand()
            if self.command==_command:
                self.call = False
            else:
                self.setCommand(_command)
                print "new command: ", self.command
                self.status, self.myDict=stateMachine(self.neonRedis, self.status, self.command, self.myDict)
                self.setStatus()
            time.sleep(self.refreshtime)

    def run(self):
        self.process()

def stateMachine(neonRedis, status, command, myDict):
    global myPro
    if status == 'waiting':
        print 'waiting status cannot reveive any command'
        status='unconfigured'

    if command == 'configure':
        if status == 'unconfigured':
            status = 'configuring'
            print "status change to configuring"
            moduleList=getconf('./GPPD_configure.xml')
            myPro=[]
            for name in moduleList:
                myPro.append(neonIO.moduleDataGet(neonRedis, 0.1, name, myDict))
            for t in myPro:
                t.start()
                print t," start!"
            #for t in myPro:
            #    t.join()
            status = 'ready'
            print "status change to ready"
        elif status == 'configuring':
            print "configuring status cannot receive configure command"
        elif status == 'ready':
            print "ready status cannot receive configure command"
        elif status == 'running':
            print "running status cannot receive configure command"
        elif _status == 'paused':
            print "paused status cannot receive configure command"
        elif _status == 'stopped':
            print "stopped status cannot receive configure command"

    elif command == 'unconfigure':
        if status == 'unconfigured':
            print "unconfigured status cannot receive unconfigure command"
        elif status == 'configuring':
            print "configuring status cannot receive unconfigure command"
        elif status == 'ready':
            status = 'unconfigured'
            print myPro
            myDict['break']=True
            print "status change to unconfigured"
        elif status == 'running':
            print "running status cannot receive unconfigure command"
        elif status == 'paused':
            print "paused status cannot receive unconfigure command"
        elif status == 'stopped':
            print "stopped status cannot receive unconfigure command"

    elif command == 'start':
        if status == 'unconfigured':
            print "unconfigured status cannot receive start command"
        elif status == 'configuring':
            print "configuring status cannot receive start command"
        elif status == 'ready':
            print "begin to run!!!"
            myDict['running']=True
            myDict['start']=True
            status = 'running'
            print "status change to running"
        elif status == 'running':
            print "running status cannot receive start command"
        elif status == 'paused':
            print "paused status cannot receive start command"
        elif status == 'stopped':
            print "stopped status cannot receive start command"

    elif command == 'pause':
        if status == 'unconfigured':
            print "unconfigured status cannot receive pause command"
        elif status == 'configuring':
            print "configuring status cannot receive pause command"
        elif status == 'ready':
            print "ready status cannot receive pause command"
        elif status == 'running':
            myDict['running']=False
            status = 'paused'
            print "status change to paused"
        elif status == 'paused':
            print "paused status cannot receive pause command"
        elif status == 'stopped':
            print "stopped status cannot receive pause command"

    elif command == 'resume':
        if status == 'unconfigured':
            print "unconfigured status cannot receive resume command"
        elif status == 'configuring':
            print "configuring status cannot receive resume command"
        elif status == 'ready':
            print "ready status cannot receive resume command"
        elif status == 'running':
            print "running status cannot receive resume command"
        elif status == 'paused':
            myDict['running']=True
            status = 'running'
            print "status change to runninig"
        elif status == 'stopped':
            print "stopped status cannot receive resume command"

    elif command == 'stop':
        if status == 'unconfigured':
            print "unconfigured status cannot receive stop command"
        elif status == 'configuring':
            print "configuring status cannot receive stop command"
        elif status == 'ready':
            print "ready status cannot receive stop command"
        elif status == 'running':
            myDict['running']=False
            myDict['start']=False
            status = 'ready'
            print "status change to stopped"
        elif status == 'paused':
            print "paused status cannot receive stop command"
        elif status == 'stopped':
            print "stopped status cannot receive stop command"

    elif command == 'abort':
        if status == 'unconfigured':
            print "unconfigured status cannot receive stop command"
        elif status == 'configuring':
            myDict['conf']=False
            myDict['start']=False
            status = 'unconfigured'
            print "status change to unconfigured"
        elif status == 'ready':
            print "ready status cannot receive stop command"
        elif status == 'running':
            myDict['running']=False
            myDict['start']=False
            status = 'ready'
            print "status change to abort"
        elif status == 'paused':
            print "paused status cannot receive abort command"
        elif status == 'stopped':
            print "stopped status cannot receive abort command"

    print "status: ", status
    return  status, myDict

