from mantid.simpleapi import *
import time
import jsonArray
import numpy as np
import redis
import sys
#import matplotlib.pyplot as plt

def setZero(neonRedis,neonpath):
    v=''
    #set pid_image
    path=neonpath+"/pid_image/x"
    neonRedis.set(path,v)
    path=neonpath+"/pid_image/value"
    neonRedis.set(path,v)
    #set xy bank
    path=neonpath+"/xy_image/x"     
    neonRedis.set(path,v)
    path=neonpath+"/xy_image/y"     
    neonRedis.set(path,v)
    path=neonpath+"/xy_image/value"     
    neonRedis.set(path,v)
    print "ready to restart!" 

def setPidCountsData(neonRedis, module, neonpathDetSet):
    be=time.time()
    be=time.time()
    pid=[]
    counts=[]
    #get pid-tof data
    rawname=str(module+'_1')
    name1=mtd[rawname]
    SumSpectra(InputWorkspace=rawname, OutputWorkspace="ans", IncludeMonitors=False)
    numHist=name1.getNumberHistograms()
    for j in range(numHist):
        pid.append(j)
        n2=sum(name1.readY(j))
        counts.append(n2)
    #print "pid: ",np.array(pid)
    #print "counts: ", np.array(counts)
    #print counts
    #print np.array(pid).shape, np.array(counts).shape
    _json_x=jsonArray.jsonEncoder(pid)
    _json_y=jsonArray.jsonEncoder(counts)
    _p1=neonpathDetSet+"/pid_image/x"
    _p2=neonpathDetSet+"/pid_image/value"
    #print _p1, _p2
    neonRedis.set(_p1, _json_x)
    neonRedis.set(_p2, _json_y)
    #print "finish set pid-counts bank data! ",time.time()-be

def setXYBankData(neonRedis, module, neonpathDetSet):
    be=time.time()
    rawname=module+'_1'
    name1=mtd[rawname]
    numHist=name1.getNumberHistograms()
    _tmpv=[]
    xaxis=[]
    yaxis=[]
    zaxis=[]
    for j in range(numHist):
        _det=name1.getDetector(j)
        _pos=_det.getPos()
        _n2=sum(name1.readY(j))
        xaxis.append(_pos.X())
        yaxis.append(_pos.Y())
        zaxis.append(_pos.Z())
        _tmpv.append(_n2)
    xaxis=list(set(xaxis))
    yaxis=list(set(yaxis))
    zaxis=list(set(zaxis))
    xaxis.sort()
    yaxis.sort()
    zaxis.sort()
    #print "get position"
    #print len(xaxis), len(yaxis), len(zaxis),len(_tmpv)
    mNum=int(module[6])
    #print "module first num: ", mNum
    if mNum==3 or mNum==4:
        num=0
        vaxis=[[] for r in range(len(yaxis))]
        for p in range(len(yaxis)):
            for q in range(len(zaxis)):
                vaxis[p].append(_tmpv[num])
                num=num+1
        #print np.array(zaxis).shape, np.array(yaxis).shape, np.array(vaxis).shape
        #print np.array(xaxis)
        #print np.array(yaxis)
        #print np.array(vaxis)
        #print vaxis
        #print vaxis
        _json_y=jsonArray.jsonEncoder(yaxis)
        _json_z=jsonArray.jsonEncoder(zaxis)
        _json_v=jsonArray.jsonEncoder(vaxis)
        _p2=neonpathDetSet+"/xy_image/y"
        _p3=neonpathDetSet+"/xy_image/x"
        _p4=neonpathDetSet+"/xy_image/value"
        #print _p2, _p3, _p4
        #print type(_json_y)
        neonRedis.set(_p2, _json_y)
        neonRedis.set(_p3, _json_z)
        neonRedis.set(_p4, _json_v)
    else:
        num=0
        vaxis=[[] for r in range(len(yaxis))]
        for p in range(len(yaxis)):
            for q in range(len(xaxis)):
                vaxis[p].append(_tmpv[num])
                num=num+1
        #print np.array(xaxis).shape, np.array(yaxis).shape, np.array(vaxis).shape
        #print np.array(xaxis)
        #print np.array(yaxis)
        #print np.array(vaxis)
        _json_x=jsonArray.jsonEncoder(xaxis)
        _json_y=jsonArray.jsonEncoder(yaxis)
        _json_v=jsonArray.jsonEncoder(vaxis)
        _p1=neonpathDetSet+"/xy_image/x"
        _p2=neonpathDetSet+"/xy_image/y"
        _p4=neonpathDetSet+"/xy_image/value"
        #print _p1, _p2, _p4
        neonRedis.set(_p1, _json_x)
        neonRedis.set(_p2, _json_y)
        neonRedis.set(_p4, _json_v)
 
    #print "set x,y value for all bank! ",time.time()-be

def setMonTofCounts(neonRedis, monitor):
    rawname=monitor+"_tofCounts"
    name=mtd[rawname]
    counts=name.readY(0)
    tof=[]
    _tmp=name.readX(0)
    for j in range(len(_tmp)-1):
        tof.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
    #print np.array(tof)
    #print np.array(counts)
    _p1="/GPPD/workspace/MantidData/"+monitor+"/tof"
    _p2="/GPPD/workspace/MantidData/"+monitor+"/counts"
    _json_x=jsonArray.jsonEncoder(tof)
    _json_y=jsonArray.jsonEncoder(counts)
    #print _p1, _p2
    neonRedis.set(_p1, _json_x)
    neonRedis.set(_p2, _json_y)

def setXYMonitor(neonRedis, monitor):
    xaxis=[]
    yaxis=[]
    vtmp=[]
    rawName=monitor+"_2"   
    name=mtd[rawName]
    numHist=name.getNumberHistograms()
    #print "hist of monitor: ", numHist
    for i in range(numHist):
        det=name.getDetector(i)
        pos=det.getRelativePos()
        n2=sum(name.readY(i))
        xaxis.append(pos.X())
        yaxis.append(pos.Y())
        vtmp.append(n2)
    xtmp=list(set(xaxis))
    ytmp=list(set(yaxis))
    xtmp.sort()
    ytmp.sort()
    #print len(xtmp), len(ytmp), len(vtmp)
    vaxis=[[] for m in range(len(ytmp))]
    n=0
    for j in range(len(ytmp)):
        for k in range(len(xtmp)):
            vaxis[j].append(vtmp[n])
            n=n+1
    #print np.array(xtmp)        
    #print np.array(ytmp)        
    #print np.array(vaxis)        
    _p1="/GPPD/workspace/MantidData/"+monitor+"/axis_x"
    _p2="/GPPD/workspace/MantidData/"+monitor+"/axis_y"
    _p3="/GPPD/workspace/MantidData/"+monitor+"/value"
    #print _p1, _p2, _p3
    _json_x=jsonArray.jsonEncoder(xtmp)
    _json_y=jsonArray.jsonEncoder(ytmp)
    _json_v=jsonArray.jsonEncoder(vaxis)
    neonRedis.set(_p1, _json_x)
    neonRedis.set(_p2, _json_y)
    neonRedis.set(_p3, _json_v)

    
