from mantid.simpleapi import *
import jsonArray
import threading
from Queue import Queue
import time
import matplotlib
import numpy as np
from canvas import *
import redis
import sys
import datetime
import cStringIO

class dataGet(threading.Thread):

    def __init__(self, threadID, neonRedis, refreshtime, bankList, monitorList):
        threading.Thread.__init__(self)
        self.paused = False
        self.pause_cond = threading.Condition(threading.Lock())
        self.thread_stop = False

        self.refreshtime=refreshtime
        self.neonRedis=neonRedis

        self.bankList=bankList
        self.monitorList=monitorList

        self.nbank=len(self.bankList)
        self.nmonitor=len(self.monitorList)
        print self.nbank, self.nmonitor
        #set path of data
        self.neonpathDetPid=[[] for i in range(self.nbank)]
        self.neonpathDetTof=[[] for i in range(self.nbank)]
        self.neonpathDetValue=[[] for i in range(self.nbank)]
        self.neonpathMonPid=[[] for i in range(self.nmonitor)]
        self.neonpathMonTof=[[] for i in range(self.nmonitor)]
        self.neonpathMonValue=[[] for i in range(self.nmonitor)]

        self.detWorkspace=[]
        self.monWorkspace=[]
        self.modulenum_bank=[]
        self.modulenum_mon=[]
        det=bankList.keys()
        for m in range(self.nbank):
            self.detWorkspace.append(det[m])
        
        for i in range(len(self.detWorkspace)):
            _moduleList=bankList[self.detWorkspace[i]]
            self.modulenum_bank.append(len(_moduleList))
            for j in _moduleList:
                self.neonpathDetPid[i].append("/GPPD/workspace/data/module"+str(j).zfill(2)+"/pid")
                self.neonpathDetTof[i].append("/GPPD/workspace/data/module"+str(j).zfill(2)+"/tof")
                self.neonpathDetValue[i].append("/GPPD/workspace/data/module"+str(j).zfill(2)+"/value")

        mon=monitorList.keys()
        for n in range(self.nmonitor):
            self.monWorkspace.append(mon[n])

        for i in range(len(self.monWorkspace)):
            _moduleList=monitorList[self.monWorkspace[i]]
            self.modulenum_mon.append(len(_moduleList))
            for j in _moduleList:
                self.neonpathMonPid[i].append("/GPPD/workspace/data/monitor"+str(j).zfill(2)+"/pid")
                self.neonpathMonTof[i].append("/GPPD/workspace/data/monitor"+str(j).zfill(2)+"/tof")
                self.neonpathMonValue[i].append("/GPPD/workspace/data/monitor"+str(j).zfill(2)+"/value")

        # neonPath
        self.neonpathDetImg=[]
        for i in range(len(self.detWorkspace)):
            self.neonpathDetImg.append("/GPPD/workspace/data/bank"+str(i).zfill(2)+"/pid_image")
        
        self.neonpathMonImg=[]
        for i in range(len(self.monWorkspace)):
            self.neonpathMonImg.append("/GPPD/workspace/data/monitor"+str(i).zfill(2)+"/pid_image")

        self.detPid = self.getPid(bankList, self.neonpathDetPid)
        print "success in get det pid data"
        print type(self.detPid)
        print type(self.detPid[0][1])
        self.detTof = self.getTof(bankList, self.neonpathDetTof)
        print "success in get det tof data"
        print type(self.detTof[0][1])

        self.monPid = self.getPid(monitorList, self.neonpathMonPid)
        print "success in get mon pid data"
        self.monTof = self.getTof(monitorList, self.neonpathMonTof)
        print "success in get mon tof data"

        self.createCanvas()

    def getCanvas(self):
        return self.canvas

    def createCanvas(self):   
        self.canvas = CSNSCanvas(
            6,
            4,
            150,
            'Dus',
            'SpecNo ',
            'TOF / us',
            )

    def getPid(self, bank, path):
    # usage: self.getPid(self.bankList, self.neonpathDetPid)
    # usage: self.getPid(self.monitorList, self.neonpathMoPid)
        nbank=len(bank)
        pid=[[] for k in range(nbank)]
        for i in range(nbank):
            for _path in path[i]:
                while True:
                    _json=self.neonRedis.get(_path)
                    if _json is None:
                        print "Warning: No pid data!!!"
                    else:
                        _array=jsonArray.jsonDecoder(_json)
                        if _array is None:
                            print "Warning: Incompleted pid data!!!"
                        else:
                            #print len(_array)
                            for k in _array:
                                pid[i].append(k)
                            break

            print "the pixel number in  bankpid[i] is: "+str(len(pid[i]))        
        if (i!=nbank-1):
            print "error: iteration number is: "+str(i)

        #for i in range(nbank):
            #pid[i]=np.array(pid[i])
        #print pid
        return pid

    def getTof(self, bank, path):
        nbank=len(bank)
        tof=[[] for k in range(nbank)]
        for i in range(nbank):
            for _path in path[i]:
                _json=self.neonRedis.get(_path)
                if _json is None:
                    print "Error: No tof data!!!"
                else:
                    _array=jsonArray.jsonDecoder(_json)
                    if (len(_array)< 4377):
                        print "error: tof unfinished!"
                    for k in _array:
                        tof[i].append(k)
                    break
            #print len(tof[i])
        if (i!=nbank-1):
            print "error: iteration number is: "+str(i)
        #for i in range(nbank):
            #tof[i]=np.array(tof[i])
        #print tof
        return tof

    def getValue(self, bank, path, modulenum):
        be=time.time()
        nbank=len(bank)
        value=[[] for k in range(nbank)]
        _tmp=[]
        st=0
        for i in range(nbank):
            #mvalue=[[] for j in range(modulenum[i])]
            #print "the length of mvalue is "+str(len(mvalue))
            for _path in path[i]:
                _json=self.neonRedis.get(_path)
                _array=jsonArray.jsonDecoder(_json)
                for ix in range(len(_array)):
                    #specNo=144+ix
                    for iy in range(len(_array[ix])):
                        value[i].append(_array[ix,iy])
                        #detws[[i][specNo][iy]]=_array[ix][iy]

        #for i in nbank:
        #loadCSNSraw(detWorksapce[i], detws[i])

            #print len(_tmp)
                #value[i].extend(_tmp)
            #print value[i]
        print len(value)
        print (time.time()-be)
        return value               


    def getDataFromNeon(self):

        self.detValue=self.getValue(self.bankList, self.neonpathDetValue, 4)
        self.monValue=self.getValue(self.monitorList, self.neonpathMonValue, 4)
        
    def createWorkspace(self):
        _monpid=self.monPid[0]
        _montof=self.monTof[0]
        _monv=self.monValue[0]
        for i in range(len(self.bankList)):
            _bankpid=self.detPid[i]
            _banktof=self.detTof[i]
            _bankv=self.detValue[i]
        
         
            _n1=[]
            _n2=[]
            _n3=[]
            _n4=[]
            _n5=[]
            _n6=[]

            for j in range(len(_bankpid)):
                _n1.append(int(_bankpid[j]))
            for j in range(len(_banktof)):
                _n2.append(int(_banktof[j]))
            for j in range(len(_bankv)):
                _n3.append(int(_bankv[j]))
            for j in range(len(_monpid)):
                _n4.append(int(_monpid[j]))
            for j in range(len(_montof)):
                _n5.append(int(_montof[j]))
            for j in range(len(_monv)):
                _n6.append(int(_monv[j]))
            _n0=self.detWorkspace[i]            

            LoadCSNSRaw(OutputWorkspace=_n0, PixelID_bank=_n1, TimeOfFlight_bank=_n2, Counts_bank=_n3, PixelID_monitor=_n4, TimeOfFlight_monitor=_n5, Counts_monitor=_n6)
            print "   INFO: Mantid Workspace updated. "        
            
    def reduceData(self):
        wsName=[]
        for j in range(len(self.detWorkspace)):
            wsName.append(self.detWorkspace[j])
        for i in range(len(self.detWorkspace)):

            _bname=str(wsName[i]+"_1")
            print _bname           

            LoadInstrument(Workspace=_bname, Filename='instrument/GPPD//GPPD_IDF_bank.xml', RewriteSpectraMap='True')
            LoadCalFile(InputWorkspace=_bname, CalFilename='instrument/GPPD/GPPD_calfile.cal', WorkspaceName='GPPDraw')
            MaskDetectors(Workspace=_bname, MaskedWorkspace='GPPDraw_mask')
            AlignDetectors(InputWorkspace=_bname, OutputWorkspace=_bname+'test_alignD', OffsetsWorkspace='GPPDraw_offsets')
            Rebin(InputWorkspace=_bname+'test_alignD', OutputWorkspace=_bname+'test_rebin', Params='0.1,0.005,2.5')
            DiffractionFocussing(InputWorkspace=_bname+'test_rebin', OutputWorkspace=_bname+'test_dfocus', GroupingWorkspace='GPPDraw_group')
            ConvertUnits(InputWorkspace=_bname+'test_dfocus', OutputWorkspace=_bname+'test_wave', Target='Wavelength')
            Rebin(InputWorkspace=_bname+'test_wave', OutputWorkspace=_bname+'test_wave_rebin', Params='0.85,0.005,4.25')
            ConvertUnits(InputWorkspace=_bname+'test_dfocus', OutputWorkspace=_bname+'test_dfocus_tof', Target='TOF')

            print " INFO: Data Reduction Finished!"

    def getPidTofFigure(self):
        #set path
        neonpath=[]
        for n in range(len(self.detWorkspace)):
            neonpath.append("GPPD/workspace/data/"+str(self.detWorkspace[n])+"/pid_image")

        for i in range(len(self.detWorkspace)):
            #get pid-tof data
            rawname=str(self.detWorkspace[0]+'_1')
            name1=mtd[rawname]
            numHist=name1.getNumberHistograms()
            # get tof
            tof=name1.readX(0)
            ntof=len(tof)-1
            print "tof:", ntof 
            #get pid
            pid=[]
            for k in range(numHist):
                pid.append(k)
            #set 2D array
            x=np.zeros((numHist,ntof))
            y=np.zeros((numHist,ntof))
            z=np.zeros((numHist,ntof))
            for j in range(numHist):
                z[j][:]=name1.readY(j)
            for j in range(numHist):
                for k in range(ntof):
                    x[j][k]=pid[j]
                    y[j][k]=tof[k]

            return x,y,z
            
    def dataSet(self):
        x,y,z=self.getPidTofFigure()
        
        self.canvas.ax.pcolormesh(x,y,z)
        self.canvas.draw()
        for _p in self.neonpathDetImg:
            self.setImgFromCanvasIO(_p, self.canvas)
        #for _p in self.neonpathMonImg:
        #    self.setImgFromCanvasIO(self.neonRedis, _p, self.canvas)

    def process(self):
        _be=time.time()
        print "   INFO: getDataFromNeon", datetime.datetime.now()
        self.getDataFromNeon()
        print "   INFO: createWorkspace", datetime.datetime.now()
        self.createWorkspace()
        print "   INFO: reduceData", datetime.datetime.now()
        self.reduceData()
        print "   INFO: dataSet", datetime.datetime.now()
        self.dataSet()
        print "===================================="
        print time.time()-_be, "seconds"
        print "===================================="
    def run(self):
        while True:
            self.process()
            time.sleep(self.refreshtime)

    def setImgFromFile(self, neonpath,imgFile):
        _str = open(imgFile, "rb").read()
        self.neonRedis.set(neonpath, _str)
    
    def setImgFromCanvasFile(self, neonpath, canvas):
        canvas.fig.savefig('img/pid_send.png', format='png')
        _str = open('img/pid_send.png', "rb").read()
        self.neonRedis.set(neonpath, _str)

    def setImgFromCanvasIO(self, neonpath, canvas):
        _strio=cStringIO.StringIO()
        canvas.fig.savefig(_strio, format='png')
        _strio.seek(0)
        _strio=cStringIO.StringIO(_strio.read())

        self.neonRedis.set(neonpath, _strio.getvalue())
        _strio.close()

    def getImgFromNeon(self, neonpath):
        _img=self.neonRedis.get(neonpath)
        _img=cStringIO.StringIO(_img)
        Image.open(_img).save('img/pid_receive.png')

    def pause(self):
        #self.paused = True
        #self.pause_cond.acquire()
        self.can_run.set()
        with self.arrayZ.mutex:
            self.arrayZ.queue.clear()
            self.valueC.queue.clear()

    def resume(self):
        #self.paused = False
        #self.pause_cond.notify()
        #self.pause_cond.release()
        self.can_run.clear()

    def stop(self):
        self.paused = True
        self.pause_cond.acquire()
        self.can_run.set()

class connectNeon():

    def __init__(
        self,
        ip,
        port,
        timeout,
        ):

        self.status=False
        client=None
        self.server=None
        begin=time.time()

        while True:
            if not client:
                self.server = redis.Redis(host=ip, port=port, db=0)
                self.status=True
                print "   INFO: NEON Started"
                break
            else:
                if time.time()-begin>timeout:
                    print "   ERROR: Connect NEON timeout"  
                    sys.exit()
                    #break
                try:
                    print "   INFO: Attempt to connect NEON"  
                    client=redis.client_list()
                except:
                    pass

    def getServer(self):
        return self.server

