from mantid.simpleapi import *
import jsonArray
import time
import datetime
import json
#import multiprocessing
#from multiprocessing import Process, Manager
import shutil
import path
import threading
import numpy as np

#class monitorIO(multiprocessing.Process):
class monitorIO(threading.Thread):
    def __init__(self,hb, neonRedis, refreshtime, monitorList,delay, logger):
        super(monitorIO, self).__init__()

        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis
        self.neonRedis_read=neonRedis
        self.monitorList=monitorList
        self.logger=logger
        self.hb = hb
        self.status = 1
        #self.myDict=myDict
        self.delay=int(delay)
        #self.confJudge=True
        self.command=-1
        self.commandPath="/GPPD/control/command/mantid"
        self.commandList=['configure','unconfigure','start','pause','resume','stop','abort']
        self.statusList=['waiting','unconfigured','configuring','ready','running','paused','error']
        self.running=False
        self.hasAxis=False
        self.monPid=[]
        self.monTof=[]
        self.monValue=[[] for i in range(len(self.monitorList))]

        self.neonpathValue=[]
        self.neonpathPid=[]
        self.neonpathTof=[]
        self.ncPath=[]
        for name in self.monitorList:
            self.ncPath.append("/GPPD/workspace/MantidData/"+name+"/neutroncounts")
            self.neonpathValue.append("/GPPD/workspace/"+name+"/value")
            self.neonpathPid.append("/GPPD/workspace/"+name+"/pid")
            self.neonpathTof.append("/GPPD/workspace/"+name+"/tof")

        l1=28.267
        l2=28.347
        l3=31.227

        #print len(self.monPid), len(self.monTof)
        #print self.monPid
        #self.setHB()

    def getCommand(self):
        #_path="/GPPD/control/command/mantid"
        try:
            _json=self.neonRedis_read.get(self.commandPath)
            _data=int(json.loads(_json))
        except:
            _data=-1
        return _data

    def setCommand(self, command):
        self.command=command

    def setStatus(self, num):
        self.hb.setStatus(num)

    def stateMachine(self, command, status):
        if command == 0:
            if status == 1:
                status = 3
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 1:
            if status == 3:
                status = 1
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 2:
            if status == 3:
                self.running=True
                status = 4
            elif status == 1:
                status = 3
                #self.clearData()
                self.running=True
                status = 4

            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 3:
            if status == 4:
                self.running=False
                status = 5
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 4:
            if status == 5:
                self.running=True
                status = 4
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 5:
            if status == 4:
                self.running=False
                status = 3
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 6:
            self.running=False
            status = 1
        else:
            pass

        return status
    
    def processCommand(self):
        _command=self.getCommand()
        if self.command==_command:
            pass
        else:
            self.setCommand(_command)
            self.logger.debug("new command: "+str(self.command))
            self.logger.debug("before statemachine: "+str(self.status))
            self.status=self.stateMachine(self.command, self.status)
            self.setStatus(self.status)
            self.logger.debug("after statemachine: "+str(self.status))


    def get1Ddata(self, path):
        _json=self.neonRedis_read.get(path)
        data=jsonArray.jsonDecoder(_json)
        return data

    def get2Ddata(self,i):
        _result=False
        #try:
        _json=self.neonRedis_read.get(self.neonpathValue[i])
        data=jsonArray.jsonDecoder(_json)
        value = [item for sublist in data for item in sublist]
        self.neonRedis_write.set(self.ncPath[i], json.dumps(sum(value)))
        _result=True
        #except:
        #    _result=False
        #    self.logger.warning("no value data for monitor "+str(datetime.datetime.now()))
        print len(value)
        return value

    def createWorkspace(self,num, value):
        _result=False
        #for i in range(3):
        name=self.monitorList[num]
        LoadCSNSRaw(OutputWorkspace=name, PixelID_bank=[0,1], TimeOfFlight_bank=[0,8], Counts_bank=[1,1], PixelID_monitor=self.monPid, TimeOfFlight_monitor=self.monTof, Counts_monitor=value)
        #SaveNexus(InputWorkspace=monitor+'_2', Filename='./'+monitor+'.nxs')
        LoadInstrument(Workspace=name+"_2", Filename='./instrument/'+name+'.xml', RewriteSpectraMap='True')
        ConvertUnits(InputWorkspace=name+'_2', OutputWorkspace='wave', Target='Wavelength', AlignBins = True)
        SumSpectra(InputWorkspace='wave', OutputWorkspace="wave", IncludeMonitors=True)
        SaveNexus(InputWorkspace='wave', Filename='./'+name+'.nxs')
        #Rebin(InputWorkspace=monitor+"_wave",OutputWorkspace=monitor+"_wave", Params='0.001,0.005,8')
        ConvertUnits(InputWorkspace='wave', OutputWorkspace='tof', Target='TOF', AlignBins = True)
        #self.waveCounts[i], self.tofCounts[i], self.XYcounts[i]=self.getDataFromWs(name)
        self.logger.debug('finish getDataFromWs ')
        #DeleteWorkspace(Workspace=name)
        #DeleteWorkspace(Workspace='wave')
        #DeleteWorkspace(Workspace='tof')
        #CleanFileCache()

        _result=True
        
        return _result    

    def clearWs(self, num):
        try:
            DeleteWorkspace(Workspace=self.monitorList[num])
            DeleteWorkspace(Workspace='wave')
            DeleteWorkspace(Workspace='tof')
            CleanFileCache()
        except:
            self.logger.warning("error in delete ws")


    def setXYData(self,monitor):
        xaxis=[]
        yaxis=[]
        value=[]
        name=mtd[monitor+"_2"]
        for j in range(name.getNumberHistograms()):
            det=name.getDetector(j)
            pos=det.getRelativePos()
            xaxis.append(pos.X()*1000)
            yaxis.append(pos.Y()*1000)
            value.append(sum(name.readY(j)))
        xaxis=list(set(xaxis))
        yaxis=list(set(yaxis))
        xaxis.sort()
        yaxis.sort()
        ny=len(yaxis)
        nx=len(xaxis)
        vaxis=np.reshape(value, (ny,nx)).tolist()
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/xy_image/x",jsonArray.jsonEncoder(xaxis))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/xy_image/y",jsonArray.jsonEncoder(yaxis))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/xy_image/value",jsonArray.jsonEncoder(vaxis))
        self.logger.debug("set xy data for "+monitor+" "+str(datetime.datetime.now()))


    def setDataFromWs(self, name):
        counts1=[]
        wsname=mtd['wave']
        counts1=wsname.readY(0)
        xwave=[]
        _tmp=wsname.readX(0)
        for j in range(len(_tmp)-1):
            xwave.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+name+"/wave", jsonArray.jsonEncoder(xwave))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+name+"/intensity", jsonArray.jsonEncoder(counts1))

        counts2=[]
        wsname=mtd['tof']
        counts2=wsname.readY(0)
        xtof=[]
        _tmp=wsname.readX(0)
        for j in range(len(_tmp)-1):
            xtof.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+name+"/tof", jsonArray.jsonEncoder(xtof))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+name+"/counts", jsonArray.jsonEncoder(counts2))

    def process(self):
        self.processCommand()
        if self.status==4:
            self.monPid=self.get1Ddata(self.neonpathPid[0])
            self.monTof=[]
            toftmp=self.get1Ddata(self.neonpathTof[0])
            for i in range(len(toftmp)):
                self.monTof.append(toftmp[i]+self.delay)
            for i in range(len(self.monitorList)):
                be=time.time()
                be2=time.time()
                self.logger.debug("start running program")
                #print type(i)
                monValue=self.get2Ddata(i)
                self.logger.debug(str(time.time()-be2)+' seconds for get data')
                be2=time.time()
                if self.status==4:
                    result1=self.createWorkspace(i, monValue)
                    self.logger.debug(str(time.time()-be2)+' seconds for create ws')
                    be2=time.time()
                    if self.status==4 and result1:
                        #try:
                        self.logger.debug("   INFO: dataSet"+str(datetime.datetime.now()))
                        self.setXYData(self.monitorList[i])
                        self.setDataFromWs(self.monitorList[i])
                        self.clearWs(i)
                        self.logger.debug(str(time.time()-be2)+' seconds for set data')
                        be2=time.time()
                        #shutil.move("./"+self.monitorList[i]+".nxs","./tmp/"+self.monitorList[i]+".nxs")
                        self.logger.debug("finish "+self.monitorList[i]+" "+str(time.time()-be)+" seconds!")
                    else:
                        pass
                else:
                    pass
        else:
            pass

    def run(self):
        while True:
            self.process()
            time.sleep(self.refreshtime)

