from mantid.simpleapi import *
import jsonArray
import time
import datetime
import json
#import multiprocessing
#from multiprocessing import Process
import numpy
import shutil
import sys
import threading
import numpy as np
import gc

class moduleIO(threading.Thread):
#class moduleIO(multiprocessing.Process):
    def __init__(self, hb, neonRedis, refreshtime, module, logger, delay):
        super(moduleIO, self).__init__()

        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis
        self.neonRedis_read=neonRedis
        self.module=module
        self.hb=hb
        self.status=1
        self.logger=logger
        self.delay=int(delay)
        self.command=-1
        self.commandList=['configure','unconfigure','start','pause','resume','stop','abort']
        self.statusList=['waiting','unconfigured','configuring','ready','running','paused','error']
        self.detPid=[]
        self.detTof=[]
        self.detValue=[]
        self.running=False
        self.hasAxis=False
        self.neonpathDetValue="/GPPD/workspace/detector/"+self.module+"/value"
        self.neonpathDetPid="/GPPD/workspace/detector/"+self.module+"/pid"
        self.neonpathDetTof="/GPPD/workspace/detector/"+self.module+"/tof"
        self.neonpathDetSet="/GPPD/workspace/MantidData/"+self.module
    
        self.commandPath="/GPPD/control/command/mantid"       
        self.instPath="./instrument/module/"+self.module+".xml"
        self.ncPath="/GPPD/workspace/MantidData/"+self.module+"/neutroncounts"

        if self.module[6]== '1' or self.module[6]=='2':
            self.lthetamin=2.861
            self.lthetamax=13.523
            self.lmin=32.0045
            self.lmax=32.132
            self.constA=1445.444
        if self.module[6]== '3' or self.module[6]=='4':
            self.lthetamin=18.4783
            self.lthetamax=26.288
            self.lmin=32.000
            self.lmax=32.157
            self.constA=9338.9
        if self.module[6]== '5' or self.module[6]=='6':
            self.lthetamin=29.1012
            self.lthetamax=31.304
            self.lmin=31.427
            self.lmax=32.226
            self.constA=14707.7
        
        tmp=(40000+self.delay)/505.4/self.lthetamin
        dmax=round(tmp,2)
        tmp=(self.delay+16)/505.4/self.lthetamax
        dmin=round(tmp,2)
        tmp=(dmax-dmin)/1000.0
        rbin=round(tmp,8)
        self.d_rebin=str(dmin)+','+str(rbin)+','+str(dmax)
        
        #self.detValue=np.zeros([len(self.detPid),len(self.detTof)-1])

    def getCommand(self):
        try:
            _json=self.neonRedis_read.get(self.commandPath)
            _data=int(json.loads(_json))
        except:
            _data=-1
        return _data

    def setCommand(self, command):
        self.command=command

    def stateMachine(self, command, status):
        if command == 0:
            if status == 1:
                status = 3
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 1:
            if status == 3:
                status = 1
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 2:
            if status == 3:
                #self.clearData()
                self.running=True
                status = 4
            elif status == 1:
                status = 3
                #self.clearData()
                self.running=True
                status = 4
                
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 3:
            if status == 4:
                self.running=False
                status = 5
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 4:
            if status == 5:
                self.running=True
                status = 4
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"
    
        elif command == 5:
            if status == 4:
                self.running=False
                status = 3
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 6:
            self.running=False
            status = 1
        else:
            pass
        return status

    def setStatus(self,num):
        self.hb.setStatus(num)

    def processCommand(self):
        _command=self.getCommand()
        if self.command==_command:
            pass
        else:
            self.setCommand(_command)
            self.logger.debug("new command: "+str(self.command))
            self.logger.debug("before statemachine: "+str(self.status))
            self.status=self.stateMachine(self.command, self.status)
            self.setStatus(self.status)
            self.logger.debug("after statemachine: "+str(self.status))

 
    def get1Ddata(self, path):
        _json=self.neonRedis_read.get(path)
        data=jsonArray.jsonDecoder(_json)
        return data

    def get2Ddata(self):
        _result=False
        #self.detValue=[]
        try:
            _json=self.neonRedis_read.get(self.neonpathDetValue)
            data=jsonArray.jsonDecoder(_json)
            detValue = [item for sublist in data for item in sublist]
            self.neonRedis_write.set(self.ncPath, json.dumps(sum(detValue)))
            _result=True
        except:
            _result=False
            self.logger.warning("no value data for  "+self.module+" "+str(datetime.datetime.now()))

        return detValue

    def createWorkspace(self, detValue):
        _result=False
        #try:
        #CreateWorkspace(OutputWorkspace='tmp', DataX=self.detTof, DataY=detValue, NSpec=5328, UnitX='TOF', VerticalAxisUnit='SpectraNumber')
        LoadCSNSRaw(OutputWorkspace=self.module, PixelID_bank=self.detPid, TimeOfFlight_bank=self.detTof, Counts_bank=detValue, PixelID_monitor=[0,1], TimeOfFlight_monitor=[0,16], Counts_monitor=[1,1])
        #LoadCSNSNexus(Filename='/home/dur/RUN0000336/detector.nxs', OutputWorkspace='tmp', Bankname='bank3',Loadmonitor=False)

        #LoadNexus(Filename='/home/dur/RUN0000411/bank3.nxs',OutputWorkspace='tmp')
        self.logger.debug('finish LoadCSNSRaw ')
        LoadInstrument(Workspace=self.module+"_1", Filename=self.instPath, RewriteSpectraMap='True')    
        #'''
        self.logger.debug('finish LoadInstrument ')
        SaveNexus(InputWorkspace=self.module+'_1', Filename='./'+self.module+'.nxs')
        self.logger.debug('finish SaveNexus ')
        ConvertUnits(InputWorkspace=self.module+'_1', OutputWorkspace=self.module+'_dfocus', Target='dSpacing', EMode='Elastic', AlignBins = True)
        self.logger.debug('finish convertUnits ')
        SumSpectra(InputWorkspace=self.module+'_dfocus', OutputWorkspace=self.module+'_dfocus')
        self.logger.debug('finish sumSpectra ')
        Rebin(InputWorkspace=self.module+'_dfocus', OutputWorkspace=self.module+'_dfocus', Params=self.d_rebin)
        self.logger.debug('finish Rebin ')
        
        self.getXYcoordinates()
        self.getDataFromWs()
        self.logger.debug('finish getDataFromWs ')
        #'''
        _result=True
        
        DeleteWorkspace(Workspace=self.module)
        CleanFileCache()
        '''
        except RuntimeError as e:
            #self.HB.setSta("errror")
            _result=False
            self.logger.error("Mantid RuntimeError ")
        except  ValueError as e:
            _result=False
            self.logger.error("Mantid ValudeError ")
            #DeleteWorkspace(Workspace=self.module)
            #DeleteWorkspace(Workspace=self.module+'_dfocus')

        except MemoryError as e:
            _result=False
            self.logger.error("Mantid MemoryError ")

        except:
            _result=False
            self.logger.error("Mantid Error")
        '''
        return _result

    def reductionByMon(self):
        tmp=self.detTof[-1]/252.7/self.lmin
        wavemax=round(tmp,1)
        tmp=self.detTof[0]/252.7/self.lmax
        wavemin=round(tmp,1)
        tmp=(wavemax-wavemin)/2000
        rbin=round(tmp,4)
        self.wave_rebin=str(wavemin)+','+str(rbin)+','+str(wavemax)
        Load(Filename="./tmp/monitor2.nxs", OutputWorkspace="mon")
        #LoadNexus(Filename="./tmp/monitor2.nxs", OutputWorkspace="mon")
        ConvertUnits(InputWorkspace=self.module+'_1', OutputWorkspace=self.module+'_wave', Target='Wavelength', EMode='Elastic', AlignBins = True)
        Rebin(InputWorkspace=self.module+"_wave", OutputWorkspace=self.module+"_wave", Params=self.wave_rebin)
        RebinToWorkspace(WorkspaceToRebin="mon", WorkspaceToMatch=self.module+"_wave", OutputWorkspace="mon")
        Divide(LHSWorkspace=self.module+"_wave", RHSWorkspace="mon", OutputWorkspace=self.module+"_ans", AllowDifferentNumberSpectra=True)

        ConvertUnits(InputWorkspace=self.module+'_ans', OutputWorkspace=self.module+'_ans_dfocus', Target='dSpacing', EMode='Elastic', AlignBins = True)
        SumSpectra(InputWorkspace=self.module+'_ans_dfocus', OutputWorkspace=self.module+'_ans_dfocus')
        #DiffractionFocussing(InputWorkspace=self.module+'_rebin', OutputWorkspace=self.module+'_dfocus', GroupingWorkspace=self.module+'_GPPD_group')
        Rebin(InputWorkspace=self.module+'_ans_dfocus', OutputWorkspace=self.module+'_ans_dfocus', Params=self.d_rebin)
        ConvertUnits(InputWorkspace=self.module+'_ans_dfocus', OutputWorkspace=self.module+'_ans_tof', Target='TOF')
        #Rebin(InputWorkspace=self.module+'_ans_tof', OutputWorkspace=self.module+'_ans_tof', Params='16,16,40000')
        
    def getXYcoordinates(self):
        self.xaxis=[]
        self.yaxis=[]
        self.zaxis=[]
        name=mtd[str(self.module+'_1')]
        for j in range(name.getNumberHistograms()):
            _pos=name.getDetector(j).getPos()
            self.xaxis.append(_pos.X()*1000)
            self.yaxis.append(_pos.Y()*1000)
            self.zaxis.append(_pos.Z()*1000)
        self.xaxis=list(set(self.xaxis))
        self.yaxis=list(set(self.yaxis))
        self.zaxis=list(set(self.zaxis))
        self.xaxis.sort()
        self.yaxis.sort()
        self.zaxis.sort()
       
        self.xd=[]
        self.xtof=[]
        name=mtd[str(self.module)+'_dfocus']
        _tmp=name.readX(0)
        for j in range(len(_tmp)-1):
            self.xd.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
            self.xtof.append(self.xd[-1]*self.constA)

        if len(self.xaxis)!=0 and len(self.yaxis)!=0 and len(self.zaxis)!=0 and len(self.xd)!=0:
            mNum=int(self.module[6])
            if mNum==3 or mNum==4:
                self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/x", jsonArray.jsonEncoder(self.zaxis))
                self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/y", jsonArray.jsonEncoder(self.yaxis))
            else:
                self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/x", jsonArray.jsonEncoder(self.xaxis))
                self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/y", jsonArray.jsonEncoder(self.yaxis))
    
            path1="/GPPD/workspace/MantidData/"+self.module+"/d"
            self.neonRedis_write.set(path1, jsonArray.jsonEncoder(self.xd))
            path11="/GPPD/workspace/MantidData/"+self.module+"/tof"
            self.neonRedis_write.set(path11, jsonArray.jsonEncoder(self.xtof))
            
            self.hasAxis=True
        else:
            self.hasAxis=False

    def getDataFromWs(self):
        self.counts=[]
        name=mtd[str(self.module+'_1')]
        for j in range(name.getNumberHistograms()):
            self.counts.append(sum(name.readY(j)))

        name=mtd[str(self.module+'_dfocus')]
        self.v=name.readY(0)

    def setData(self):
        mNum=int(self.module[6])
        if mNum==3 or mNum==4:
            nx=len(self.zaxis)
            ny=len(self.yaxis)
        else:
            nx=len(self.xaxis)
            ny=len(self.yaxis)
        
        _tmp=np.reshape(self.counts, (ny,nx)).tolist()
        self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/value", jsonArray.jsonEncoder(_tmp))

        path2="/GPPD/workspace/MantidData/"+self.module+"/intensity"
        self.neonRedis_write.set(path2, jsonArray.jsonEncoder(self.v))
        path22="/GPPD/workspace/MantidData/"+self.module+"/counts"
        self.neonRedis_write.set(path22, jsonArray.jsonEncoder(self.v))

        self.logger.debug("set x,y value for all bank! "+self.module+" "+str(datetime.datetime.now()))

    def process(self):
        be=time.time()
        be2=time.time()
        self.processCommand()
        #if self.running:
        if self.status==4:
            self.detPid=self.get1Ddata(self.neonpathDetPid)
            self.detTof=[]
            tmptof=self.get1Ddata(self.neonpathDetTof)
            for i in range(len(tmptof)):
                self.detTof.append(tmptof[i]+self.delay)

            self.logger.debug("start get value from neon for"+self.module)
            _result1=self.get2Ddata()
            self.processCommand()
            self.logger.debug(str(time.time()-be2)+' seconds for get data')
            #print time.time()-be2, 'seconds for get Data!'
            be2=time.time()
            if _result1 and self.status==4:                
                self.logger.debug("start createWS for"+self.module)
                _result2=self.createWorkspace(_result1)
                #'''
                #if not self.hasAxis:
                    #self.logger.debug("start get xy coordniates for"+self.module)
                    #self.getXYcoordinates()
                self.processCommand()
                self.logger.debug(str(time.time()-be2)+' seconds for create ws')
                #print time.time()-be2, 'seconds for create ws !'
                be2=time.time()
                #if self.hasAxis and _result2 and self.status==4:                
                if _result2 and self.status==4:                
                    self.logger.debug("   INFO: dataSet"+str(datetime.datetime.now()))
                    self.setData()
                    self.logger.debug(str(time.time()-be2)+' seconds for data set')
                    #print time.time()-be2, 'seconds for data set !'
                    self.logger.debug("finish "+self.module+" "+str(time.time()-be)+" seconds!")
                #'''

    def show_growth(self, limit=10, peak_stats={}, shortnames=True, file=None):
        gc.collect()
        stats = typestats(shortnames=shortnames)
        deltas = {}
        for name, count in iteritems(stats):
            old_count = peak_stats.get(name, 0)
            if count > old_count:
                deltas[name] = count - old_count
                peak_stats[name] = count
        deltas = sorted(deltas.items(), key=operator.itemgetter(1),reverse=True)


    def run(self):
        while True:
            self.process()
            #gc.collect()
            #self.show_growth()
            time.sleep(self.refreshtime)

