from mantid.simpleapi import *
import time
import redis
import datetime
import jsonArray
import json
import numpy as np
#import shutil
import threading
import path
#class reduction(multiprocessing.Process):
class reduction(threading.Thread):
    def __init__(self,hb, neonRedis, refreshtime, logger, delay):
        super(reduction, self).__init__()
        self.logger=logger
        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis
        self.neonRedis_read=neonRedis
        self.running=False
        self.hb=hb
        self.status=1
        self.delay=int(delay)
        self.command=-1
        self.commandPath="/GPPD/control/command/mantid"
        self.commandList=['configure','unconfigure','start','pause','resume','stop','abort']
        self.statusList=['waiting','unconfigured','configuring','ready','running','paused','error']

        self.groupList1=['module131', 'module132', 'module133', 'module231', 'module232', 'module233']
        self.groupList2=['module322', 'module331', 'module332', 'module333', 'module341', 'module342', 'module343', 'module422', 'module431', 'module432', 'module433', 'module441', 'module442', 'module443']
        self.groupList3=['module521', 'module522', 'module523', 'module531', 'module532', 'module533', 'module541', 'module542', 'module543', 'module621', 'module622', 'module623', 'module631', 'module632', 'module633', 'module641', 'module642', 'module643']

    def getCommand(self):
        try:
            _json=self.neonRedis_read.get(self.commandPath)
            _data=int(json.loads(_json))
        except:
            _data=-1
        return _data

    def setCommand(self, command):
        self.command=command

    def setStatus(self, num):
        self.hb.setStatus(num)

    def stateMachine(self, command, status):
        if command == 0:
            if status == 1:
                status = 3
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 1:
            if status == 3:
                status = 1
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"
        elif command == 2:
            if status == 3:
                self.running=True
                status = 4
            elif status == 1:
                status = 3
                self.running=True
                status = 4

            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 3:
            if status == 4:
                status = 5
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 4:
            if status == 5:
                status = 4
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"

        elif command == 5:
            if status == 4:
                status = 3
            else:
                print self.statusList[status]+" status cannot receive "+self.commandList[command]+" command"
        
        elif command == 6:
            status = 1
        else:
            pass

        return status

    def processCommand(self):
        _command=self.getCommand()
        if self.command==_command:
            pass
        else:
            self.setCommand(_command)
            self.logger.debug("new command: "+str(self.command))
            self.logger.debug("before statemachine: "+str(self.status))
            self.status=self.stateMachine(self.command, self.status)
            self.setStatus(self.status)
            self.logger.debug("after statemachine: "+str(self.status))

    def get1Ddata(self, path):
        _json=self.neonRedis_read.get(path)
        data=jsonArray.jsonDecoder(_json)
        return data
    
    def getProtonCharge(self):
        data=[]
        path="/GPPD/drone/proton_charge"
        _json=self.neonRedis_read.get(path)
        if _json is None:
            return 1
        else:
            data=jsonArray.jsonDecoder(_json)
            val=data[1][-1]
            if(type(val)==int):
                return val
            else:
                return 1

    def getXdata(self, groupList, constA):
        x_d=self.get1Ddata('/GPPD/workspace/MantidData/'+groupList[0]+'/d')
        x_tof=[]
        for ix in x_d:
            x_tof.append(ix*constA)
        return x_d, x_tof 

 
    def mergeData(self,groupList, length):
        # merge raw Intensity
        value=np.zeros(length).tolist()
        for i in range(len(groupList)):
            data=[]
            data=self.get1Ddata("/GPPD/workspace/MantidData/"+groupList[i]+"/intensity")
            for i in range(length):
                value[i]=value[i]+data[i]
        return value
        
    def setData(self, groupList, groupName, constA):
        # set x axis data
        x_d, x_tof = self.getXdata(groupList, constA)
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/raw/d", jsonArray.jsonEncoder(x_d))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/raw/tof", jsonArray.jsonEncoder(x_tof))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/PC/d", jsonArray.jsonEncoder(x_d))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/PC/tof", jsonArray.jsonEncoder(x_tof))
        
        # set y axis data
        value=self.mergeData(groupList, len(x_d)) 
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/raw/intensity", jsonArray.jsonEncoder(value))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/raw/counts", jsonArray.jsonEncoder(value))

        #set nor data by PC
        for i in range(len(value)):
            #value[i]=value[i]/self.proton
            value[i]=value[i]/1.0
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/PC/intensity", jsonArray.jsonEncoder(value))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/PC/counts", jsonArray.jsonEncoder(value))
        

        #set nor data by monitor
        #value_mon=self.mergeData(groupList, "/GPPD/workspace/MantidData/reduction")
        #self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/monitor/d", _json)
        #self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/monitor/intensity", jsonArray.jsonEncoder(value_mon))
        #self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/monitor/tof", jsonArray.jsonEncoder(x_tof))
        #self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/reduction/monitor/counts", jsonArray.jsonEncoder(value_mon))

    def setNeutronCounts(self):
        num=0
        for name in self.groupList1:
            try:
                num+=int(json.loads(self.neonRedis_read.get("/GPPD/workspace/MantidData/"+name+"/neutroncounts")))
            except:
                self.logger.debug("no neutron counts in "+name)
        for name in self.groupList2:
            try:
                num+=int(json.loads(self.neonRedis_read.get("/GPPD/workspace/MantidData/"+name+"/neutroncounts")))
            except:
                self.logger.debug("no neutron counts in "+name)

        for name in self.groupList3:
            try:
                num+=int(json.loads(self.neonRedis_read.get("/GPPD/workspace/MantidData/"+name+"/neutroncounts")))
            except:
                self.logger.debug("no neutron counts in "+name)
        self.logger.debug("neutron counts is "+str(num))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/neutroncounts", json.dumps(num))

    def process(self):
        be=time.time()
        self.processCommand()
        if self.status==4:
            #self.proton=self.getProtonCharge()
            #self.proton=1
            self.logger.debug('start running processing')
            self.setNeutronCounts()
            try:
                self.setData(self.groupList1,"group01", 1445.444)
                self.setData(self.groupList2,"group02", 9338.9)
                self.setData(self.groupList3,"group03", 14707.7)
                self.logger.debug("finish data focussing for 3 group!"+str(time.time()-be)+" seconds!")
            except:
                self.logger.warning("can't get data!")
                time.sleep(60)
        else:
            pass

    def run(self):
        while True:
            try:
                self.process()
                time.sleep(self.refreshtime)
            except:
                time.sleep(10)
    
