#!/usr/bin/python
import sys
import time
import threading
import subprocess
import logging
from logging.handlers import RotatingFileHandler
import os
import shlex

logger = logging.getLogger('GPPDmantid')
hdlr = RotatingFileHandler(os.getcwd() + '/GPPDmantid.log', maxBytes=1, backupCount=0)
formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
hdlr.setFormatter(formatter)
logger.addHandler(hdlr)
logger.setLevel(logging.DEBUG)

class main(threading.Thread):   
    def __init__(self):
        threading.Thread.__init__(self)
        self.moduleList=['GPPD_module131','GPPD_module132','GPPD_module133','GPPD_module231','GPPD_module232','GPPD_module233','GPPD_module322','GPPD_module331','GPPD_module332','GPPD_module333','GPPD_module341','GPPD_module342','GPPD_module343','GPPD_module422','GPPD_module431','GPPD_module432','GPPD_module433','GPPD_module441','GPPD_module442','GPPD_module443','GPPD_module521','GPPD_module522','GPPD_module523','GPPD_module531','GPPD_module532','GPPD_module533','GPPD_module541','GPPD_module542','GPPD_module543','GPPD_module621','GPPD_module622','GPPD_module623','GPPD_module631','GPPD_module632','GPPD_module633','GPPD_module641','GPPD_module642','GPPD_module643','GPPD_monitor','GPPD_pattern']

    def process(self):
        for _tmp in self.moduleList:
            try:
                _cmd = "ps -C " + _tmp + ".py -o pid="
                pid = subprocess.check_output(_cmd, shell=True)
                pid = shlex.split(pid)
            except:
                pid=[]

            print pid
            
            if len(pid)==0:
                #start m
                logger.error(_tmp+": restart")
                _cmd='./'+_tmp+'.py 5650 &'
                subprocess.Popen(_cmd, shell=True)
            elif len(pid)==1:
                pass
            else:
                logger.error(_tmp+": multiple process")
                _cmd='pkill -9 '+_tmp
                subprocess.Popen(_cmd, shell=True)
                _cmd='./'+_tmp+'.py 5650 &'
                subprocess.Popen(_cmd, shell=True)
    
    def run(self):
        while True:
            self.process()
            time.sleep(180)

if __name__=="__main__":
    threadDaemon = main()
    threadDaemon.setDaemon(True)
    threadDaemon.start()
    threadDaemon.join()
    sys.exit()

