class getConfigure():
    def __init__(self):
        # setting for Detector
        self.bankGroup=['Bank01', 'Bank02', 'Bank03', 'Bank04', 'Bank05', 'Bank06']
        self.bankList={'Bank01':[3,4], 'Bank02':[1,2], 'Bank03':[5], 'Bank04':[6], 'Bank05':[7], 'Bank06':[8]}
        
        # setting for Monitor
        self.monitorGroup=['Monitor01', 'Monitor02', 'Monitor03']
        self.monitorList={'Monitor01':[1],'Monitor02':[2],'Monitor03':[3]}

    def getBankList(self):
        return self.bankList

    def getMonitorList(self):
        return self.monitorList

    def getBankInputPath(self):
        _n=len(self.bankGroup)
        _neonpathDetPid=[]
        _neonpathDetTof=[]
        _neonpathDetValue=[]

        _prefix="/GPPD/workspace/test/data/module"
        for i in range(_n):
            _neonpathDetPid.append([])

            _m=self.bankList[self.bankGroup[i]]

            for j in range(_m):
                _neonpathDetPid[i].append(_prefix+str(j).zfill(2)+"/pid")
                _neonpathDetTof[i].append(_prefix+str(j).zfill(2)+"/tof")
                _neonpathDetValue[i].append(_prefix+str(j).zfill(2)+"/value")

        return _neonpathDetPid, _neonpathDetTof, _neonpathDetValue

    def getMonitorInputPath(self):
        _n=len(self.monitorGroup)
        _neonpathMonPid=[]
        _neonpathMonTof=[]
        _neonpathMonValue=[]

        _prefix="/GPPD/workspace/test/data/monitor"
        for i in range(_n):
            _neonpathMonPid.append([])

            _m=self.monitorList[self.monitorGroup[i]]

            for j in range(_m):
                _neonpathMonPid[i].append(_prefix+str(j).zfill(2)+"/pid")
                _neonpathMonTof[i].append(_prefix+str(j).zfill(2)+"/tof")
                _neonpathMonValue[i].append(_prefix+str(j).zfill(2)+"/value")

        return _neonpathMonPid, _neonpathMonTof, _neonpathMonValue

    def getBankOutputPath(self):
        pass
    
    def getMonitorOutputPath(self):
        pass
