from mantid.simpleapi import *
import jsonArray
import time
import threading
import numpy as np
import json
try:
    from cStringIO import StringIO as memfile  ## for Python 2
except ImportError:
    from io import BytesIO as memfile     ## for Python 3

class monitorIO(threading.Thread):
    def __init__(self,hb, neonRedis, refreshtime, monitorList, logger):
        super(monitorIO, self).__init__()

        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis
        self.neonRedis_read=neonRedis
        self.monitorList=monitorList
        self.logger=logger
        self.hb = hb
        self.status = 1
        self.command=-1
        self.commandPath="/GPPD/control/command/mantid"
        self.commandList=['configure','unconfigure','start','pause','resume','stop','abort']
        self.statusList=['waiting','unconfigured','configuring','ready','running','paused','error']
        self.monTof=[]
        self.monValue=[[] for i in range(len(self.monitorList))]
        self.monPidNum=1024
        self.tofStep=1
        self.neonpathValue=[]
        self.neonpathPid=[]
        self.neonpathTof=[]
        self.ncPath=[]
        for name in self.monitorList:
            self.ncPath.append("/GPPD/workspace/MantidData/"+name+"/neutroncounts")
            self.neonpathValue.append("/GPPD/workspace/earthworm/"+name+"/value")
            self.neonpathTof.append("/GPPD/workspace/earthworm/"+name+"/tof")

        l1=28.267
        l2=28.347
        l3=31.227


    def getConf(self):
        _json=self.neonRedis_read.get('/GPPD/control/configure')
        _conf=json.loads(_json)
        try:
            self.delay=int(_conf["m2Delay"])
        except:
            self.delay=0
        self.logger.warning('delay time is: '+str(self.delay))
        self.monTof=[]
        tofNum=int(40000/self.tofStep)+1
        for i in range(tofNum):
            self.monTof.append(self.tofStep*i+self.delay)

    def getCommand(self):
        try:
            _json=self.neonRedis_read.get(self.commandPath)
            _data=int(json.loads(_json))
        except:
            _data=-1
        return _data

    def setCommand(self, command):
        self.command=command

    def setStatus(self, num):
        self.hb.setStatus(num)

    def stateMachine(self, command, status):
        if command == 0:
            if status == 1:
                status = 3
                self.getConf()

        elif command == 1:
            status = 1

        elif command == 2:
            if status == 3:
                status = 4
            elif status == 1:
                status = 3
                self.getConf()
                status = 4

        elif command == 3:
            if status == 4:
                status = 5

        elif command == 4:
            if status == 5:
                status = 4

        elif command == 5:
            if status == 4:
                status = 3

        elif command == 6:
            status = 1
        else:
            pass

        return status
    
    def processCommand(self):
        _command=self.getCommand()
        if self.command==_command:
            pass
        else:
            self.setCommand(_command)
            self.logger.warning("new command: "+str(self.command))
            self.logger.warning("before statemachine: "+str(self.status))
            self.status=self.stateMachine(self.command, self.status)
            self.setStatus(self.status)
            self.logger.warning("after statemachine: "+str(self.status))

    def get1Ddata(self, path):
        _json=self.neonRedis_read.get(path)
        data=np.load(memfile(_json))
        return data

    def get2Ddata(self,i):
        _result=False
        try:
            _json=self.neonRedis_read.get(self.neonpathValue[i])
            data=np.load(memfile(_json))
            nc=data.sum()
            self.logger.debug("module nc: "+str(nc))
            #self.neonRedis_write.set(self.ncPath[i], json.dumps(nc))
            _result=True
        except:
            _result=False
            self.logger.warning("no value data for  "+self.monitorList[i])
            data = []
        return _result, data

    def createWorkspace(self,num, value):
        _result=False
        name=self.monitorList[num]
        try:
            CreateWorkspace(OutputWorkspace=name, DataX=self.monTof, DataY=value, NSpec=1, UnitX='TOF', VerticalAxisUnit='SpectraNumber')
            LoadInstrument(Workspace=name, Filename='./instrument/'+name+'.xml', RewriteSpectraMap='True')
            SaveNexus(InputWorkspace=name, Filename='./'+name+'.nxs')
            ConvertUnits(InputWorkspace=name, OutputWorkspace='wave', Target='Wavelength', AlignBins = True)
            SumSpectra(InputWorkspace='wave', OutputWorkspace="wave", IncludeMonitors=True)
            Rebin(InputWorkspace="wave",OutputWorkspace="wave", Params=',0.002,')
            ConvertUnits(InputWorkspace='wave', OutputWorkspace='tof', Target='TOF', AlignBins = True)
            ConvertToPointData(InputWorkspace='wave',OutputWorkspace='wave')
            ConvertToPointData(InputWorkspace='tof',OutputWorkspace='tof')
            self.logger.debug('finish getDataFromWs ')
            _result=True
        except:
            _result=False
            self.logger.error("error happened in createWorkspace!!")
        return _result    

    def clearWs(self, num):
        try:
            DeleteWorkspace(Workspace=self.monitorList[num])
            DeleteWorkspace(Workspace='wave')
            DeleteWorkspace(Workspace='tof')
            CleanFileCache()
        except:
            self.logger.warning("error in delete ws")

    def setXYData(self,monitor):
        xaxis=[]
        yaxis=[]
        value=[]
        name=mtd[monitor+"_2"]
        for j in range(name.getNumberHistograms()):
            det=name.getDetector(j)
            pos=det.getRelativePos()
            xaxis.append(pos.X()*1000)
            yaxis.append(pos.Y()*1000)
            value.append(sum(name.readY(j)))
        xaxis=list(set(xaxis))
        yaxis=list(set(yaxis))
        xaxis.sort()
        yaxis.sort()
        ny=len(yaxis)
        nx=len(xaxis)
        vaxis=np.reshape(value, (ny,nx)).tolist()
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/xy_image/x",jsonArray.jsonEncoder(xaxis))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/xy_image/y",jsonArray.jsonEncoder(yaxis))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/xy_image/value",jsonArray.jsonEncoder(vaxis))
        self.logger.debug("set xy data for "+monitor)

    def setDataFromWs(self, name):
        wsname=mtd['wave']
        counts1=wsname.readY(0).tolist()
        xwave=wsname.readX(0).tolist()
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+name+"/wave", jsonArray.jsonEncoder(xwave))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+name+"/intensity", jsonArray.jsonEncoder(counts1))

        wsname=mtd['tof']
        counts2=wsname.readY(0).tolist()
        xtof=wsname.readX(0).tolist()
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+name+"/tof", jsonArray.jsonEncoder(xtof))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+name+"/counts", jsonArray.jsonEncoder(counts2))

    def process(self):
        self.processCommand()
        if self.status==4:
            for i in range(len(self.monitorList)):
                be=time.time()
                self.logger.debug("start running program")
                result2,monValue=self.get2Ddata(i)
                if self.status==4 and result2:
                    result1=self.createWorkspace(i, monValue)
                    if self.status==4 and result1:
                        #self.setXYData(self.monitorList[i])
                        #self.setDataFromWs(self.monitorList[i])
                        #self.clearWs(i)
                        self.logger.debug("finish "+self.monitorList[i]+" "+str(time.time()-be)+" seconds!")

    def run(self):
        while True:
            self.process()
            time.sleep(self.refreshtime)

