from mantid.simpleapi import *
import time
import jsonArray
import threading
import numpy as np
import json
try:
    from cStringIO import StringIO as memfile  ## for Python 2
except ImportError:
    from io import BytesIO as memfile     ## for Python 3

class moduleIO(threading.Thread):
    def __init__(self, hb, neonRedis, refreshtime, module, logger):
        super(moduleIO, self).__init__()

        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis
        self.neonRedis_read=neonRedis
        self.module=module
        self.hb=hb
        self.status=1
        self.logger=logger
        self.command=-1
        self.commandList=['configure','unconfigure','start','pause','resume','stop','abort']
        self.statusList=['waiting','unconfigured','configuring','ready','running','paused','error']

        self.tofStep=16
        self.pidNum=1344

        self.detValue=[]
        self.neonpathDetValue="/GPPD/workspace/detector/"+self.module+"/value"
        #self.neonpathDetPid="/GPPD/workspace/detector/"+self.module+"/pid"
        self.neonpathDetTof="/GPPD/workspace/detector/"+self.module+"/tof"
        self.neonpathDetSet="/GPPD/workspace/MantidData/"+self.module
    
        self.commandPath="/GPPD/control/command/mantid"       
        #self.commandPath="/GPPD/control/command/mantid1"       
        self.instPath="./instrument/module/"+self.module+".xml"
        self.ncPath="/GPPD/workspace/MantidData/"+self.module+"/neutroncounts"

        if self.module[6]== '1' or self.module[6]=='2':
            self.lthetamin=2.861
            self.lthetamax=13.523
            self.lmin=32.0045
            self.lmax=32.132
            self.constA=1445.444
        if self.module[6]== '3' or self.module[6]=='4':
            self.lthetamin=18.4783
            self.lthetamax=26.288
            self.lmin=32.000
            self.lmax=32.157
            self.constA=9338.9
        if self.module[6]== '5' or self.module[6]=='6':
            self.lthetamin=29.1012
            self.lthetamax=31.304
            self.lmin=31.427
            self.lmax=32.226
            self.constA=14707.7
        
    def getdRebin(self):
        tmp=(40000+self.delay)/505.4/self.lthetamin
        dmax=round(tmp,2)
        tmp=(self.delay+16)/505.4/self.lthetamax
        dmin=round(tmp,2)
        tmp=(dmax-dmin)/1000.0
        rbin=round(tmp,8)
        self.d_rebin=str(dmin)+','+str(rbin)+','+str(dmax)
        self.logger.warning("dRebin="+self.d_rebin)

    def getCommand(self):
        try:
            _json=self.neonRedis_read.get(self.commandPath)
            _data=int(json.loads(_json))
        except:
            _data=-1
        return _data

    def setCommand(self, command):
        self.command=command

    def stateMachine(self, command, status):
        if command == 0:
            status = 3
            self.getConf()

        elif command == 1:
            status = 1

        elif command == 2:
            if status == 3:
                status = 4
            elif status == 1:
                status = 3
                self.getConf()
                status = 4
            else:
                status = 4

        elif command == 3:
            status = 5

        elif command == 4:
            status = 4
    
        elif command == 5:
            status = 3

        elif command == 6:
            status = 1
        else:
            pass
        return status

    def setStatus(self,num):
        self.hb.setStatus(num)

    def processCommand(self):
        _command=self.getCommand()
        if self.command==_command:
            pass
        else:
            self.setCommand(_command)
            self.logger.warning("new command: "+str(self.command))
            self.logger.debug("before statemachine: "+str(self.status))
            self.status=self.stateMachine(self.command, self.status)
            self.setStatus(self.status)
            self.logger.warning("after statemachine: "+str(self.status))

    def getConf(self):
        _json=self.neonRedis_read.get('/GPPD/control/configure')
        _conf=json.loads(_json)
        try:
            self.delay=int(_conf["detectorDelay"])
        except:
            self.delay=0
        self.logger.debug('delay time is: '+str(self.delay))
        self.detTof=[]
        tofNum=40000/self.tofStep+1
        for i in range(tofNum):
            self.detTof.append(self.tofStep*i+self.delay)
        self.getdRebin()
 
    def get1Ddata(self, path):
        _json=self.neonRedis_read.get(path)
        data=np.load(memfile(_json)) 
        #data=data.flatten().astype(np.int).tolist()
        return data

    def get2Ddata(self):
        _result=False
        try:
            _json=self.neonRedis_read.get(self.neonpathDetValue)
            data=np.load(memfile(_json))
            #data=data.flatten().astype(np.int).tolist()
            #data=data.astype(np.int)
            nc=data.sum()
            self.logger.debug("module nc: "+str(nc))
            #self.neonRedis_write.set(self.ncPath, json.dumps(nc))
            _result=True
        except:
            _result=False
            self.logger.warning("no value data for  "+self.module)
            data = []
        return _result, data

    def createWorkspace(self, detValue):
        _result=False
        try:
            CreateWorkspace(OutputWorkspace=self.module, DataX=self.detTof, DataY=detValue, NSpec=1344, UnitX='TOF', VerticalAxisUnit='SpectraNumber')
            self.logger.debug('finish Load data inro workspace ')
            LoadInstrument(Workspace=self.module, Filename=self.instPath, RewriteSpectraMap='True')    
            SaveNexus(InputWorkspace=self.module, Filename='./'+self.module+'.nxs')
            ConvertUnits(InputWorkspace=self.module, OutputWorkspace=self.module+'_dfocus', Target='dSpacing', EMode='Elastic', AlignBins = True)
            SumSpectra(InputWorkspace=self.module+'_dfocus', OutputWorkspace=self.module+'_dfocus')
            Rebin(InputWorkspace=self.module+'_dfocus', OutputWorkspace=self.module+'_dfocus', Params=self.d_rebin)
            self.logger.debug('finish Rebin ')
            DeleteWorkspace(Workspace=self.module)
            CleanFileCache()
            _result=True
        except:
            self.logger.error("error happened in createWorkspace!!")
            _result=False
        return _result
    
    #set all x-y axis for picture, include xyimage, tof, d     
    def setXYcoordinates(self):
        self.xaxis=[]
        self.yaxis=[]
        self.zaxis=[]
        name=mtd[str(self.module)]
        for j in range(name.getNumberHistograms()):
            _pos=name.getDetector(j).getPos()
            self.xaxis.append(_pos.X()*1000)
            self.yaxis.append(_pos.Y()*1000)
            self.zaxis.append(_pos.Z()*1000)
        self.xaxis=list(set(self.xaxis))
        self.yaxis=list(set(self.yaxis))
        self.zaxis=list(set(self.zaxis))
        self.xaxis.sort()
        self.yaxis.sort()
        self.zaxis.sort()
       
        self.xd=[]
        self.xtof=[]
        name=mtd[str(self.module)+'_dfocus']
        _tmp=name.readX(0)
        for j in range(len(_tmp)-1):
            self.xd.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
            self.xtof.append(self.xd[-1]*self.constA)

        if len(self.xaxis)!=0 and len(self.yaxis)!=0 and len(self.zaxis)!=0 and len(self.xd)!=0:
            mNum=int(self.module[6])
            if mNum==3 or mNum==4:
                self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/x", jsonArray.jsonEncoder(self.zaxis))
                self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/y", jsonArray.jsonEncoder(self.yaxis))
            else:
                self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/x", jsonArray.jsonEncoder(self.xaxis))
                self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/y", jsonArray.jsonEncoder(self.yaxis))
    
            path="/GPPD/workspace/MantidData/"+self.module+"/d"
            self.neonRedis_write.set(path, jsonArray.jsonEncoder(self.xd))
            path="/GPPD/workspace/MantidData/"+self.module+"/tof"
            self.neonRedis_write.set(path, jsonArray.jsonEncoder(self.xtof))
            
        else:
            pass

    def setData(self):
        xy_image_counts=[]
        name=mtd[str(self.module)]
        for j in range(name.getNumberHistograms()):
            xy_image_counts.append(sum(name.readY(j)))
        name=mtd[str(self.module+'_dfocus')]
        value=name.readY(0)
        mNum=int(self.module[6])
        if mNum==3 or mNum==4:
            nx=len(self.zaxis)
            ny=len(self.yaxis)
        else:
            nx=len(self.xaxis)
            ny=len(self.yaxis)
        _tmp=np.reshape(xy_image_counts, (ny,nx)).tolist()
        self.neonRedis_write.set(self.neonpathDetSet+"/xy_image/value", jsonArray.jsonEncoder(_tmp))
        path="/GPPD/workspace/MantidData/"+self.module+"/intensity"
        self.neonRedis_write.set(path, jsonArray.jsonEncoder(value))
        path="/GPPD/workspace/MantidData/"+self.module+"/counts"
        self.neonRedis_write.set(path, jsonArray.jsonEncoder(value))
        self.logger.debug("set x,y value for all bank! "+self.module+" "+str(datetime.datetime.now()))

    def process(self):
        be=time.time()
        self.processCommand()
        if self.status==4:
            self.logger.debug("start get value from ew for"+self.module)
            _result1,histData=self.get2Ddata()
            self.processCommand()
            if _result1 and self.status==4:                
                self.logger.debug("start createWS for"+self.module)
                _result2=self.createWorkspace(histData)
                self.processCommand()
                if _result2 and self.status==4:                
                    self.logger.debug("start set data to redis")
                    #self.setXYcoordinates()
                    #self.setData()
                    self.logger.debug("finish "+self.module+" "+str(time.time()-be)+" seconds!")

    def run(self):
        while True:
            #try:
            self.process()
            time.sleep(self.refreshtime)
            #except:
            #    time.sleep(5)

