import time
import threading
import json

class neonHeartBeat(threading.Thread):
    def __init__(self, neonRedis,refreshtime, name, mypid):
        super(neonHeartBeat, self).__init__()
        self.neonRedis_write = neonRedis
        self.neonRedis_read = neonRedis
        self.refreshtime = refreshtime
        self.mypid= mypid
        self.name = name
        self.status=1
        self.path="/GPPD/heartbeat/mantid/"+self.name
        self.statusList=['waiting','unconfigured','configuring','ready','running','paused','error']

        #neonRedis.set("/GPPD/stateMachine/status146/"+name,1)
    def setData(self):
        data={}
        data['timestamp']=time.strftime('%Y-%m-%dT%H:%M:%S.%03d+08:00')
        data['status']=self.status
        data['pid']=self.mypid
        #self.neonRedis_write.set(self.path, json.dumps(data))

    def setStatus(self, num):
        self.status=num

    def getStatus(self):
        return self.status

    def process(self):
        self.setData()
        time.sleep(self.refreshtime)    

    def run(self):
        while True:
            try:
                self.process()
            except:
                break

