#!/usr/bin/python3
import connect
import moduleIO
import threading
import os
import heartBeat

class myLog():
    def __init__(self, name):
        import logging
        from logging.handlers import RotatingFileHandler
        logging.basicConfig(level=logging.WARNING,
                format='%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s',
                datefmt='%a, %d %b %Y %H:%M:%S',
                filename=os.getcwd()+'/log/'+name+'.log',
                filemode='a')

        self.logger = logging.getLogger('GPPD_module')
        #hdlr = logging.FileHandler(os.getcwd()+'/RMmantid.log', maxBytes=100, backupCount=5)
        hdlr = RotatingFileHandler(os.getcwd()+'/log/'+name+'.log', maxBytes=100, backupCount=0)
        #hdlr = RotatingFileHandler(os.getcwd()+'/myMantid_'+name+'.log', maxBytes=10*1024*1024, backupCount=0)
        #formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
        #hdlr.setFormatter(formatter)
        #self.logger.addHandler(hdlr)
        #self.logger.setLevel(logging.DEBUG)

    def getLog(self):
        return self.logger

if __name__ == '__main__':
    name = 'module243'

    #=======set logger file===========
    _log=myLog(name)
    logger= _log.getLog()
    mypid=str(os.getpid())

    # ======Try to connect NEON server
    ip_port = [('10.1.33.141', 9001)]
    #ip_port = [('10.1.53.240', 9001)]
    passwd = 'sanlie;123'
    redisW=connect.connectNeon(ip_port, passwd, 1.0)
    r=redisW.getRedisRead()
   
    
    #=======set heartBeat thread=============== 
    myThread1=(heartBeat.neonHeartBeat(r, 1.0, name, mypid))
    #=======set data process thread=========
    myThread2=(moduleIO.moduleIO(myThread1, r, 10, name, logger))
    myThread2.setDaemon(True)
    myThread1.start()
    myThread2.start()
    myThread1.join()
    myThread2.join()
