from mantid.simpleapi import *
import time
import redis
import datetime
import jsonArray
import multiprocessing
from multiprocessing import Process, Manager
import json
#import shutil

class reduction(multiprocessing.Process):
    def __init__(self, neonRedis_read, neonRedis_write, refreshtime):
        super(reduction, self).__init__()

        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis_write
        self.neonRedis_read=neonRedis_read
        self.groupList1=['module131', 'module132', 'module133', 'module231', 'module232', 'module233']
        self.groupList2=['module322', 'module331', 'module332', 'module333', 'module341', 'module342', 'module343', 'module422', 'module431', 'module432', 'module433', 'module441', 'module442', 'module443']
        self.groupList3=['module521', 'module522', 'module523', 'module531', 'module532', 'module533', 'module541', 'module542', 'module543', 'module621', 'module622', 'module623', 'module631', 'module632', 'module633', 'module641', 'module642', 'module643']

    def get1Ddata(self, path):
        data=[]
        _json=self.neonRedis_read.get(path)
        while _json is None:
            print "no 1D data in module!" ,datetime.datetime.now()
            time.sleep(5)
            _json=self.neonRedis_read.get(path)
        data=jsonArray.jsonDecoder(_json)
        return data
 
    def mergeData(self,groupList, groupName):
        tmp1=[]
        tmp2=[]
        value1=[]
        value2=[]
        num=0
        for i in range(len(groupList)):
            data1=[]
            data1=self.get1Ddata("/GPPD/workspace/MantidData/"+groupList[i]+"/counts")
            num=len(data1)
            tmp1.append(data1)
            data2=[]
            data2=self.get1Ddata("/GPPD/workspace/MantidData/"+groupList[i]+"/intensity")
            tmp2.append(data2)
        for j in range(num):
            ans1=0
            ans2=0
            for k in range(len(groupList)):
                ans1=ans1+tmp1[k][j]
                ans2=ans2+tmp2[k][j]
            value1.append(ans1)
            value2.append(ans2)
        x1=self.neonRedis_read.get("/GPPD/workspace/MantidData/"+groupList[0]+"/tof")
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/raw/tof", x1)
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/raw/counts", jsonArray.jsonEncoder(value1))
        x2=self.neonRedis_read.get("/GPPD/workspace/MantidData/"+groupList[0]+"/d")
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/raw/d", x2)
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+groupName+"/raw/instensity", jsonArray.jsonEncoder(value2))

    def setNeutronCounts(self):
        num=0
        for name in self.groupList1:
            num+=int(json.loads(self.neonRedis_read.get("/GPPD/workspace/MantidData/"+name+"/neutroncounts")))
        for name in self.groupList2:
            num+=int(json.loads(self.neonRedis_read.get("/GPPD/workspace/MantidData/"+name+"/neutroncounts")))
        for name in self.groupList3:
            num+=int(json.loads(self.neonRedis_read.get("/GPPD/workspace/MantidData/"+name+"/neutroncounts")))
               
        self.neonRedis_write.set("/GPPD/workspace/MantidData/neutroncounts", json.dumps(num))

    def process(self):
        be=time.time()
        self.mergeData(self.groupList1,"group01")
        self.mergeData(self.groupList2,"group02")
        self.mergeData(self.groupList3,"group03")
        self.setNeutronCounts()
        print "===================================================="
        print time.time()-be, " secondes finish!", datetime.datetime.now()
    def run(self):
        while True:
            self.process()
            time.sleep(self.refreshtime)
    
