from mantid.simpleapi import *
import jsonArray
import time
import datetime
import json
import multiprocessing
from multiprocessing import Process, Manager
import shutil

class monitorIO(multiprocessing.Process):
    def __init__(self, neonRedis_write, neonRedis_read, refreshtime, monitorList):
        super(monitorIO, self).__init__()

        self.refreshtime=refreshtime
        self.neonRedis_write=neonRedis_write
        self.neonRedis_read=neonRedis_read
        self.monitorList=monitorList
        self.monTof=[]
        for i in range(2501):
            self.monTof.append(i*16)
        self.monPid=[]
        for i in range(1024):
            self.monPid.append(i+1)
        self.neonpath=[]
        for name in self.monitorList:
            self.neonpath.append("/GPPD/workspace/"+name+"/value")
 
    def getDataFromNeon(self, monitor, path):
        self.monValue=[]
        _json=self.neonRedis_read.get(path)
        print path
        #print "json: ", type(_json)
        while _json is None:
            print "no 2D data in ",monitor, " ", datetime.datetime.now()
            _json=self.neonRedis_read.get(path)
            time.sleep(10)
        _array=jsonArray.jsonDecoder(_json)
        a=0
        for ix in _array:
            a=a+sum(ix)
            for iy in ix:
                self.monValue.append(iy)
        print "get data from neon successfully ", monitor," Ncounts:", a," ",datetime.datetime.now()

    def createWorkspace(self, monitor):
        LoadCSNSRaw(OutputWorkspace=monitor, PixelID_bank=[0,1], TimeOfFlight_bank=[0,8], Counts_bank=[1,1], PixelID_monitor=self.monPid, TimeOfFlight_monitor=self.monTof, Counts_monitor=self.monValue)
        SaveNexus(InputWorkspace=monitor+'_2', Filename='./'+monitor+'.nxs')
        #time.sleep(60)
        LoadInstrument(Workspace=monitor+"_2", Filename='./instrument/'+monitor+'.xml', RewriteSpectraMap='True')

    def set1DdataToNeon(self,wsname, path1, path2):
        name=mtd[wsname]
        x=[]
        v=[]
        v=name.readY(0)
        _tmp=name.readX(0)
        for j in range(len(_tmp)-1):
            x.append(_tmp[j]+(_tmp[j+1]-_tmp[j])/2)
        self.neonRedis_write.set(path1, jsonArray.jsonEncoder(x))
        self.neonRedis_write.set(path2, jsonArray.jsonEncoder(v))

    def setXYdata(self,monitor):
        xaxis=[]
        yaxis=[]
        counts=[]
        name=mtd[monitor+"_2"]
        for j in range(name.getNumberHistograms()):
            det=name.getDetector(j)
            pos=det.getRelativePos()
            xaxis.append(pos.X())
            yaxis.append(pos.Y())
            counts.append(sum(name.readY(j)))
        xaxis=list(set(xaxis))
        yaxis=list(set(yaxis))
        xaxis.sort()
        yaxis.sort()
        for i in range(len(yaxis)):
            yaxis[i]=yaxis[i]*1000
        for i in range(len(xaxis)):
            xaxis[i]=xaxis[i]*1000

        vaxis=[[] for m in range(len(yaxis))]
        n=0
        for j in range(len(yaxis)):
            for k in range(len(xaxis)):
                vaxis[j].append(counts[n])
                n=n+1
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/xy_image/x",jsonArray.jsonEncoder(xaxis))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/xy_image/y",jsonArray.jsonEncoder(yaxis))
        self.neonRedis_write.set("/GPPD/workspace/MantidData/"+monitor+"/value",jsonArray.jsonEncoder(vaxis))
        print "set xy data for ", monitor, " ", datetime.datetime.now()

    def dataSet(self, monitor):
        # set tof counts
        SumSpectra(InputWorkspace=monitor+'_2', OutputWorkspace=monitor+"_tofCounts", IncludeMonitors=True)
        self.set1DdataToNeon(monitor+"_tofCounts","/GPPD/workspace/MantidData/"+monitor+"/tof","/GPPD/workspace/MantidData/"+monitor+"/counts")
        ConvertUnits(InputWorkspace=monitor+'_tofCounts', OutputWorkspace=monitor+'_wave', Target='Wavelength')
        self.set1DdataToNeon(monitor+"_wave","/GPPD/workspace/MantidData/"+monitor+"/wave","/GPPD/workspace/MantidData/"+monitor+"/intensity")
        # set XY data
        self.setXYdata(monitor)

        DeleteWorkspace(Workspace=monitor)
        DeleteWorkspace(Workspace=monitor+'_tofCounts')
        DeleteWorkspace(Workspace=monitor+'_wave')

    def process(self):
        be=time.time()
        for i in range(3):
            self.getDataFromNeon(self.monitorList[i], self.neonpath[i])
            while (len(self.monValue)!=(len(self.monTof)-1)*len(self.monPid)):
                print "data size doesn't match! please waiting..."
                time.sleep(10)
                self.getDataFromNeon(self.monitorList[i], self.neonpath[i])
            print "   INFO: createWorkspace", datetime.datetime.now()
            self.createWorkspace(self.monitorList[i])
            print "   INFO: dataSet", datetime.datetime.now()
            self.dataSet(self.monitorList[i])
            shutil.move("./"+self.monitorList[i]+".nxs","./tmp/"+self.monitorList[i]+".nxs" )
            print "finish move monitor.nxs"
        print time.time()-be
    def run(self):
        while True:
            self.process()
            time.sleep(0.5)

