# reduction without sensitivity and efficiency
from mantid.simpleapi import *
import math
from xml.etree import ElementTree as ET
import glob
import re
import os
import sys

def mergeWS(prepath, wsList,output):
    for ix in wsList:
        name='RUN'+str(ix).zfill(7)
        LoadNexus(Filename=prepath+'\\'+name+'\\'+output+'.nxs',OutputWorkspace=str(ix))
    for i in range(len(wsList)):
        if len(wsList)== 1:
            CloneWorkspace(InputWorkspace=str(wsList[i]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
        elif wsList[i+1]!=wsList[-1]:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=str(wsList[i+1]))
            DeleteWorkspace(Workspace=str(wsList[i]))
        else:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
            DeleteWorkspace(Workspace=str(wsList[i+1]))
            break


def getMask(xPids, yPids):
    index=[]
    xnum=xPids[1]-xPids[0]+1
    ynum=yPids[1]-yPids[0]+1
    sta=yPids[0]*125+xPids[0]
    for i in range(xnum):
        for j in range(ynum):
            index.append(sta+j*125+i)
    print index
    return index


def findCmaskWS(wsname):
    x=0.0009
    y=-0.00229
    MoveInstrumentComponent(Workspace=wsname, ComponentName='Bank01', X=x, Y=y, RelativePosition=False)
    index=getMask([0,18],[0,119])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)
    index=getMask([105,124],[0,119])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)
    inner=0.048
    xml_inner='<infinite-cylinder id="beam_stop"><centre x="0" y="0" z="0.0" /><axis x="0" y="0" z="1" /><radius val= "'+str(inner)+'" /></infinite-cylinder><algebra val="beam_stop"/>'
    MaskDetectorsInShape(Workspace=wsname, ShapeXML=xml_inner)

    index=getMask([60,63],[0,57])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)

def calResolution(M2sample,wavelength, Q):
    L1=11.90-7.45
    #L1, source to sample distance, unit: m 
    L2=4.0
    #L2, sample to detector distance, unit: m 
    d1=1.9/100.0
    #d1,source aperture diameter, unit: m 
    d2=0.6/100.0
    #d2, sample aperture diameter, unit: m 
    d3=1.6/100.0
    #d3, detector res, unit: m   
    detector_min=0.048
    #detector minimum position
    detector_max=0.7
    #detector maximum position
    delta_lamda=0.0057
    #variance of lamda
    
    #Q=mtd['Q'].readX(0)
    
    #wavelength=mtd['wavelength'].readX(0)
    efficiency=[]
    for efficiency_index in range(len(wavelength)):
        efficiency.append(4.7613/1000000.0+0.00054333*wavelength[efficiency_index])
    #M2 efficiency

    
    Intensity=M2sample
    Intensity_eff=[]
    for Intensity_index in range(len(Intensity)):
        Intensity_eff.append(Intensity[Intensity_index]/efficiency[Intensity_index])
    #Intensity=Intensity/efficiency
    
    sigmaQ=[]
    for Q_value in Q:
        total_intensity=0
        lamda_value_index=0
        sigmaQ_sum=0
        for lamda_value in wavelength:
            Ldet=L2*Q_value*lamda_value/6.28
            
            if detector_min < Ldet < detector_max:
                total_intensity=total_intensity+Intensity_eff[lamda_value_index]
                sigmaQ_sum=sigmaQ_sum+Intensity_eff[lamda_value_index]*math.sqrt((delta_lamda)**2.0+0.25*((L2/L1)**2.0)*((d1/2.0/Ldet)**2.0)+0.25*((1+L2/L1)**2.0)*((d2/2.0/Ldet)**2.0)+1.0/12.0*((d3/Ldet)**2.0))*Q_value
            lamda_value_index=lamda_value_index+1
                      
        sigmaQ.append(sigmaQ_sum/total_intensity)
            
        
        
    return sigmaQ
        
        
def outputIq(prepath, runNo, transRunNo, qName, wName, m2Sample):

    Q=mtd[qName].readX(0)
    Q_shift=[]
    for Q_shift_index in range(len(Q)-1):
        Q_shift.append((Q[Q_shift_index]+Q[Q_shift_index+1])/2.0)
        
    iQ=mtd[qName].readY(0)
    
    sIQ=mtd[qName].readE(0)
     
    wavelength=mtd[wName].readX(0)
    wavelength_shift=[]
    for wavelength_shift_index in range(len(wavelength)-1):
        wavelength_shift.append((wavelength[wavelength_shift_index]+wavelength[wavelength_shift_index+1])/2.0)
    #change wavelength from bin to point
    
    M2sample=mtd[m2Sample].readY(0)
     
    sQ=calResolution(M2sample,wavelength_shift,Q)
     
    f_fp=prepath+'/SANS_'+str(runNo)+'.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Run '+str(runNo)+' and Trans '+str(transRunNo)+' from SANS@CSNS\n')
    #ff.write('%d',% (runNo))
    ff.write('Q (1/A) | IQ (1/cm) | std. dev. I(Q) (1/cm) | sigmaQ (1/A) \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(Q_shift)):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f %.6f \n' % (Q_shift[i],iQ[i],sIQ[i],sQ[i]))
        
        
def readProtonCharge(prepath,wslist):            
    pc=[]        
    for ix in wslist:
        runnum='RUN'+str(ix).zfill(7)
        rawpath=prepath+'\\'+runnum+'\\'
        xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
        xmlfile=xmllist[0]
        root = ET.parse(xmlfile)
        item=root.find('NXentry')    
        pc.append(float(item.findtext('proton_charge')))
    pc_final=sum(pc)/len(pc)

    return pc_final    





#Al_Mg_ht_1
'''
sample_run=[1095]
transam_run=[1155]
volume=3.14*0.34*0.34*0.09
trans_run=[1154]
Np=80


trans_spline=True
'''

#JZFM_1
'''
sample_run=[1233]
transam_run=[1230]
volume=3.14*0.34*0.34*0.128
trans_run=[1226]
Np=80


'''
#J80
'''
sample_run=[1239]
transam_run=[1173]
volume=3.14*0.34*0.34*0.096
trans_run=[1171]
Np=80


'''

#J82
'''
sample_run=[1240]
transam_run=[1176]
volume=3.14*0.34*0.34*0.11
trans_run=[1171]
Np=80
'''
#J83

sample_run=[1257]
transam_run=[1177]
volume=3.14*0.34*0.34*0.14
trans_run=[1171]
Np=80




#BP_62.5K_4#
'''
sample_run=[1248]
transam_run=[1247]
volume=3.14*0.34*0.34*0.114
trans_run=[1246]
Np=80
'''




empty_run=[960,961]





monSUM=True
prepath=r'C:\Users\wzy\Documents\python\CSNSSANS'

#readDx
#empty
'''
mergeWS(prepath, empty_run, 'sample')
CloneWorkspace(InputWorkspace='sample',OutputWorkspace='empty_tmp')
LoadInstrument(Workspace='empty_tmp', Filename=prepath+'/paramData/detector_mod.xml', RewriteSpectraMap=True)
#CloneWorkspace(InputWorkspace='bg',OutputWorkspace='empty_tmp')
findCmaskWS('empty_tmp')
ConvertUnits(InputWorkspace='empty_tmp', OutputWorkspace='empty_tmp0', Target='Wavelength', AlignBins=True)


#sample

mergeWS(prepath, sample_run, 'sample')
CloneWorkspace(InputWorkspace='sample',OutputWorkspace='scattering')
CloneWorkspace(InputWorkspace='scattering',OutputWorkspace='sam_tmp')

LoadInstrument(Workspace='sam_tmp', Filename=prepath+'/paramData/detector_mod.xml', RewriteSpectraMap=True)
findCmaskWS('sam_tmp')
ConvertUnits(InputWorkspace='sam_tmp', OutputWorkspace='sam_tmp0', Target='Wavelength', AlignBins=True)
'''



Np=80
wave_rebin='4.6,0.02,7.9'
wave_rebin_all='2,0.02,7.9'
Np=Np/4




CreateSingleValuedWorkspace(OutputWorkspace='v', DataValue=volume)
#calculate sample transmission
mergeWS(prepath, transam_run, 'monitors')
RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTranSam')
mergeWS(prepath, trans_run,'monitors')
RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTran')



LoadInstrument(Workspace='monTran', Filename=prepath+'/paramData/monitors.xml', RewriteSpectraMap=True)
LoadInstrument(Workspace='monTranSam', Filename=prepath+'/paramData/monitors.xml', RewriteSpectraMap=True)



ConvertUnits(InputWorkspace='monTranSam', OutputWorkspace='monTranSam', Target='Wavelength', AlignBins=True)
ConvertUnits(InputWorkspace='monTran', OutputWorkspace='monTran', Target='Wavelength', AlignBins=True)

Rebin(InputWorkspace='monTranSam',OutputWorkspace='monTranSam',Params=wave_rebin)
name=mtd['monTranSam']
sample_trans_m3=(name.readY(1))*1.0

Rebin(InputWorkspace='monTran',OutputWorkspace='monTran',Params=wave_rebin)
name=mtd['monTran']
empty_m3=(name.readY(1))*1.0

wavelength_trans_M3_sample_to_empty=(name.readX(0))*1.0

pc_sample=readProtonCharge(prepath, sample_run)
pc_sample_trans=readProtonCharge(prepath, transam_run)
pc_empty=readProtonCharge(prepath, trans_run)

trans_M3_sample_to_empty=sample_trans_m3/empty_m3

CreateWorkspace(OutputWorkspace='trans_M3_ratio_unfitted', DataX=wavelength_trans_M3_sample_to_empty, DataY=trans_M3_sample_to_empty)

Fit("name=Polynomial,n=1",InputWorkspace='trans_M3_ratio_unfitted',Output='trans_M3_ratio')

name=mtd['trans_M3_ratio_Workspace']
trans_M3_ratio=(name.readY(1))*1.0

CreateWorkspace(OutputWorkspace='trans_M3_ratio', DataX=wavelength_trans_M3_sample_to_empty, DataY=trans_M3_ratio)




scaling_pc_trans=pc_sample_trans/pc_empty;
#scaling_from_m2Counts_to_pc_trans=1;

CreateSingleValuedWorkspace(OutputWorkspace='scaling_trans_pc', DataValue=scaling_pc_trans)

Divide(LHSWorkspace='trans_M3_ratio', RHSWorkspace='scaling_trans_pc', OutputWorkspace='trans_sam', AllowDifferentNumberSpectra=True) 
Rebin(InputWorkspace='trans_sam', OutputWorkspace="trans_sam", Params=wave_rebin)


dlambda=0.02
CreateSingleValuedWorkspace(OutputWorkspace='dlambda', DataValue=dlambda)
Multiply(LHSWorkspace='trans_sam', RHSWorkspace='dlambda', OutputWorkspace='trans_sam', AllowDifferentNumberSpectra=True)
ConvertToDistribution(Workspace='trans_sam')

Multiply(LHSWorkspace='trans_M3_ratio_unfitted', RHSWorkspace='dlambda', OutputWorkspace='trans_sam_unfitted', AllowDifferentNumberSpectra=True)
Divide(LHSWorkspace='trans_sam_unfitted', RHSWorkspace='scaling_trans_pc', OutputWorkspace='trans_sam_unfitted', AllowDifferentNumberSpectra=True) 
Rebin(InputWorkspace='trans_sam_unfitted', OutputWorkspace='trans_sam_unfitted', Params=wave_rebin)
ConvertToDistribution(Workspace='trans_sam_unfitted')




DeleteWorkspace(Workspace='monTran')

'''
#load calibration 
#==========================================
LoadAscii(Filename=prepath+'/paramData/cal_bp_1M.dat', OutputWorkspace='cali', Separator='Automatic', Unit='Wavelength')

ConvertToHistogram(InputWorkspace='cali', OutputWorkspace='cali')

Rebin(InputWorkspace='cali', OutputWorkspace='cali', Params=wave_rebin)


#empty


Rebin(InputWorkspace='empty_tmp0',OutputWorkspace='empty_tmp',Params=wave_rebin)

mergeWS(prepath, empty_run,'monitor2')
RenameWorkspace(InputWorkspace='monitor2',OutputWorkspace='mon_empty')
LoadInstrument(Workspace='mon_empty', Filename=prepath+'/paramData/monitor2_based_on_monitors.xml', RewriteSpectraMap=True)

ConvertUnits(InputWorkspace='mon_empty', OutputWorkspace='empty_m2', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='empty_m2',OutputWorkspace='empty_m2',Params=wave_rebin_all)


if monSUM:
    name=mtd['empty_m2']
    counts=sum(name.readY(0))*1.0
    CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
    Divide(LHSWorkspace='empty_tmp', RHSWorkspace='m2', OutputWorkspace='empty_tmp', AllowDifferentNumberSpectra=True)
else:
    Divide(LHSWorkspace='empty_tmp', RHSWorkspace='empty_m2', OutputWorkspace='empty_tmp', AllowDifferentNumberSpectra=True)

Divide(LHSWorkspace='empty_tmp', RHSWorkspace='cali', OutputWorkspace='empty_tmp', AllowDifferentNumberSpectra=True)



# sample and emptycell
#========================================
#sample


Rebin(InputWorkspace='sam_tmp0',OutputWorkspace='sam_tmp',Params=wave_rebin)


mergeWS(prepath, sample_run,'monitor2')
RenameWorkspace(InputWorkspace='monitor2',OutputWorkspace='sam_m2')
LoadInstrument(Workspace='sam_m2', Filename=prepath+'/paramData/monitor2_based_on_monitors.xml', RewriteSpectraMap=True)

ConvertUnits(InputWorkspace='sam_m2', OutputWorkspace='sam_m2', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='sam_m2',OutputWorkspace='sam_m2',Params=wave_rebin_all)

#
if monSUM:
    name=mtd['sam_m2']
    counts=sum(name.readY(0))*1.0
    CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
    Divide(LHSWorkspace='sam_tmp', RHSWorkspace='m2', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)
    CloneWorkspace(InputWorkspace='sam_tmp',OutputWorkspace='sam_raw')
else:
    Divide(LHSWorkspace='sam_tmp', RHSWorkspace='sam_m2', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)



scaling_pc_sample_scat=pc_sample/pc_empty;
#scaling_from_m2Counts_to_pc_sample_scat=1;

CreateSingleValuedWorkspace(OutputWorkspace='scaling_scat_sample', DataValue=scaling_pc_sample_scat)

Multiply(LHSWorkspace='sam_tmp', RHSWorkspace='scaling_scat_sample', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)

Divide(LHSWorkspace='sam_tmp', RHSWorkspace='cali', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)

ApplyTransmissionCorrection(InputWorkspace='sam_tmp',TransmissionWorkspace='trans_sam',OutputWorkspace='sam_tmp',ThetaDependent=True)

q_rebin='0.01,-0.08,0.4'

Q1D(DetBankWorkspace='empty_tmp', OutputWorkspace='IQ_air', OutputBinning=q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
ReplaceSpecialValues(InputWorkspace='IQ_air', OutputWorkspace='IQ_air', NaNValue=0, InfinityValue=0)

Q1D(DetBankWorkspace='sam_tmp', OutputWorkspace='IQ_sam_raw', OutputBinning=q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
ReplaceSpecialValues(InputWorkspace='IQ_sam_raw', OutputWorkspace='IQ_sam_raw', NaNValue=0, InfinityValue=0)

Minus(LHSWorkspace='IQ_sam_raw', RHSWorkspace='IQ_air',OutputWorkspace='IQ_v')

Divide(LHSWorkspace='IQ_v', RHSWorkspace='v', OutputWorkspace='IQ_v', AllowDifferentNumberSpectra=True)

dlamda=0.5
CreateSingleValuedWorkspace(OutputWorkspace='dlamda_sample', DataValue=dlamda)
Multiply(LHSWorkspace='IQ_v', RHSWorkspace='dlamda_sample', OutputWorkspace='IQ_v', AllowDifferentNumberSpectra=True)
'''
