# reduction without sensitivity and efficiency
from mantid.simpleapi import *
import math
import numpy as np

def mergeWS(prepath, wsList,output):
    for ix in wsList:
        name='RUN'+str(ix).zfill(7)
        LoadNexus(Filename=prepath+'\\'+name+'\\'+output+'.nxs',OutputWorkspace=str(ix))
    for i in range(len(wsList)):
        if len(wsList)== 1:
            CloneWorkspace(InputWorkspace=str(wsList[i]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
        elif wsList[i+1]!=wsList[-1]:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=str(wsList[i+1]))
            DeleteWorkspace(Workspace=str(wsList[i]))
        else:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
            DeleteWorkspace(Workspace=str(wsList[i+1]))
            break


def getMask(xPids, yPids):
    index=[]
    xnum=xPids[1]-xPids[0]+1
    ynum=yPids[1]-yPids[0]+1
    sta=yPids[0]*125+xPids[0]
    for i in range(xnum):
        for j in range(ynum):
            index.append(sta+j*125+i)
    print index
    return index


def findCmaskWS(wsname):
    x=0.0009
    y=-0.00229
    MoveInstrumentComponent(Workspace=wsname, ComponentName='Bank01', X=x, Y=y, RelativePosition=False)
    index=getMask([0,18],[0,119])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)
    index=getMask([105,124],[0,119])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)
    inner=0.048
    xml_inner='<infinite-cylinder id="beam_stop"><centre x="0" y="0" z="0.0" /><axis x="0" y="0" z="1" /><radius val= "'+str(inner)+'" /></infinite-cylinder><algebra val="beam_stop"/>'
    MaskDetectorsInShape(Workspace=wsname, ShapeXML=xml_inner)

    '''
    inner=0.048
    xml_inner='<infinite-cylinder id="beam_area"><centre x="0" y="0" z="0.0" /><axis x="0" y="0" z="1" /><radius val= "'+str(inner)+'" /></infinite-cylinder><algebra val="beam_area"/>'
    '''
    
    index=getMask([60,63],[0,57])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)

def calResolution(M2sample,wavelength, Q):
    L1=11.90-7.45
    #L1, source to sample distance, unit: m 
    L2=4.0
    #L2, sample to detector distance, unit: m 
    d1=1.9/100.0
    #d1,source aperture diameter, unit: m 
    d2=0.6/100.0
    #d2, sample aperture diameter, unit: m 
    d3=1.6/100.0
    #d3, detector res, unit: m   
    detector_min=0.048
    #detector minimum position
    detector_max=0.7
    #detector maximum position
    delta_lamda=0.0057
    #variance of lamda
    
    #Q=mtd['Q'].readX(0)
    
    #wavelength=mtd['wavelength'].readX(0)
    efficiency=[]
    for efficiency_index in range(len(wavelength)):
        efficiency.append(4.7613/1000000.0+0.00054333*wavelength[efficiency_index])
    #M2 efficiency

    Intensity=M2sample
    Intensity_eff=[]
    for Intensity_index in range(len(Intensity)):
        Intensity_eff.append(Intensity[Intensity_index]/efficiency[Intensity_index])
    #Intensity=Intensity/efficiency
    
    sigmaQ=[]
    for Q_value in Q:
        total_intensity=0
        lamda_value_index=0
        sigmaQ_sum=0
        for lamda_value in wavelength:
            Ldet=L2*Q_value*lamda_value/6.28
            
            if detector_min < Ldet < detector_max:
                total_intensity=total_intensity+Intensity_eff[lamda_value_index]
                sigmaQ_sum=sigmaQ_sum+Intensity_eff[lamda_value_index]*math.sqrt((delta_lamda)**2.0+0.25*((L2/L1)**2.0)*((d1/2.0/Ldet)**2.0)+0.25*((1+L2/L1)**2.0)*((d2/2.0/Ldet)**2.0)+1.0/12.0*((d3/Ldet)**2.0))*Q_value
            lamda_value_index=lamda_value_index+1
                      
        sigmaQ.append(sigmaQ_sum/total_intensity)
            
        
        
    return sigmaQ
        


        
def outputIq(prepath, runNo, transRunNo, qName, wName, m2Sample):

    Q=mtd[qName].readX(0)
    Q_shift=[]
    for Q_shift_index in range(len(Q)-1):
        Q_shift.append((Q[Q_shift_index]+Q[Q_shift_index+1])/2.0)
        
    iQ=mtd[qName].readY(0)
    
    sIQ=mtd[qName].readE(0)
     
    wavelength=mtd[wName].readX(0)
    wavelength_shift=[]
    for wavelength_shift_index in range(len(wavelength)-1):
        wavelength_shift.append((wavelength[wavelength_shift_index]+wavelength[wavelength_shift_index+1])/2.0)
    #change wavelength from bin to point
    
    M2sample=mtd[m2Sample].readY(0)
     
    sQ=calResolution(M2sample,wavelength_shift,Q)
     
    f_fp=prepath+'/SANS_'+str(runNo)+'.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Run '+str(runNo)+' and Trans '+str(transRunNo)+' from SANS@CSNS\n')
    #ff.write('%d',% (runNo))
    ff.write('Q (1/A) | IQ (1/cm) | std. dev. I(Q) (1/cm) | sigmaQ (1/A) \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(Q_shift)):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f %.6f \n' % (Q_shift[i],iQ[i],sIQ[i],sQ[i]))
        
def CalculateX(a,b,step):
    c=[]
    for i in range(int((b-a)/step)):
        c.append(a+step*i+step/2)
    return c


def CalculateY(N_pixel,a,b,step):
    lengthY=int((b-a)/step)
    c=np.zeros((N_pixel,lengthY))
    for i in range(N_pixel):
        for j in range(lengthY):
            c[i][j]=1
    return c

def CalculateWavelengthAdj(N_pixel,Y_all,l_min,l_max,l_s,l_e,step):
    
    c=Y_all
    N_s=int((l_s-l_min)/step)
    for i in range(N_pixel):
        for j in range(int((l_e-l_s)/step)):
            c[i][j+N_s]=0
    return c
 
'''
def CalculateY(a,b,step):
    lengthY=int((b-a)/step)
    c=[]
    for j in range(lengthY):
        c[j]=1
    return c

def CalculateWavelengthAdj(Y_all,l_min,l_max,l_s,l_e,step):
    
    c=Y_all
    N_s=int((l_s-l_min)/step)
    for j in range(int((l_e-l_s)/step)):
        c[j+N_s]=0
    return c
'''


#CoNi-T1
sample_run = [1410] 

transam_run = [1420] 

volume=3.14*0.34*0.34*0.162
trans_spline=False

trans_run=[1419]

empty_run=[1390]
Np=200
trans_spline=False
Np=80
lamda_bragg1=4.05-1.5
lamda_bragg2=4.17+3


'''
#CoNi-T2
sample_run = [1411] 

transam_run = [1421] 

volume=3.14*0.34*0.34*0.16
trans_spline=False

trans_run=[1419]

empty_run=[1390]
Np=200
trans_spline=False
Np=80
lamda_bragg1=4.05
lamda_bragg2=4.17
'''


#volume=3.14*0.34*0.34*0.098 #Al_Mg_ht_1
#volume=3.14*0.34*0.34*0.079 #Al_Mg_ht_2
#volume=3.14*0.34*0.34*0.1 #Al_Mg_ht_3
#volume=3.14*0.34*0.34*0.1 #Al_Mg_ht_4
#volume=3.14*0.34*0.34*0.1 #AgBe
#volume=0.0726 #PS-D2O-cell
#volume=0.0236 #BP_62.5K
#q_rebin='0.01,0.002,0.22'


monSUM=True
prepath=r'C:\Users\admin\Documents\python\CSNSSANS'



#readdata

#empty
mergeWS(prepath, empty_run, 'sample')
CloneWorkspace(InputWorkspace='sample',OutputWorkspace='empty_tmp0')
DeleteWorkspace(Workspace='sample')
LoadInstrument(Workspace='empty_tmp0', Filename=prepath+'/paramData/detector.xml', RewriteSpectraMap=True)
#CloneWorkspace(InputWorkspace='bg',OutputWorkspace='empty_tmp')
findCmaskWS('empty_tmp0')
ConvertUnits(InputWorkspace='empty_tmp0', OutputWorkspace='empty_tmp0', Target='Wavelength', AlignBins=True)


#sample
mergeWS(prepath, sample_run, 'sample')
CloneWorkspace(InputWorkspace='sample',OutputWorkspace='sam_tmp0')
DeleteWorkspace(Workspace='sample')
LoadInstrument(Workspace='sam_tmp0', Filename=prepath+'/paramData/detector.xml', RewriteSpectraMap=True)
findCmaskWS('sam_tmp0')
ConvertUnits(InputWorkspace='sam_tmp0', OutputWorkspace='sam_tmp0', Target='Wavelength', AlignBins=True)


CreateSingleValuedWorkspace(OutputWorkspace='v', DataValue=volume)
#calculate sample transmission
mergeWS(prepath, transam_run, 'monitors')
RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTranSam')
mergeWS(prepath, trans_run,'monitors')
RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTran')

'''
mergeWS(prepath, trans_empty_cell,'monitors')
RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTranEmptycell')
mergeWS(prepath, trans_empty_solvent,'monitors')
RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTran_cell_solvent')
'''

LoadInstrument(Workspace='monTran', Filename=prepath+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
LoadInstrument(Workspace='monTranSam', Filename=prepath+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)

'''
LoadInstrument(Workspace='monTran', Filename=prepath+'/paramData/monitors.xml', RewriteSpectraMap=True)
LoadInstrument(Workspace='monTranSam', Filename=prepath+'/paramData/monitors.xml', RewriteSpectraMap=True)
'''
'''
LoadInstrument(Workspace='monTranEmptycell', Filename=prepath+'/paramData/monitors.xml', RewriteSpectraMap=True)
LoadInstrument(Workspace='monTran_cell_solvent', Filename=prepath+'/paramData/monitors.xml', RewriteSpectraMap=True)
'''

ConvertUnits(InputWorkspace='monTranSam', OutputWorkspace='monTranSam', Target='Wavelength', AlignBins=True)
ConvertUnits(InputWorkspace='monTran', OutputWorkspace='monTran', Target='Wavelength', AlignBins=True)

'''
ConvertUnits(InputWorkspace='monTranEmptycell', OutputWorkspace='monTranEmptycell', Target='Wavelength', AlignBins=True)
ConvertUnits(InputWorkspace='monTran_cell_solvent', OutputWorkspace='monTran_cell_solvent', Target='Wavelength', AlignBins=True)
'''




#wave_rebin='1.0,0.003,8.0'
#wave_rebin='1.1,0.05,7.9'
#wave_rebin='1.1,0.005,7.9'
#wave_rebin='1.1,0.02,7.9'
#wave_rebin='2,0.02,7.9'
#wave_rebin='1,0.02,7.9'
wave_rebin1='2.4,0.02,'+str(lamda_bragg1)+' '
wave_rebin2=' '+str(lamda_bragg1)+',0.02,'+str(lamda_bragg2)+''
wave_rebin3=' '+str(lamda_bragg2)+',0.02,7.9'
wave_rebin='2.4,0.02,7.9'
Np=Np/4
wave_rebin_all='1.4,0.02,8.5'
l_min=2.4
l_max=7.9
dl=0.02
l_s=lamda_bragg1
l_e=lamda_bragg2
N_pixel=15000
#Np=Np/4
#wave_rebin='1,0.005,8'

I_all=CalculateX(l_min,l_max,dl)
Y_all=CalculateY(N_pixel,l_min,l_max,dl)
Y_mod=CalculateWavelengthAdj(N_pixel,Y_all,l_min,l_max,l_s,l_e,dl)
#CalculateWavelengthAdj(l_min,l_max,l_s,l_e)
#CalculateWavelengthAdj(l_min,l_max,l_s,l_e)

CreateWorkspace(OutputWorkspace='WavelenghAdj', DataX=I_all, DataY=Y_mod,NSpec=N_pixel,UnitX='Wavelength',Distribution=True)
ConvertToHistogram(InputWorkspace='WavelenghAdj',OutputWorkspace='WavelenghAdj')
LoadInstrument(Workspace='WavelenghAdj', Filename=prepath+'/paramData/detector.xml', RewriteSpectraMap=True)

#wave_rebin='1,0.005,8'

Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam1", Params=wave_rebin1)
Rebin(InputWorkspace='monTran', OutputWorkspace="monTran1", Params=wave_rebin1)
CalculateTransmission(SampleRunWorkspace='monTranSam1', DirectRunWorkspace='monTran1', OutputWorkspace='trans_sam1', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin1, FitMethod='Log', OutputUnfittedData=True)

Rebin(InputWorkspace='trans_sam1', OutputWorkspace="trans_sam1", Params=wave_rebin)

'''
CalculateTransmission(SampleRunWorkspace='monTranEmptycell', DirectRunWorkspace='monTran', OutputWorkspace='trans_empty_cell', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
CalculateTransmission(SampleRunWorkspace='monTran_cell_solvent', DirectRunWorkspace='monTran', OutputWorkspace='trans_cell_solvent', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
'''
#Rebin(InputWorkspace='trans_sam', OutputWorkspace="trans_sam", Params=wave_rebin)

Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam2", Params=wave_rebin2)
Rebin(InputWorkspace='monTran', OutputWorkspace="monTran2", Params=wave_rebin2)
CalculateTransmission(SampleRunWorkspace='monTranSam2', DirectRunWorkspace='monTran2', OutputWorkspace='trans_sam2', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin2, FitMethod='Log', OutputUnfittedData=True)

Rebin(InputWorkspace='trans_sam2', OutputWorkspace="trans_sam2", Params=wave_rebin)


Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam3", Params=wave_rebin3)
Rebin(InputWorkspace='monTran', OutputWorkspace="monTran3", Params=wave_rebin3)
CalculateTransmission(SampleRunWorkspace='monTranSam3', DirectRunWorkspace='monTran3', OutputWorkspace='trans_sam3', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin3, FitMethod='Log', OutputUnfittedData=True)

Rebin(InputWorkspace='trans_sam3', OutputWorkspace="trans_sam3", Params=wave_rebin)

Plus(LHSWorkspace="trans_sam1", RHSWorkspace="trans_sam2", OutputWorkspace="trans_sam")
Plus(LHSWorkspace="trans_sam", RHSWorkspace="trans_sam3", OutputWorkspace="trans_sam")

    
Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam", Params=wave_rebin)

#Rebin(InputWorkspace='trans_sam', OutputWorkspace="trans_sam", Params=wave_rebin)
#DeleteWorkspace(Workspace='monTranSam')
DeleteWorkspace(Workspace='monTran')


#load calibration 
#==========================================
#LoadAscii(Filename=prepath+'/paramData/cal_1M.dat', OutputWorkspace='cal', Separator='Automatic', Unit='Wavelength')
#LoadAscii(Filename=prepath+'/paramData/cal_bp_1M.dat', OutputWorkspace='cali', Separator='Automatic', Unit='Wavelength')
#LoadAscii(Filename=prepath+'/paramData/calibration_20190116_dr.dat', OutputWorkspace='cali', Separator='Automatic', Unit='Wavelength')
LoadAscii(Filename=prepath+'/paramData/calibration_20190116_bgconsider_Qmax0p4.dat', OutputWorkspace='cali', Separator='Automatic', Unit='Wavelength')
#LoadAscii(Filename=prepath+'/paramData/calibration_20190116_bgconsider.dat', OutputWorkspace='cali', Separator='Automatic', Unit='Wavelength')
#ConvertToHistogram(InputWorkspace='cal', OutputWorkspace='cal')

#LoadNexus(Filename=prepath+'\paramData\cal_1M.nxs', OutputWorkspace='cal')
ConvertToHistogram(InputWorkspace='cali', OutputWorkspace='cali')
Rebin(InputWorkspace='cali', OutputWorkspace='cali', Params=wave_rebin)
#Rebin(InputWorkspace='cal', OutputWorkspace='cal', Params=wave_rebin)
#Divide(LHSWorkspace="cal", RHSWorkspace='v', OutputWorkspace="cal", AllowDifferentNumberSpectra=True)

#empty
'''
mergeWS(prepath, empty_run, 'sample')
CloneWorkspace(InputWorkspace='sample',OutputWorkspace='empty_tmp')

LoadInstrument(Workspace='empty_tmp', Filename=prepath+'/paramData/detector.xml', RewriteSpectraMap=True)
#CloneWorkspace(InputWorkspace='bg',OutputWorkspace='empty_tmp')
findCmaskWS('empty_tmp')
ConvertUnits(InputWorkspace='empty_tmp', OutputWorkspace='empty_tmp', Target='Wavelength', AlignBins=True)
'''

Rebin(InputWorkspace='empty_tmp0',OutputWorkspace='empty_tmp',Params=wave_rebin)


mergeWS(prepath, empty_run,'monitor2')
RenameWorkspace(InputWorkspace='monitor2',OutputWorkspace='mon_empty')
#CropWorkspace(InputWorkspace="mon_empty", OutputWorkspace="empty_m2",StartWorkspaceIndex=0, EndWorkspaceIndex=0)
ConvertUnits(InputWorkspace='mon_empty', OutputWorkspace='empty_m2', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='empty_m2',OutputWorkspace='empty_m2',Params=wave_rebin_all)
#RebinToWorkspace(WorkspaceToRebin='empty_m2',WorkspaceToMatch='empty_tmp',OutputWorkspace='empty_m2')

#Divide(LHSWorkspace="empty_m2", RHSWorkspace='cal', OutputWorkspace="empty_m2", AllowDifferentNumberSpectra=True)
#'''
if monSUM:
    name=mtd['empty_m2']
    counts=sum(name.readY(0))*1.0
    CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
    Divide(LHSWorkspace='empty_tmp', RHSWorkspace='m2', OutputWorkspace='empty_tmp', AllowDifferentNumberSpectra=True)
else:
    Divide(LHSWorkspace='empty_tmp', RHSWorkspace='empty_m2', OutputWorkspace='empty_tmp', AllowDifferentNumberSpectra=True)

Divide(LHSWorkspace='empty_tmp', RHSWorkspace='cali', OutputWorkspace='empty_tmp', AllowDifferentNumberSpectra=True)
#Multiply(LHSWorkspace='empty_tmp', RHSWorkspace='cali', OutputWorkspace='empty_tmp', AllowDifferentNumberSpectra=True)


# sample and emptycell
#========================================


#sample
'''
mergeWS(prepath, sample_run, 'sample')
CloneWorkspace(InputWorkspace='sample',OutputWorkspace='scattering')
CloneWorkspace(InputWorkspace='scattering',OutputWorkspace='sam_tmp')

LoadInstrument(Workspace='sam_tmp', Filename=prepath+'/paramData/detector.xml', RewriteSpectraMap=True)
findCmaskWS('sam_tmp')
ConvertUnits(InputWorkspace='sam_tmp', OutputWorkspace='sam_tmp', Target='Wavelength', AlignBins=True)
'''
#Rebin(InputWorkspace='sam_tmp0',OutputWorkspace='sam_tmp',Params=wave_rebin)

Rebin(InputWorkspace='sam_tmp0',OutputWorkspace='sam_tmp',Params=wave_rebin)

mergeWS(prepath, sample_run,'monitor2')
RenameWorkspace(InputWorkspace='monitor2',OutputWorkspace='sam_m2')
#CropWorkspace(InputWorkspace="sam_m2", OutputWorkspace="sam_m2",StartWorkspaceIndex=0, EndWorkspaceIndex=0)
ConvertUnits(InputWorkspace='sam_m2', OutputWorkspace='sam_m2', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='sam_m2',OutputWorkspace='sam_m2',Params=wave_rebin_all)
#Multiply(LHSWorkspace='sam_m2', RHSWorkspace='cal', OutputWorkspace='sam_m2', AllowDifferentNumberSpectra=True)
#'''
if monSUM:
    name=mtd['sam_m2']
    counts=sum(name.readY(0))*1.0
    CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
    Divide(LHSWorkspace='sam_tmp', RHSWorkspace='m2', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)
    CloneWorkspace(InputWorkspace='sam_tmp',OutputWorkspace='sam_raw')
else:
    Divide(LHSWorkspace='sam_tmp', RHSWorkspace='sam_m2', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)

#Rebin(InputWorkspace='cali', OutputWorkspace='cali', Params=wave_rebin)
Divide(LHSWorkspace='sam_tmp', RHSWorkspace='cali', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)
#Multiply(LHSWorkspace='sam_tmp', RHSWorkspace='cali', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)

#Minus(LHSWorkspace='sam_tmp', RHSWorkspace='emptycell_tmp',OutputWorkspace='sam_tmp')

ApplyTransmissionCorrection(InputWorkspace='sam_tmp',TransmissionWorkspace='trans_sam',OutputWorkspace='sam_tmp',ThetaDependent=True)



'''
#emptycell
mergeWS(prepath, empty_cell, 'sample')
CloneWorkspace(InputWorkspace='sample',OutputWorkspace='empty_cell')
CloneWorkspace(InputWorkspace='empty_cell',OutputWorkspace='empty_cell_tmp')
#LoadInstrument(Workspace='empty_cell_tmp', Filename=prepath+'/paramData/detector_mod.xml', RewriteSpectraMap=True)
findCmaskWS('empty_cell_tmp')
ConvertUnits(InputWorkspace='empty_cell_tmp', OutputWorkspace='empty_cell_tmp', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='empty_cell_tmp',OutputWorkspace='empty_cell_tmp',Params=wave_rebin)

mergeWS(prepath, empty_cell,'monitor2')
RenameWorkspace(InputWorkspace='monitor2',OutputWorkspace='empty_cell_m2')
#CropWorkspace(InputWorkspace="sam_m2", OutputWorkspace="sam_m2",StartWorkspaceIndex=0, EndWorkspaceIndex=0)
ConvertUnits(InputWorkspace='empty_cell_m2', OutputWorkspace='empty_cell_m2', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='empty_cell_m2',OutputWorkspace='empty_cell_m2',Params=wave_rebin)
#Multiply(LHSWorkspace='sam_m2', RHSWorkspace='cal', OutputWorkspace='sam_m2', AllowDifferentNumberSpectra=True)

if monSUM:
    name=mtd['empty_cell_m2']
    counts=sum(name.readY(0))*1.0
    CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
    Divide(LHSWorkspace='empty_cell_tmp', RHSWorkspace='m2', OutputWorkspace='empty_cell_tmp', AllowDifferentNumberSpectra=True)
    CloneWorkspace(InputWorkspace='empty_cell_tmp',OutputWorkspace='empty_cell_raw')
else:
    Divide(LHSWorkspace='empty_cell_tmp', RHSWorkspace='empty_cell_m2', OutputWorkspace='empty_cell_tmp', AllowDifferentNumberSpectra=True)

#Rebin(InputWorkspace='cali', OutputWorkspace='cali', Params=wave_rebin)
Divide(LHSWorkspace='empty_cell_tmp', RHSWorkspace='cali', OutputWorkspace='empty_cell_tmp', AllowDifferentNumberSpectra=True)
#Multiply(LHSWorkspace='sam_tmp', RHSWorkspace='cali', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)

Minus(LHSWorkspace='empty_cell_tmp', RHSWorkspace='empty_tmp',OutputWorkspace='empty_cell_tmp_bg_deduction')

ApplyTransmissionCorrection(InputWorkspace='empty_cell_tmp_bg_deduction',TransmissionWorkspace='trans_empty_cell',OutputWorkspace='empty_cell_tmp_bg_deduction_trans_consider',ThetaDependent=True)



#cell_solvent
mergeWS(prepath, cell_solvent, 'sample')
CloneWorkspace(InputWorkspace='sample',OutputWorkspace='empty_cell')
CloneWorkspace(InputWorkspace='cell_solvent',OutputWorkspace='cell_solvent_tmp')
#LoadInstrument(Workspace='empty_cell_tmp', Filename=prepath+'/paramData/detector_mod.xml', RewriteSpectraMap=True)
findCmaskWS('cell_solvent_tmp')
ConvertUnits(InputWorkspace='cell_solvent_tmp', OutputWorkspace='cell_solvent_tmp', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='cell_solvent_tmp',OutputWorkspace='cell_solvent_tmp',Params=wave_rebin)

mergeWS(prepath, cell_solvent,'monitor2')
RenameWorkspace(InputWorkspace='monitor2',OutputWorkspace='cell_solvent_m2')
#CropWorkspace(InputWorkspace="sam_m2", OutputWorkspace="sam_m2",StartWorkspaceIndex=0, EndWorkspaceIndex=0)
ConvertUnits(InputWorkspace='cell_solvent_m2', OutputWorkspace='cell_solvent_m2', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='cell_solvent_m2',OutputWorkspace='cell_solvent_m2',Params=wave_rebin)
#Multiply(LHSWorkspace='sam_m2', RHSWorkspace='cal', OutputWorkspace='sam_m2', AllowDifferentNumberSpectra=True)

if monSUM:
    name=mtd['cell_solvent_m2']
    counts=sum(name.readY(0))*1.0
    CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
    Divide(LHSWorkspace='cell_solvent_tmp', RHSWorkspace='m2', OutputWorkspace='cell_solvent_tmp', AllowDifferentNumberSpectra=True)
    CloneWorkspace(InputWorkspace='cell_solvent_tmp',OutputWorkspace='cell_solvent_raw')
else:
    Divide(LHSWorkspace='cell_solvent_tmp', RHSWorkspace='cell_solvent_m2', OutputWorkspace='cell_solvent_tmp', AllowDifferentNumberSpectra=True)

#Rebin(InputWorkspace='cali', OutputWorkspace='cali', Params=wave_rebin)
Divide(LHSWorkspace='cell_solvent_tmp', RHSWorkspace='cali', OutputWorkspace='cell_solvent_tmp', AllowDifferentNumberSpectra=True)
#Multiply(LHSWorkspace='sam_tmp', RHSWorkspace='cali', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)

Minus(LHSWorkspace='cell_solvent_tmp', RHSWorkspace='empty_tmp',OutputWorkspace='cell_solvent_tmp_bg_deduction')

ApplyTransmissionCorrection(InputWorkspace='cell_solvent_tmp_bg_deduction',TransmissionWorkspace='trans_cell_solvent',OutputWorkspace='cell_solvent_tmp_bg_deduction_trans_consider',ThetaDependent=True)
'''

q_rebin='0.01,-0.08,0.4'
q_rebin='0.01,-0.08,0.1,-0.5,0.4'
#q_rebin='0.01,0.01,0.4'
#q_rebin='0.01,0.005,0.8'

Q1D(DetBankWorkspace='empty_tmp', OutputWorkspace='IQ_air', OutputBinning=q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
ReplaceSpecialValues(InputWorkspace='IQ_air', OutputWorkspace='IQ_air', NaNValue=0, InfinityValue=0)
Q1D(DetBankWorkspace='sam_tmp', OutputWorkspace='IQ_sam_raw', OutputBinning=q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
ReplaceSpecialValues(InputWorkspace='IQ_sam_raw', OutputWorkspace='IQ_sam_raw', NaNValue=0, InfinityValue=0)

'''
Q1D(DetBankWorkspace='empty_tmp', OutputWorkspace='IQ_air', OutputBinning=q_rebin, WavePixelAdj='WavelenghAdj', AccountForGravity=False, SolidAngleWeighting=True)
ReplaceSpecialValues(InputWorkspace='IQ_air', OutputWorkspace='IQ_air', NaNValue=0, InfinityValue=0)
Q1D(DetBankWorkspace='sam_tmp', OutputWorkspace='IQ_sam_raw', OutputBinning=q_rebin, WavePixelAdj='WavelenghAdj', AccountForGravity=False, SolidAngleWeighting=True)
ReplaceSpecialValues(InputWorkspace='IQ_sam_raw', OutputWorkspace='IQ_sam_raw', NaNValue=0, InfinityValue=0)
'''





'''
Q1D(DetBankWorkspace='empty_cell_tmp_bg_deduction_trans_consider', OutputWorkspace='IQ_empty_cell', OutputBinning=q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
ReplaceSpecialValues(InputWorkspace='IQ_empty_cell', OutputWorkspace='IQ_empty_cell', NaNValue=0, InfinityValue=0)
Q1D(DetBankWorkspace='cell_solvent_tmp_bg_deduction_trans_consider', OutputWorkspace='IQ_cell_solvent', OutputBinning=q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
ReplaceSpecialValues(InputWorkspace='IQ_cell_solvent', OutputWorkspace='IQ_cell_solvent', NaNValue=0, InfinityValue=0)
'''
'''
Minus(LHSWorkspace='IQ_sam_raw', RHSWorkspace='IQ_empty_cell',OutputWorkspace='IQ_pure_solute_and_solvent')
Minus(LHSWorkspace='IQ_cell_solvent', RHSWorkspace='IQ_empty_cell',OutputWorkspace='IQ_pure_solvent')

CreateSingleValuedWorkspace(OutputWorkspace='volume_fraction_solvent', DataValue=volume_fraction_solvent)
Multiply(LHSWorkspace='IQ_pure_solvent', RHSWorkspace='volume_fraction_solvent', OutputWorkspace='IQ_pure_solvent_normalized', AllowDifferentNumberSpectra=True)

Minus(LHSWorkspace='IQ_pure_solute_and_solvent', RHSWorkspace='IQ_pure_solvent_normalized',OutputWorkspace='IQ_pure_solute')

Divide(LHSWorkspace='IQ_pure_solute', RHSWorkspace='v', OutputWorkspace='IQ_v', AllowDifferentNumberSpectra=True)
'''

Minus(LHSWorkspace='IQ_sam_raw', RHSWorkspace='IQ_air',OutputWorkspace='IQ_v')

Divide(LHSWorkspace='IQ_v', RHSWorkspace='v', OutputWorkspace='IQ_v', AllowDifferentNumberSpectra=True)


dlamda=0.01/0.02
CreateSingleValuedWorkspace(OutputWorkspace='dlamda_sample', DataValue=dlamda)
Multiply(LHSWorkspace='IQ_v', RHSWorkspace='dlamda_sample', OutputWorkspace='IQ_v', AllowDifferentNumberSpectra=True)

#outputIq(prepath, sample_run, transam_run, 'IQ_v', 'trans_sam','monTranSam')

#LoadAscii(Filename=prepath+'/paramData/batespoly_ISIS_62p5K.dat', OutputWorkspace='theory_ISIS', Separator='Automatic', Unit='MomentumTransfer')

#LoadAscii(Filename=prepath+'/paramData/batesPoly_ansto_200K.dat', OutputWorkspace='theory_ansto', Separator='Automatic', Unit='MomentumTransfer')



'''
ApplyTransmissionCorrection(InputWorkspace='empty_tmp',TransmissionWorkspace='trans_sam',OutputWorkspace='empty_tmp_trans_consider',ThetaDependent=True)
Q1D(DetBankWorkspace='empty_tmp_trans_consider', OutputWorkspace='IQ_empty_tmp', OutputBinning=q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
ReplaceSpecialValues(InputWorkspace='IQ_empty_tmp', OutputWorkspace='IQ_empty_tmp', NaNValue=0, InfinityValue=0)



Divide(LHSWorkspace='IQ_empty_tmp', RHSWorkspace='v', OutputWorkspace='IQ_v_empty_tmp', AllowDifferentNumberSpectra=True)

dlamda=0.005
CreateSingleValuedWorkspace(OutputWorkspace='dlamda_sample', DataValue=dlamda)
Multiply(LHSWorkspace='IQ_v_empty_tmp', RHSWorkspace='dlamda_sample', OutputWorkspace='IQ_v_empty_tmp', AllowDifferentNumberSpectra=True)



ApplyTransmissionCorrection(InputWorkspace='sam_tmp',TransmissionWorkspace='trans_sam',OutputWorkspace='sam_tmp_trans_consider',ThetaDependent=True)
Q1D(DetBankWorkspace='sam_tmp_trans_consider', OutputWorkspace='IQ_sam_tmp_trans_consider', OutputBinning=q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
ReplaceSpecialValues(InputWorkspace='IQ_sam_tmp_trans_consider', OutputWorkspace='IQ_sam_tmp_trans_consider', NaNValue=0, InfinityValue=0)

Divide(LHSWorkspace='IQ_sam_tmp_trans_consider', RHSWorkspace='v', OutputWorkspace='IQ_v_sam_tmp_trans_consider', AllowDifferentNumberSpectra=True)

dlamda=0.005
CreateSingleValuedWorkspace(OutputWorkspace='dlamda_sample', DataValue=dlamda)
Multiply(LHSWorkspace='IQ_v_sam_tmp_trans_consider', RHSWorkspace='dlamda_sample', OutputWorkspace='IQ_v_sam_tmp_trans_consider', AllowDifferentNumberSpectra=True)


Q1D(DetBankWorkspace='empty_tmp', OutputWorkspace='IQ_empty_tmp_trans_not_consider', OutputBinning=q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
ReplaceSpecialValues(InputWorkspace='IQ_empty_tmp_trans_not_consider', OutputWorkspace='IQ_empty_tmp_trans_not_consider', NaNValue=0, InfinityValue=0)

Divide(LHSWorkspace='IQ_empty_tmp_trans_not_consider', RHSWorkspace='v', OutputWorkspace='IQ_v_empty_tmp_trans_not_consider', AllowDifferentNumberSpectra=True)

dlamda=0.005
CreateSingleValuedWorkspace(OutputWorkspace='dlamda_sample', DataValue=dlamda)
Multiply(LHSWorkspace='IQ_v_empty_tmp_trans_not_consider', RHSWorkspace='dlamda_sample', OutputWorkspace='IQ_v_empty_tmp_trans_not_consider', AllowDifferentNumberSpectra=True)

Minus(LHSWorkspace='IQ_v_sam_tmp_trans_consider', RHSWorkspace='IQ_v_empty_tmp_trans_not_consider',OutputWorkspace='IQ_v_sam_empty_tmp_trans_not_consider')
'''

'''
dq_inverse=1000
CreateSingleValuedWorkspace(OutputWorkspace='dq_inverse', DataValue=dq_inverse)
Multiply(LHSWorkspace='IQ_v', RHSWorkspace='dq_inverse', OutputWorkspace='IQ_v', AllowDifferentNumberSpectra=True)
dlamda_ratio=0.5
CreateSingleValuedWorkspace(OutputWorkspace='dlamda_ratio', DataValue=dlamda_ratio)
Multiply(LHSWorkspace='IQ_v', RHSWorkspace='dlamda_ratio', OutputWorkspace='IQ_v', AllowDifferentNumberSpectra=True)
'''

#LoadAscii(Filename=prepath+'/paramData/batesPoly_ISIS_200K.dat', OutputWorkspace='theory_raw', Separator='Automatic', Unit='MomentumTransfer')
#ConvertToHistogram(InputWorkspace='theory_raw', OutputWorkspace='theory_hist')
#Rebin(InputWorkspace='theory_hist', OutputWorkspace='theory_hist', Params=q_rebin)

#ReplaceSpecialValues(InputWorkspace='norm', OutputWorkspace='norm', NaNValue=0, InfinityValue=0)

