﻿# reduction without sensitivity and efficiency
from mantid.simpleapi import *
import math

import numpy as np
import os

# find the folder (proposal No.) for the defined RunNo.
def my_finds(fileFolder,prepath):
    #matchs=[ ]
    
    for currentFolder in os.listdir(prepath):
        addRootFolder=os.path.join(prepath, currentFolder)
        if os.path.isdir(addRootFolder+'/'+fileFolder):
            matchs=currentFolder
            break    
    
    return str(matchs)

# load the nexus file to internal memory, also can combine different RunNo. into one variable
def mergeWS(prepath, wsList,output):
    for ix in wsList:
        name='RUN'+str(ix).zfill(7)
        realProposal=my_finds(name,prepath)
        LoadNexus(Filename=prepath+'/'+realProposal+'/'+name+'/'+output+'.nxs',OutputWorkspace=str(ix))
        
        #LoadNexus(Filename=prepath+'/'+name+'/'+output+'.nxs',OutputWorkspace=str(ix))
    for i in range(len(wsList)):
        if len(wsList)== 1:
            CloneWorkspace(InputWorkspace=str(wsList[i]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
        elif wsList[i+1]!=wsList[-1]:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=str(wsList[i+1]))
            DeleteWorkspace(Workspace=str(wsList[i]))
        else:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
            DeleteWorkspace(Workspace=str(wsList[i+1]))
            break
            
            
            
# transfer the detector position from (x,y) to (index), which means 2D to 1D
def getMask(xPids, yPids):
    index=[]
    xnum=xPids[1]-xPids[0]+1
    ynum=yPids[1]-yPids[0]+1
    sta=yPids[0]*125+xPids[0]
    for i in range(xnum):
        for j in range(ynum):
            index.append(sta+j*125+i)
    print index
    return index

# draw the mask region in the main detector
# this function is substituted by load mask file in the IQ reduction
# the function can be used to output mask file
def findCmaskWS(wsname):
    x=-0.00071
    y=-0.00128
    MoveInstrumentComponent(Workspace=wsname, ComponentName='Bank01', X=x, Y=y, RelativePosition=False)
    index=getMask([0,18],[0,119])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)
    index=getMask([105,124],[0,119])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)
    inner=0.048
    xml_inner='<infinite-cylinder id="beam_stop"><centre x="0" y="0" z="0.0" /><axis x="0" y="0" z="1" /><radius val= "'+str(inner)+'" /></infinite-cylinder><algebra val="beam_stop"/>'
    MaskDetectorsInShape(Workspace=wsname, ShapeXML=xml_inner)

    '''
    inner=0.048
    xml_inner='<infinite-cylinder id="beam_area"><centre x="0" y="0" z="0.0" /><axis x="0" y="0" z="1" /><radius val= "'+str(inner)+'" /></infinite-cylinder><algebra val="beam_area"/>'
    '''
    '''
    index=getMask([60,63],[0,57])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)
    '''

# the resolution calculation at each Q point
# will average the Qresolution from different neutron wavelength

## sample aperture diameter will be modified due to the experiment in the future

def calResolution(M2sample,wavelength, Q):
    L1=11.90-7.45
    #L1, source to sample distance, unit: m 
    L2=4.0
    #L2, sample to detector distance, unit: m 
    d1=1.9/100.0
    #d1,source aperture diameter, unit: m 
    d2=0.6/100.0
    #d2, sample aperture diameter, unit: m 
    d3=1.6/100.0
    #d3, detector res, unit: m   
    detector_min=0.024
    #detector minimum position
    detector_max=0.7
    #detector maximum position
    delta_lamda=0.0057
    #variance of lamda
    
    #Q=mtd['Q'].readX(0)
    
    #wavelength=mtd['wavelength'].readX(0)
    efficiency=[]
    for efficiency_index in range(len(wavelength)):
        efficiency.append(4.7613/1000000.0+0.00054333*wavelength[efficiency_index])
    #M2 efficiency

    Intensity=M2sample
    Intensity_eff=[]
    for Intensity_index in range(len(Intensity)):
        Intensity_eff.append(Intensity[Intensity_index]/efficiency[Intensity_index])
    #Intensity=Intensity/efficiency
    
    sigmaQ=[]
    for Q_value in Q:
        total_intensity=0
        lamda_value_index=0
        sigmaQ_sum=0
        for lamda_value in wavelength:
            Ldet=L2*Q_value*lamda_value/6.28
            
            if detector_min < Ldet < detector_max:
                total_intensity=total_intensity+Intensity_eff[lamda_value_index]
                sigmaQ_sum=sigmaQ_sum+Intensity_eff[lamda_value_index]*math.sqrt((delta_lamda)**2.0+0.25*((L2/L1)**2.0)*((d1/2.0/Ldet)**2.0)+0.25*((1+L2/L1)**2.0)*((d2/2.0/Ldet)**2.0)+1.0/12.0*((d3/Ldet)**2.0))*Q_value
            lamda_value_index=lamda_value_index+1
                      
        sigmaQ.append(sigmaQ_sum/total_intensity)
            
        
        
    return sigmaQ

# output IQ file for normal sample (only sample and emptybeam are considered)
# this function is slightly different with the same function in reduction.py
def outputIq(prepath, Q_rebin, Wavelength_rebin, emptyNo, runNo, emptyTransNo, transRunNo, qName, wName, m2Sample,fileName,thickness,diameter, trans_spline, Smooth_Ns, trans_raw):

    Q=mtd[qName].readX(0)
    Q_shift=[]
    for Q_shift_index in range(len(Q)-1):
        Q_shift.append((Q[Q_shift_index]+Q[Q_shift_index+1])/2.0)
        
    iQ=mtd[qName].readY(0)
    
    sIQ=mtd[qName].readE(0)
     
    wavelength=mtd[wName].readX(0)
    wavelength_shift=[]
    for wavelength_shift_index in range(len(wavelength)-1):
        wavelength_shift.append((wavelength[wavelength_shift_index]+wavelength[wavelength_shift_index+1])/2.0)
    #change wavelength from bin to point
    
    M2sample=mtd[m2Sample].readY(0)
     
    sQ=calResolution(M2sample,wavelength_shift,Q)
     
    #f_fp=prepath+'/SANS_'+str(runNo)+'_'+str(fileName)+'.dat'     
    f_fp=prepath+'/SANS_IQ_RunNo'+str(runNo)+'_Final_SubEmpty.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Run '+str(runNo)+' and Trans '+str(transRunNo)+' from SANS@CSNS\n')
    ff.write('#EmptyRun '+str(emptyNo)+' and Trans '+str(emptyTransNo)+ '\n')
    ff.write('#Sample diameter '+str(diameter)+' mm and sample thickness '+str(thickness)+' mm\n')
    
    ff.write('#Q_rebin is '+str(Q_rebin)+'\n')
    ff.write('#Wavelength_rebin is '+str(Wavelength_rebin)+'\n')
    
    if (trans_raw == True):
        ff.write('#Trans fitting method is Raw '+'\n')
    elif (trans_spline == True):
        ff.write('#Trans fitting method is Smooth '+'\n')
        ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
    else:
        ff.write('#Trans fitting method is Linear (In the function, FitMethod is Log)'+'\n')
    
    #ff.write('%d',% (runNo))
    ff.write('Q (1/A) | IQ (1/cm) | std. dev. I(Q) (1/cm) | sigmaQ (1/A) \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(Q_shift)):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f %.6f \n' % (Q_shift[i],iQ[i],sIQ[i],sQ[i]))

# output transmission file for normal sample (only sample and emptybeam are considered)
def outputTrans(prepath, transRunNo, emptyRunNo, trans_unfitted, trans_fitted,fileName, wave_rebin, trans_spline, Smooth_Ns, trans_raw):

    
    
    trans_sam_fitted=mtd[trans_fitted].readY(0)
    trans_sam_unfitted=mtd[trans_unfitted].readY(0)
    lambda_all= mtd[trans_fitted].readX(0)
     
    f_fp=prepath+'/SANS_Trans_RunNo_'+str(transRunNo)+'.dat'     
    ff=open(f_fp, "w") 
    
    #ff.write('#Trans '+str(transRunNo)+' and Empty '+str(emptyRunNo)+' from SANS@CSNS\n')
    ff.write('#Trans '+str(transRunNo)+' and Empty '+str(emptyRunNo)+' from SANS@CSNS\n')
    ff.write('#Wavelength_rebin is '+str(wave_rebin)+'\n')
    if (trans_raw == True):
        ff.write('#Trans fitting method is Raw '+'\n')
    elif (trans_spline == True):
        ff.write('#Trans fitting method is Smooth '+'\n')
        ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
    else:
        ff.write('#Trans fitting method is Linear (In the function, FitMethod is Log)'+'\n')
    
    #The thickness and diameter of the sample are not shown in the Trans file, 
    #since the calculation of transmission won't consider them.
    #ff.write('#Sample diameter '+str(diameter)+' cm and sample thickness '+str(thickness)+' cm\n')
    
    
    #ff.write('%d',% (runNo))
    ff.write('lambda (AA) | Trans_unfitted | Trans_fitted \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(lambda_all)-1):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f  \n' % (lambda_all[i],trans_sam_unfitted[i],trans_sam_fitted[i]))
        
        

        
        
def outputTransAll(prepath, transRunNo, emptyRunNo, trans_unfitted,fileName,wave_rebin_all):

    
    
    trans_sam_unfitted=mtd[trans_unfitted].readY(0)
    lambda_all= mtd[trans_unfitted].readX(0)
     
    f_fp=prepath+'/SANS_TransAll_RunNo_'+str(transRunNo)+'.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Trans '+str(transRunNo)+' and Empty '+str(emptyRunNo)+' from SANS@CSNS\n')
    ff.write('#Wavelength_rebin_all is '+str(wave_rebin_all)+'\n')
    
    #The thickness and diameter of the sample are not shown in the Trans file, 
    #since the calculation of transmission won't consider them.
    #ff.write('#Sample diameter '+str(diameter)+' cm and sample thickness '+str(thickness)+' cm\n')
    
    #ff.write('%d',% (runNo))
    ff.write('lambda (AA) | Trans_unfitted  \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(lambda_all)-1):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f  \n' % (lambda_all[i],trans_sam_unfitted[i]))



def outputCalibrationRatio(prepath, Q_rebin, Wavelength_rebin,EmptybeamScatt_run,EmptybeamTrans_run,SamScatt_run,SamTrans_run,thickness,diameter, trans_spline, Smooth_Ns, trans_raw, maskFile,calFile, cvalue):

    #f_fp=prepath+'/SANS_'+str(runNo)+'_'+str(fileName)+'.dat'     
    f_fp=prepath+'/SANS_CalibrationRatio_'+str(SamScatt_run)+'.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Filename of maskfile is '+str(maskFile)+'.\n')
    ff.write('#Filename of calibration file is '+str(calFile)+'.\n')
    
    ff.write('#RunNo for this standard sample.\n')
    
    ff.write('#Run '+str(SamScatt_run)+' and Trans '+str(SamTrans_run)+' from SANS@CSNS\n')
    ff.write('#EmptyRun '+str(EmptybeamScatt_run)+' and Trans '+str(EmptybeamTrans_run)+ '\n')
    
    ff.write('#Sample diameter '+str(diameter)+' mm and sample thickness '+str(thickness)+' mm\n')
    
    ff.write('#Q_rebin is '+str(Q_rebin)+'\n')
    ff.write('#Wavelength_rebin is '+str(Wavelength_rebin)+'\n')
    
    if (trans_raw == True):
        ff.write('#Trans fitting method is Raw '+'\n')
    elif (trans_spline == True):
        ff.write('#Trans fitting method is Smooth '+'\n')
        ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
    else:
        ff.write('#Trans fitting method is Linear (In the function, FitMethod is Log)'+'\n')
    
    #ff.write('%d',% (runNo))
    ff.write('#The averaged ratio of IQ is %.4f.\n'  %(cvalue) )
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     






# #### Input parameters

# username

username='wangzhiyuan'

#RunNo at this standard sample measurement

#emptybeam exp No.
EmptybeamScatt_run=[3984]
EmptybeamTrans_run=[3997]

#sample exp No.
SamScatt_run=[3983]
SamTrans_run=[3965]


#sample property
thickness=1.14 #mm
diameter=6.8 #mm
volume=3.14*diameter/20*diameter/20*thickness/10
CreateSingleValuedWorkspace(OutputWorkspace='volume', DataValue=volume)

#for Monitor2 normalization, if it will sum all the M2 counts or it's wavelength-dependent
#for True value, M2 counts for all
monSUM=True

#transmission fitting algorithm, using smooth fit(true) or linear fit(false)
trans_spline=True
#if smooth fit, define the number of points for smooth
Smooth_Ns=10
#if true, raw data instead of fitted data will be given 
trans_raw=False


#wavelength range for all
#this wavelength range will be used for M2 normalization
#also will be used to output transmission raw data
wavelength_rebin_all_min=1
wavelength_rebin_all_step=0.01
wavelength_rebin_all_max=10
wavelength_rebin_all=str(wavelength_rebin_all_min)+','+str(wavelength_rebin_all_step)+','+str(wavelength_rebin_all_max)

#wavelength range
wavelength_rebin_min=1.2
wavelength_rebin_step=0.01
wavelength_rebin_max=9.5
wavelength_rebin=str(wavelength_rebin_min)+','+str(wavelength_rebin_step)+','+str(wavelength_rebin_max)


#Q range for IQ reduction
#the step can be positive or nagative:
#while positive value means the delta Q between adjacent Q point is constant,
#negative value means the ratio between adjacent Q point is constant
Q_rebin_min=0.02
Q_rebin_step=-0.08
Q_rebin_max=0.3
Q_rebin=str(Q_rebin_min)+','+str(Q_rebin_step)+','+str(Q_rebin_max)


# * small wavelength range mode, will be used to select the Q range from the effective range of detector and specified wavelength range
# detector_min=0.048 #m
# detector_max=0.6 #m
# L2=4 #m, distance from sample to detector
# Q_rebin_min=6.28/(wavelength_rebin_IQ_max)*detector_min/L2
# Q_rebin_step=-0.08
# Q_rebin_max=6.28/(wavelength_rebin_IQ_min)*detector_max/L2
# Q_rebin=str(Q_rebin_min)+','+str(Q_rebin_step)+','+str(Q_rebin_max)




# the path for files loading and saving
# please change the path to your own path
# the path should not include any non-English characters
# '/' in linux or macOS should convert to '\' in windows

#the path to load data files
prepath='/csns_workspace/CSNS/'+username+'/instrument_data'

#the path to load parameter files
#please pay attention to the files will be loaded in this path,
#the file name may be changed in different cycle
prepath_param='/csns_workspace/CSNS/'+username+'/Documents/paramData'


#monitors.xml file name
monitorsFile='monitors_201901.xml'

#detector.xml file name
detectorFile='detector.xml'

#mask.xml file name
maskFile='mask_20191031_3cm.xml'

#calibration file name
calFile='calibration_20191031_6p8mm.dat'

#the path to save files
savePrepath='/csns_workspace/CSNS/'+username+'/Documents/reducedFiles'

#IQ data for calibration file
IQFile='IQ_'+calFile


# ###### for standard sample

# #### transmission calculation

#load monitor2 and monitor3 files and convert to monitors variable

#transam_run
mergeWS(prepath, SamTrans_run, 'monitor2')
wname=mtd['monitor2']
tmp=wname.readX(0)
x=[]
for i in range(len(tmp)-1):
    xvalue=(tmp[i+1]-tmp[i])/2.0+tmp[i]
    x.append(xvalue)
tmp=wname.readY(0)
y=[]
for iy in tmp:
    y.append(iy)
mergeWS(prepath, SamTrans_run, 'monitor3')
wname=mtd['monitor3']
tmp=wname.readY(0)
for iy in tmp:
    y.append(iy)
CreateWorkspace(DataX=x,DataY=y,NSpec=2,UnitX='TOF',OutputWorkspace='monitors')
RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='mon_SamTrans')
ConvertToHistogram(InputWorkspace='mon_SamTrans',OutputWorkspace='mon_SamTrans')

#tran_run
mergeWS(prepath, EmptybeamTrans_run, 'monitor2')
wname=mtd['monitor2']
tmp=wname.readX(0)
x=[]
for i in range(len(tmp)-1):
    xvalue=(tmp[i+1]-tmp[i])/2.0+tmp[i]
    x.append(xvalue)
tmp=wname.readY(0)
y=[]
for iy in tmp:
    y.append(iy)
mergeWS(prepath, EmptybeamTrans_run, 'monitor3')
wname=mtd['monitor3']
tmp=wname.readY(0)
for iy in tmp:
    y.append(iy)
CreateWorkspace(DataX=x,DataY=y,NSpec=2,UnitX='TOF',OutputWorkspace='monitors')
RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='mon_EmptybeamTrans')
ConvertToHistogram(InputWorkspace='mon_EmptybeamTrans',OutputWorkspace='mon_EmptybeamTrans')

#load monitors files to the internal memory

#mergeWS(prepath, EmptybeamTrans_run,'monitors')
#RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='mon_EmptybeamTrans')
#mergeWS(prepath, SamTrans_run, 'monitors')
#RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='mon_SamTrans')

#load the monitors xml file including the distance parameters for each monitor,
#which is used to convert TOF data into wavelength data
LoadInstrument(Workspace='mon_EmptybeamTrans', Filename=prepath_param+'/'+monitorsFile, RewriteSpectraMap=True)
LoadInstrument(Workspace='mon_SamTrans', Filename=prepath_param+'/'+monitorsFile, RewriteSpectraMap=True)

#convert TOF data into wavelength data
ConvertUnits(InputWorkspace='mon_EmptybeamTrans', OutputWorkspace='mon_EmptybeamTrans', Target='Wavelength', AlignBins=True)
ConvertUnits(InputWorkspace='mon_SamTrans', OutputWorkspace='mon_SamTrans', Target='Wavelength', AlignBins=True)

#copy the monitors data for all wavelength range
CloneWorkspace(InputWorkspace='mon_SamTrans', OutputWorkspace='mon_SamTrans_All')
CloneWorkspace(InputWorkspace='mon_EmptybeamTrans', OutputWorkspace='mon_EmptybeamTrans_All')

#output fitted or raw transmission file of sample at specified wavelength range
Rebin(InputWorkspace='mon_SamTrans', OutputWorkspace="mon_SamTrans", Params=wavelength_rebin)
Rebin(InputWorkspace='mon_EmptybeamTrans', OutputWorkspace="mon_EmptybeamTrans", Params=wavelength_rebin)
CalculateTransmission(SampleRunWorkspace='mon_SamTrans', DirectRunWorkspace='mon_EmptybeamTrans', OutputWorkspace='trans_sam', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wavelength_rebin, FitMethod='Log', OutputUnfittedData=True)

if trans_spline:
    SmoothData(InputWorkspace="trans_sam_unfitted",OutputWorkspace="trans_sam",NPoints=Smooth_Ns)

if trans_raw:
    CloneWorkspace(InputWorkspace="trans_sam_unfitted",OutputWorkspace="trans_sam")

#output fitted or raw transmission file of sample at all wavelength range
Rebin(InputWorkspace='mon_EmptybeamTrans_All', OutputWorkspace="mon_EmptybeamTrans_All", Params=wavelength_rebin_all)
Rebin(InputWorkspace='mon_SamTrans_All', OutputWorkspace="mon_SamTrans_All", Params=wavelength_rebin_all)
CalculateTransmission(SampleRunWorkspace='mon_SamTrans_All', DirectRunWorkspace='mon_EmptybeamTrans_All', OutputWorkspace='trans_sam_All', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wavelength_rebin_all, FitMethod='Log', OutputUnfittedData=True)
CloneWorkspace(InputWorkspace="trans_sam_All_unfitted",OutputWorkspace="trans_sam_All")

#the commented code is to output the transmission file 
#transmission file can also be output by another python file, 
#since sometimes the wavelength step for IQ reduction and transmission reduction may be different
'''
#output the Transmission file to the folder
outputTrans(savePrepath, SamTrans_run, EmptybeamTrans_run, "trans_sam_unfitted", "trans_sam", fileName, wavelength_rebin, trans_spline, Smooth_Ns, trans_raw)
outputTransAll(savePrepath, SamTrans_run, EmptybeamTrans_run, "trans_sam_All_unfitted", fileName, wavelength_rebin_all)
'''


# #### IQ reduction

#load main detector Nexus file for emptybeam
mergeWS(prepath, EmptybeamScatt_run, 'sample')
CloneWorkspace(InputWorkspace='sample',OutputWorkspace='Emptybeam_2D_TOF')
DeleteWorkspace(Workspace='sample')
LoadInstrument(Workspace='Emptybeam_2D_TOF', Filename=prepath_param+'/'+detectorFile, RewriteSpectraMap=True)
#the findCmaskWS
#findCmaskWS('Emptybeam_2D_TOF')
#Load mask file
mask=LoadMask(Instrument=prepath_param+'/'+detectorFile, InputFile=prepath_param+'/'+maskFile)
MaskDetectors(Workspace='Emptybeam_2D_TOF', MaskedWorkspace=mask)
ConvertUnits(InputWorkspace='Emptybeam_2D_TOF', OutputWorkspace='Emptybeam_2D_wavelength', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='Emptybeam_2D_wavelength',OutputWorkspace='Emptybeam_2D_wavelength',Params=wavelength_rebin)


#load the M2 counts from emptybeam
mergeWS(prepath, EmptybeamScatt_run,'monitor2')
RenameWorkspace(InputWorkspace='monitor2',OutputWorkspace='Emptybeam_M2_TOF')
ConvertUnits(InputWorkspace='Emptybeam_M2_TOF', OutputWorkspace='Emptybeam_M2_wavelength', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='Emptybeam_M2_wavelength',OutputWorkspace='Emptybeam_M2_wavelength',Params=wavelength_rebin_all)

#normalize the main detector counts by Monitor2 counts
if monSUM:
    #normalize by the total counts of M2
    name=mtd['Emptybeam_M2_wavelength']
    counts=sum(name.readY(0))*1.0
    CreateSingleValuedWorkspace(OutputWorkspace='Emptybeam_m2',DataValue=counts)
    Divide(LHSWorkspace='Emptybeam_2D_wavelength', RHSWorkspace='Emptybeam_m2', OutputWorkspace='Emptybeam_2D_wavelength_normalized', AllowDifferentNumberSpectra=True)
else:
    #normalize by the counts of M2 with wavelength dependent
    #this module is linked with the calibration file, 
    #we haven't used this module since the flux is not high, 
    #while the calibration file is only output from monSUM=True
    Rebin(InputWorkspace='Emptybeam_M2_wavelength',OutputWorkspace='Emptybeam_M2_wavelength',Params=wave_rebin)
    Divide(LHSWorkspace='Emptybeam_2D_wavelength', RHSWorkspace='Emptybeam_M2_wavelength', OutputWorkspace='Emptybeam_2D_wavelength_normalized', AllowDifferentNumberSpectra=True)


#loading main detector Nexus file for sample 
mergeWS(prepath, SamScatt_run, 'sample')
CloneWorkspace(InputWorkspace='sample',OutputWorkspace='Sam_2D_TOF')
DeleteWorkspace(Workspace='sample')
LoadInstrument(Workspace='Sam_2D_TOF', Filename=prepath_param+'/'+detectorFile, RewriteSpectraMap=True)
#findCmaskWS('Sam_2D_TOF')
mask=LoadMask(Instrument=prepath_param+'/'+detectorFile, InputFile=prepath_param+'/'+maskFile)
MaskDetectors(Workspace='Sam_2D_TOF', MaskedWorkspace=mask)
ConvertUnits(InputWorkspace='Sam_2D_TOF', OutputWorkspace='Sam_2D_wavelength', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='Sam_2D_wavelength',OutputWorkspace='Sam_2D_wavelength',Params=wavelength_rebin)

mergeWS(prepath, SamScatt_run,'monitor2')
RenameWorkspace(InputWorkspace='monitor2',OutputWorkspace='Sam_M2_TOF')
ConvertUnits(InputWorkspace='Sam_M2_TOF', OutputWorkspace='Sam_M2_wavelength', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='Sam_M2_wavelength',OutputWorkspace='Sam_M2_wavelength',Params=wavelength_rebin_all)


if monSUM:
    name=mtd['Sam_M2_wavelength']
    counts=sum(name.readY(0))*1.0
    CreateSingleValuedWorkspace(OutputWorkspace='Sam_m2',DataValue=counts)
    Divide(LHSWorkspace='Sam_2D_wavelength', RHSWorkspace='Sam_m2', OutputWorkspace='Sam_2D_wavelength_normalized', AllowDifferentNumberSpectra=True)
else:
    Rebin(InputWorkspace='Sam_M2_wavelength',OutputWorkspace='Sam_M2_wavelength',Params=wave_rebin)
    Divide(LHSWorkspace='Sam_2D_wavelength', RHSWorkspace='Sam_M2_wavelength', OutputWorkspace='Sam_2D_wavelength_normalized', AllowDifferentNumberSpectra=True)

#normalize sample scattering from transmission
ApplyTransmissionCorrection(InputWorkspace='Sam_2D_wavelength_normalized',TransmissionWorkspace='trans_sam',OutputWorkspace='Sam_2D_wavelength_normalized',ThetaDependent=True)


#load calibration file for absolute intensity
#please be careful to choose right calibration file,
#including the time of calibration, and the sample aperture diameter
LoadAscii(Filename=prepath_param+'/'+calFile, OutputWorkspace='cali', Separator='Automatic', Unit='Wavelength')
ConvertToHistogram(InputWorkspace='cali', OutputWorkspace='cali')
Rebin(InputWorkspace='cali', OutputWorkspace='cali', Params=wavelength_rebin)

#normalize the detector counts by calibration file
Divide(LHSWorkspace='Emptybeam_2D_wavelength_normalized', RHSWorkspace='cali', OutputWorkspace='Emptybeam_2D_wavelength_normalized', AllowDifferentNumberSpectra=True)
Divide(LHSWorkspace='Sam_2D_wavelength_normalized', RHSWorkspace='cali', OutputWorkspace='Sam_2D_wavelength_normalized', AllowDifferentNumberSpectra=True)

#normalize the detector counts by sample volume
Divide(LHSWorkspace='Emptybeam_2D_wavelength_normalized', RHSWorkspace='volume', OutputWorkspace='Emptybeam_2D_wavelength_normalized', AllowDifferentNumberSpectra=True)
Divide(LHSWorkspace='Sam_2D_wavelength_normalized', RHSWorkspace='volume', OutputWorkspace='Sam_2D_wavelength_normalized', AllowDifferentNumberSpectra=True)

#convert 2D detector-wavelength counts to IQ 1D
Q1D(DetBankWorkspace='Emptybeam_2D_wavelength_normalized', OutputWorkspace='IQ_Emptybeam', OutputBinning=Q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
ReplaceSpecialValues(InputWorkspace='IQ_Emptybeam', OutputWorkspace='IQ_Emptybeam', NaNValue=0, InfinityValue=0)
Q1D(DetBankWorkspace='Sam_2D_wavelength_normalized', OutputWorkspace='IQ_Sam', OutputBinning=Q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
ReplaceSpecialValues(InputWorkspace='IQ_Sam', OutputWorkspace='IQ_Sam', NaNValue=0, InfinityValue=0)

Minus(LHSWorkspace='IQ_Sam', RHSWorkspace='IQ_Emptybeam',OutputWorkspace='IQ_Sam_SubEmpty')

#outputIq(savePrepath, Q_rebin, wavelength_rebin, EmptybeamScatt_run, SamScatt_run, EmptybeamTrans_run, SamTrans_run, 'IQ_Sam_SubEmpty', 'trans_sam', 'mon_SamTrans', fileName, thickness, diameter, trans_spline, Smooth_Ns, trans_raw)




#load IQ corresponding to the calibration file, and rebin
LoadAscii(Filename=prepath_param+'/'+IQFile, OutputWorkspace='IQ_Sam_SubEmpty_Cal_Raw', Separator='Automatic', Unit='MomentumTransfer')
ConvertToHistogram(InputWorkspace='IQ_Sam_SubEmpty_Cal_Raw', OutputWorkspace='IQ_Sam_SubEmpty_Cal_Raw')
Rebin(InputWorkspace='IQ_Sam_SubEmpty_Cal_Raw', OutputWorkspace='IQ_Sam_SubEmpty_Cal_Raw_Rebin', Params=Q_rebin)
SplineInterpolation(WorkspaceToMatch='IQ_Sam_SubEmpty_Cal_Raw_Rebin',WorkspaceToInterpolate='IQ_Sam_SubEmpty_Cal_Raw',OutputWorkspace='IQ_Sam_SubEmpty_Cal_Raw_2')
Divide(LHSWorkspace='IQ_Sam_SubEmpty_Cal_Raw_2',RHSWorkspace='IQ_Sam_SubEmpty',OutputWorkspace='ratio')

name=mtd['ratio']
value=name.readY(0)
sumvalue=0
num=0
cvalue=0
    
for i in range(len(value)):
    if value[i]>0:
        sumvalue=sumvalue+value[i]
        num=num+1
    else:
        continue
#cvalue divided by 2 so that factor number won't be used at reduction.py
cvalue=sumvalue/num

outputCalibrationRatio(savePrepath, Q_rebin, wavelength_rebin,EmptybeamScatt_run,EmptybeamTrans_run,SamScatt_run,SamTrans_run,thickness,diameter, trans_spline, Smooth_Ns, trans_raw, maskFile,calFile, cvalue)

