from mantid.simpleapi import *
import json
import time
import sys
import numpy
import subprocess
import os
import glob
import shutil
import re
from xml.etree import ElementTree as ET
import DAQParser

def parseMonitor(runno, monitor, filename, pixels,num):
    _cmd="./crop_main.exe "+runno+' '+monitor+' '+filename+' '+str(pixels)+' '+str(num)
    subprocess.check_call(_cmd, shell=True)
    while not os.path.exists("/home/mantid/workspace/cropTime/"+runno+"/monitor/"+monitor+"_"+str(num)+".dat"):
        print "no data in ", " /home/mantid/workspace/cropTime/"+runno+"/monitor/"+monitor+"_"+str(num)+".dat"
        time.sleep(10)
    print "finish parse monitor binary data for ", monitor
    

def getMonitor(prepath, monitor, pixels,num):
    mpid=[1+i for i in xrange(pixels)]
    tof=[0+i for i in xrange(40001)]
    f0=open(prepath+"/monitor/"+monitor+"_"+str(num)+".dat")
    _tmpv=json.load(f0)
    value=[]
    for ix in _tmpv:
        for iy in ix:
            value.append(iy)
    print "======================================="
    print sum(value),monitor,num
    if len(mpid)*(len(tof)-1)==len(value):
        return mpid, tof ,value   
    else:
        sys.exit()


def getSequenceMonitor(runNo):
    rawpath='/opt/CSNSDATA/TS1/BL01/Monitor/tmp-run/RUN'+str(runNo).zfill(7)
    binfile=glob.glob(os.path.join(rawpath, '*.bin'))
    index=[]
    num=len(binfile)
    for i in range(num):
        strindex=binfile[i].find('.')
        index.append(int(binfile[i][strindex-3:strindex]))
    index.sort()
    print '======================='
    print index
    nameList=[]
    for i in range(num):
        nameList.append(rawpath+'/BL01_RUN'+str(runNo).zfill(7)+'_M2_FILE'+str(index[i]).zfill(3)+'.bin')
    print nameList
    return nameList

def createMonNexus(runNo,num, mfilename):
    runno="RUN"+str(runNo).zfill(7)
    prepath=sys.path[0]+"/"+runno
    prepath2=sys.path[0]
    if os.path.exists(prepath):
        pass
    else:
        os.mkdir(prepath)
    tmp=prepath+'/monitor'
    if os.path.exists(tmp):
        pass
    else:
        os.mkdir(tmp)

    monitor='monitor2'
    pixels=1024
    rawpath="/opt/CSNSDATA/TS1/BL01/Monitor/tmp-run/"+runno

    print "monitor file: ",mfilename 
    parseMonitor(runno,'monitor2',mfilename,pixels,num)
    mpid=[]
    mtof=[]
    mvalue=[]
    mpid, mtof, mvalue = getMonitor(prepath, monitor, pixels,num)
    LoadCSNSRaw(OutputWorkspace=monitor, PixelID_bank=[0,1], TimeOfFlight_bank=[0,8], Counts_bank=[1,1], PixelID_monitor=mpid, TimeOfFlight_monitor=mtof, Counts_monitor=mvalue)
    #CloneWorkspace(InputWorkspace=monitor+'_2', OutputWorkspace='m2')
    SumSpectra(InputWorkspace=monitor+'_2', OutputWorkspace='m2')
    LoadInstrument(Workspace="m2", Filename=prepath2+'/paramData/'+monitor+'.xml', RewriteSpectraMap='True')
    SaveNexus(InputWorkspace='m2', Filename=prepath+'/'+monitor+'_'+str(num)+'.nxs')


if __name__=="__main__":

    runNo = 7157
    mList=getSequenceMonitor(runNo)
    for i in range(len(mList)):
        createMonNexus(runNo, i,mList[i])

    path=sys.path[0]+'/RUN'+str(runNo).zfill(7)
    _cmd="rm -rf "+path+"/monitor"
    #subprocess.check_call(_cmd, shell=True)
