from mantid.simpleapi import *
import json
import time
import sys
import numpy
import subprocess
import os
import glob
import shutil
import re
from xml.etree import ElementTree as ET
import DAQParser

def parseDaq(prepath,runno, T0start, T0end):
    rawpath="/opt/CSNSDATA/TS1/BL01/DAQ/"+runno+"/"
    xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
    xmlfile=xmllist[0]
    root = ET.parse(xmlfile)
    for i in range(10):
        subprocess.check_call("python drone.py "+runno+" "+str(i+1)+" "+prepath+" "+str(T0start)+" "+str(T0end)+" &", shell=True)
    for i in range(10):
        while not os.path.exists(prepath+"/module/module"+str(i+1)+".dat"):
            time.sleep(5)

    
def getDaq(prepath, moduleList):
    root = ET.parse('8mm_configure.xml')
    tof  = root.find('tofInformation')
    m_tofstart= int(tof.attrib['tofstart'])
    m_tofstep = int(tof.attrib['tofstep'])
    m_tofbins = int(tof.attrib['tofbin'])
    tof = [m_tofstart+i*m_tofstep for i in xrange(m_tofbins+1)]
    mpid=[]
    value=[]
    for name in moduleList:
        for item in root.findall('type/component'):
            if name== item.attrib['name']:
                m_moduleinfo = item.attrib
                idstart = int(m_moduleinfo['idstart'])
                idsize  = int(m_moduleinfo['pixels'])
                _tmp = [idstart+i*1 for i in xrange(idsize)]
                for num in _tmp:
                    mpid.append(num)
        f0=open(prepath+'/module/'+name+'.dat',"r")
        _tmpv=json.load(f0)
        v=[]
        for ix in _tmpv:
            for iy in ix:
                v.append(iy)
        for num in v:
            value.append(num)
    if len(mpid)*(len(tof)-1)==len(value):
        return mpid, tof ,value   
    else:
        #_cmd="rm -rf "+prepath+"/tmpData"
        #subprocess.check_call(_cmd, shell=True)
        sys.exit()

def createDetNexus(runNo, T0start, T0end,num):
    runno="RUN"+str(runNo).zfill(7)
    prepath=sys.path[0]+"/"+runno
    prepath2=sys.path[0]
    if os.path.exists(prepath):
        pass
    else:
        os.mkdir(prepath)
    tmp=prepath+'/module'
    if os.path.exists(tmp):
        _cmd="rm -rf "+prepath+"/module/*"
        subprocess.check_call(_cmd, shell=True)
    else:
        os.mkdir(tmp)
    moduleList=['module1','module2','module3','module4','module5','module6','module7','module8','module9','module10']
    rawpath="/opt/CSNSDATA/TS1/BL01/DAQ/"+runno
    xmlfile=glob.glob(os.path.join(rawpath, '*.xml'))
    if len(xmlfile)==0:
        print "no data in ",runno, " for DAQ"
    else:
        parseDaq(prepath, runno, T0start, T0end)
        spid, stof, svalue = getDaq(prepath, moduleList)
        LoadCSNSRaw(OutputWorkspace="sample", PixelID_bank=spid, TimeOfFlight_bank=stof, Counts_bank=svalue, PixelID_monitor=[0,1], TimeOfFlight_monitor=[0,16], Counts_monitor=[1,1])
        LoadInstrument(Workspace="sample_1", Filename=prepath2+'/paramData/detector.xml', RewriteSpectraMap='True')
        SaveNexus(InputWorkspace='sample_1', Filename=prepath+'/sample_'+str(num)+'.nxs')

    _cmd="rm -rf "+prepath+"/module"
    subprocess.check_call(_cmd, shell=True)


def getT0(runno, localStart, localEnd):
    runnum=str(runno).zfill(7)
    rawpath="/opt/CSNSDATA/TS1/BL01/DAQ/RUN"+runnum+"/"
    xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
    xmlfile=xmllist[0]
    root = ET.parse(xmlfile)
    ns=''
    nsmatch=re.match('\{.*\}', root.getroot().tag)
    if nsmatch:
        ns=nsmatch.group(0)
    for item in root.findall(ns+'T0'):
        item = item.find(ns+'files')
        filename = item.findtext(ns+'file')
    filepath=rawpath+filename
    T0Start, T0End=DAQParser.parseT0(filepath, localStart, localEnd)
    return T0Start, T0End


def getStartEndTime(runNo):
    rawpath="/opt/CSNSDATA/TS1/BL01/Control/RUN"+str(runNo).zfill(7)
    xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
    xmlfile=xmllist[0]
    root = ET.parse(xmlfile)
    ns=''
    nsmatch=re.match('\{.*\}', root.getroot().tag)
    if nsmatch:
        ns=nsmatch.group(0)
    for item in root.findall(ns+'NXentry'):
        #item = item.find(ns+'start_time_utc')
        tmp = item.findtext(ns+'start_time_utc')
        tmp=tmp.split()
        startTime=tmp[0]+"T"+tmp[1]
        #startTime.replace(" ","T")
        tmp = item.findtext(ns+'end_time_utc')
        tmp=tmp.split()
        endTime=tmp[0]+"T"+tmp[1]
        #endTime.replace(" ","T")
    
    return startTime, endTime



if __name__=="__main__":


    runNo = 7167
    step=1200
    startList=[]
    endList=[]
    localStart, localEnd=getStartEndTime(runNo)
    start=DAQParser.local2utc(localStart)
    end=DAQParser.local2utc(localEnd)
    totTime=end-start
    bins=totTime/step
    bins=1
    print bins
    for j in range(bins):
        utcStart=start+step*j
        utcEnd=utcStart+step-1
        T0Start, T0End=getT0(runNo, utcStart, utcEnd)
        print "================================="
        print 'j=',j,';',utcStart, utcEnd
        print T0Start, T0End
        startList.append(T0Start)
        endList.append(T0End)
        createDetNexus(runNo, T0Start, T0End, j)
    print startList, endList
