#from mantid.simpleapi import *
import time
import sys
import subprocess
import os
import glob
import shutil
import re
import threading
from xml.etree import ElementTree as ET
import logging
from logging.handlers import RotatingFileHandler


class myLog():
    def __init__(self):
        logging.basicConfig(level=logging.DEBUG,
                format='%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s',
                datefmt='%a, %d %b %Y %H:%M:%S',
                filename=os.getcwd()+'/recNxs.log',
                filemode='a')

        self.logger = logging.getLogger('auto')
        hdlr = RotatingFileHandler(os.getcwd()+'/recNxs.log', maxBytes=100, backupCount=0)

    def getLog(self):
        return self.logger


class recNexus(threading.Thread):
    def __init__(self, logger, beamline):
        threading.Thread.__init__(self)
        self.logger = logger
        self.curPath = os.getcwd()
        self.beamline = beamline
        if(self.beamline == "BL18"):
            self.moduleList=['module521', 'module531', 'module532', 'module533', 'module541', 'module542', 'module543', 'module623', 'module631', 'module632', 'module633', 'module641', 'module642', 'module643','module322', 'module331', 'module332', 'module333', 'module341', 'module342', 'module343','module422', 'module431', 'module432', 'module433', 'module441', 'module442', 'module443','module123', 'module131', 'module132', 'module133','module141','module142','module143','module221','module231', 'module232', 'module233','module241','module242','module243']
            self.daqCompletePath = "/opt/CSNSDATA/TS1/"+self.beamline+"/DAQ/complete/"
        elif(self.beamline == "BL01"):
            self.moduleList=["module1","module2","module3","module4","module5","module6","module7","module8","module9","module10"]
            self.daqCompletePath = "/opt/CSNSDATA/TS1/"+self.beamline+"/DAQ/Completed/"

        else:
            self.moduleList=["module1"]
            self.daqCompletePath = "/opt/CSNSDATA/TS1/"+self.beamline+"/DAQ/complete/"

        self.ctrlPath = "/opt/CSNSDATA/TS1/"+self.beamline+"/Control/"
        self.monCompletePath ="/opt/CSNSDATA/TS1/"+self.beamline+"/Monitor/complete/Monitor2/"
        self.databasePath = os.getcwd()+"/database/"

    def getFolderList(self, path):
        pattern="^RUN[0-9]{7}"
        runNo=[]
        for dirpath, dirnames, files in os.walk(path):
            for dirname in dirnames:
                if re.match(pattern, dirname):
                    runNo.append(int(dirname[3:]))
        runNo.sort()
        return runNo

    def getFileList(self, path):
        pattern="^RUN[0-9]{7}"
        runNo=[]
        runStr=glob.glob(path+'RUN*')
        for r in runStr:
            try:
                runNo.append(int(r[-7:]))
            except:
                pass
        runNo.sort()
        return runNo

    def createRunFolder(self):
        if os.path.exists(self.curPath+"/"+self.runNo):
            pass
        else:
            os.mkdir(self.curPath+"/"+self.runNo)

    def recAlg(self):
        _cmd="./gen_nexus "+self.runNo
        subprocess.check_call(_cmd, shell=True)
        while not os.path.exists(self.curPath+"/"+self.runNo+"/complete.dat"):
            time.sleep(10)

    def setNxsData(self):
        _cmd="rm -rf "+self.curPath+"/"+self.runNo+"/complete.dat"
        subprocess.check_call(_cmd, shell=True)

        f=open(self.curPath+"/database/"+self.runNo, "w")
        f.close()
        try:
            f=open("complete", "w")
            f.close()
        except:
            pass
        #'''
        transPath = "transfer@10.1.26.157:/home/transfer/nexus/CSNSDATA/TS1/"+self.beamline+"/"
        _cmd = 'scp -r '+self.runNo+' '+transPath
        subprocess.check_call(_cmd, shell=True)
        transPath = transPath+self.runNo
        _cmd = 'scp complete  '+transPath
        subprocess.check_call(_cmd, shell=True)
        _cmd = 'rm -rf '+self.runNo
        subprocess.check_call(_cmd, shell=True)
        #'''
    def process(self):
        ctrlRunList = self.getFolderList(self.ctrlPath)
        daqCompleteRunList = self.getFileList(self.daqCompletePath)
        monCompleteRunList = self.getFileList(self.monCompletePath)
        databaseList = self.getFileList(self.databasePath)

        newList =[] 
        for cRun in ctrlRunList:
            if cRun>6379 and cRun not in databaseList:
                if cRun in daqCompleteRunList:
                    if cRun in monCompleteRunList:
                        newList.append(cRun)
                    else:
                        self.logger.debug("missed by monitor: "+str(cRun))
                else:
                    self.logger.debug("missed by daq: "+str(cRun))
        self.logger.debug("to be reconstructed: "+str(newList))
         
        #newList=[6783]
        for run in newList:
            self.runNo = "RUN"+str(run).zfill(7)
            self.createRunFolder()
            try:    
                self.recAlg()
                self.setNxsData()
            except:
                pass
        #sys.exit()

    def run(self):
        while True:
            self.process()
            time.sleep(60.0)


if __name__=="__main__":
    _log=myLog()
    logger= _log.getLog()

    threadDaemon = recNexus(logger, "BL01")
    threadDaemon.setDaemon(True)
    threadDaemon.start()
    threadDaemon.join()
    sys.exit()


