#!/usr/bin/env python
# -*- coding:utf-8 -*-
# author: H.L. TIAN 2017
import DroNECore
import sys
import os
import glob
import re


SANSgroup={}
SANSgroup['module1']='module10'
SANSgroup['module2']='module9'
SANSgroup['module3']='module8'
SANSgroup['module4']='module7'
SANSgroup['module5']='module6'
SANSgroup['module6']='module5'
SANSgroup['module7']='module4'
SANSgroup['module8']='module3'
SANSgroup['module9']='module2'
SANSgroup['module10']='module1'

if __name__ == "__main__":

    runnum = sys.argv[1] 
    modulenum = int(sys.argv[2])
    prepath = sys.argv[3] 
    m_modulename = 'module'+str(modulenum)

    T0start=int(sys.argv[4])
    T0end=int(sys.argv[5])

    from xml.etree import ElementTree as ET
    root = ET.parse('configure.xml')
    tof  = root.find('tofInformation')
    factor = 80  # 25ns to 1us
    m_tofstart= int(tof.attrib['tofstart'])*factor
    m_tofstep = int(tof.attrib['tofstep'])*factor
    m_tofbins = int(tof.attrib['tofbin'])
    
    threshold = root.find('threshold')
    m_th_up   = int(threshold.attrib['up_value'])
    m_th_down = int(threshold.attrib['down_value'])

    for item in root.findall('type/component'):
        if m_modulename== item.attrib['name']:
            m_moduleinfo = item.attrib
    idstart = int(m_moduleinfo['idstart'])
    idsize  = int(m_moduleinfo['pixels'])

    histname = prepath+'/tmpData/'+SANSgroup[m_modulename]+'.dat'

    #parse daq xml
    rawpath="/opt/CSNSDATA/TS1/BL01/DAQ/"+runnum+"/"

    xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
    xmlfile=xmllist[0]
    root = ET.parse(xmlfile)
    #print root.tag
    ns=''
    nsmatch=re.match('\{.*\}', root.getroot().tag)
    if nsmatch:
        ns=nsmatch.group(0)
        print ns


    #ns="{http://xmlns.csns.ihep.ac.cn/xml/ns/descriptor}"
    for item in root.findall(ns+'module'):
        #print item
        if item.attrib['id']== str(modulenum):
            #print "modulenum: ",num
            item = item.find(ns+'files')
            filename = item.findtext(ns+'file')
    print filename



    #import Sniper
    task = DroNECore.DroNE("task")
    task.asTop()
    task.setLogLevel(0)

    import DataSvc
    import CtrlSvc
    #task.property("svcs").append("MRDataSvc/DataSvc")
    task.property("svcs").append("SANSDataSvc/DataSvc")
    task.property("svcs").append("CtrlSvc")
    task.property("svcs").append("He3TRawDataInputSvcV02/DataInputSvc")
    task.property("svcs").append("FileInputSvc/DataProvideSvc")
    iDat = task.find("DataSvc")
    iSvc = task.find("DataInputSvc")
    iPvd = task.find("DataProvideSvc")

    #filelist=["./rawData/BL01_RUN167_MODULE01_FILE001_20180111101729.dat"]
    iPvd.property("InputFile").set(rawpath+filename)
    iSvc.property("BuffSize").set(10000)

    iSvc.show()
    iPvd.show()

    import Algorithms
    task.property("algs").append("SANSHe3TRecAlg")
    task.property("algs").append("SANSHe3TMapAlg")
    task.property("algs").append("RunningInfAlg")
    task.property("algs").append("SaveMatrix2JSONAlg") 

    #calpath=prepath+"/factor_m"+str(modulenum)+".txt"
    #print calpath
    iRec = task.find("SANSHe3TRecAlg")
    iRec.property("threshold_down").set(m_th_down)
    iRec.property("threshold_up").set(m_th_up)
    #iRec.property("calibration").set(calpath)
    iRec.property("modulenum").set(modulenum)
    iRec.property('T0start').set(T0start)
    iRec.property('T0end').set(T0end)


    iMap = task.find("SANSHe3TMapAlg")
    iMap.property("pixel_size").set(int(idsize))
    iMap.show()
    
    iRun = task.find("RunningInfAlg")
    iRun.property("TofStart").set(m_tofstart)
    iRun.property("TofStep").set(m_tofstep)
    iRun.property("TofBins").set(m_tofbins)

    iMatrix = task.find("SaveMatrix2JSONAlg")
    iMatrix.property("PIDStart").set(idstart)
    iMatrix.property("PIDSize").set(idsize)
    iMatrix.property("OutputFileName").set(histname)

    task.setEvtMax(-1)
    #task.initialize()
    task.run()

