from mantid.simpleapi import *
import json
import time
import sys
import numpy
import subprocess
import os
import matplotlib.pyplot as plt
import glob
import shutil
import re
from xml.etree import ElementTree as ET
import logging
from logging.handlers import RotatingFileHandler

class myLog():
    def __init__(self):
        logging.basicConfig(level=logging.DEBUG,
                format='%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s',
                datefmt='%a, %d %b %Y %H:%M:%S',
                filename=os.getcwd()+'/nxs.log',
                filemode='a')

        self.logger = logging.getLogger('BL01nxs')
        hdlr = RotatingFileHandler(os.getcwd()+'/nxs.log', maxBytes=100, backupCount=0)

    def getLog(self):
        return self.logger


def parseDaq(prepath,runno, logger):
    rawpath="/opt/CSNSDATA/TS1/BL01/DAQ/"+runno+"/"
    xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
    if len(xmllist)== 0:
        logger.warning('no xml file in DAQ for '+runno)
        judge=False
    else:
        try:
            xmlfile=xmllist[0]
            root = ET.parse(xmlfile)
            judge=True
        except:
            logger.warning('error in parse xml for daq for '+runno)
            _cmd="cp "+xmlfile+" /home/mantid/workspace/BL01nexus/"+runno+'/'
            subprocess.check_call(_cmd, shell=True)
            judge=False
    if judge:
        for i in range(10):
            subprocess.check_call("python drone_"+psize+".py "+runno+" "+str(i+1)+" "+prepath+" &", shell=True)
        for i in range(10):
            while not os.path.exists(prepath+"/tmpData/module"+str(i+1)+".dat"):
                #print "no data"
                time.sleep(5)
            #print "module",str(i+1)," exists!"
    else:
        pass

def parseMonitor(prepath, runno, monitor, pixels):
    _cmd="./main "+runno+" "+monitor+" "+str(pixels)+" "+prepath
    subprocess.check_call(_cmd, shell=True)
    while not os.path.exists(prepath+"/tmpData/"+monitor+".dat"):
        #print "no data"
        time.sleep(5)
    #print "finish parse monitor binary data for ", monitor
    
def getDaq(prepath, moduleList, psize,logger):
    root = ET.parse(psize+'_configure.xml')
    tof  = root.find('tofInformation')
    m_tofstart= int(tof.attrib['tofstart'])
    m_tofstep = int(tof.attrib['tofstep'])
    m_tofbins = int(tof.attrib['tofbin'])
    tof = [m_tofstart+i*m_tofstep for i in xrange(m_tofbins+1)]
    mpid=[]
    value=[]
    for name in moduleList:
        for item in root.findall('type/component'):
            if name== item.attrib['name']:
                m_moduleinfo = item.attrib
                idstart = int(m_moduleinfo['idstart'])
                idsize  = int(m_moduleinfo['pixels'])
                _tmp = [idstart+i*1 for i in xrange(idsize)]
                for num in _tmp:
                    mpid.append(num)
        f0=open(prepath+'/tmpData/'+name+'.dat',"r")
        _tmpv=json.load(f0)
        v=[]
        for ix in _tmpv:
            for iy in ix:
                v.append(iy)
        for num in v:
            value.append(num)
    if len(mpid)*(len(tof)-1)==len(value):
        return mpid, tof ,value   
    else:
        logger.warning("daq data match failed!")
        #_cmd="rm -rf "+prepath+"/tmpData"
        #subprocess.check_call(_cmd, shell=True)
        sys.exit()

def getMonitor(prepath, monitor, pixels, logger):
    mpid=[1+i for i in xrange(pixels)]
    tof=[0+i for i in xrange(40001)]
    f0=open(prepath+"/tmpData/"+monitor+".dat")
    _tmpv=json.load(f0)
    value=[]
    for ix in _tmpv:
        for iy in ix:
            value.append(iy)
    if len(mpid)*(len(tof)-1)==len(value):
        return mpid, tof ,value   
    else:
        logger.warning("monitor data match failed!")
        #_cmd="rm -rf "+prepath+"/tmpData"
        #subprocess.check_call(_cmd, shell=True)
        sys.exit()

def checkNewRun():
    prepath=sys.path[0]
    rawpath="/opt/CSNSDATA/TS1/BL01/DAQ/Completed"
    daqList=os.listdir(rawpath)
    runList=os.listdir(prepath)
    newList=[]
    for name in daqList:
        if name[0]=='R' and name[3]=='0':
            if name in runList:
                pass
            else:
                newList.append(name)
    return newList


# usage: python hist_nxs.py banknum 
def createNexus(psize, runNo):
    runno="RUN"+str(runNo).zfill(7)

    prepath=sys.path[0]+"/"+runno
    prepath2=sys.path[0]
    if os.path.exists(prepath):
        pass
    else:
        os.mkdir(prepath)
    tmp=prepath+'/tmpData'
    if os.path.exists(tmp):
        _cmd="rm -rf "+prepath+"/tmpData/*"
        subprocess.check_call(_cmd, shell=True)
    else:
        os.mkdir(tmp)
    #print 'mkdir ', tmp 
    moduleList=['module1','module2','module3','module4','module5','module6','module7','module8','module9','module10']
    #rawpath="/opt/CSNSDATA/TS1/BL01/DAQ/"+runno
    #xmlfile=glob.glob(os.path.join(rawpath, '*.xml'))
    #if len(xmlfile)==0:
    #    print "no data in ",runno, " for DAQ"
    #else:
    parseDaq(prepath, runno, psize, logger)
    try:
        spid, stof, svalue = getDaq(prepath, moduleList, psize, logger)
        LoadCSNSRaw(OutputWorkspace="sample", PixelID_bank=spid, TimeOfFlight_bank=stof, Counts_bank=svalue, PixelID_monitor=[0,1], TimeOfFlight_monitor=[0,16], Counts_monitor=[1,1])
        LoadInstrument(Workspace="sample_1", Filename=prepath2+'/paramData/'+psize+'_detector.xml', RewriteSpectraMap='True')
        SaveNexus(InputWorkspace='sample_1', Filename=prepath+'/sample.nxs')
        logger.debug('finish save nexus for detector! ')
    except:
        logger.warning("no daq data!")
    monitorList=['Monitor1','Monitor2','Monitor3']
    monitorPixel={}
    monitorPixel['monitor1']=1024
    monitorPixel['monitor2']=1
    monitorPixel['monitor3']=1
    for mname in monitorList:
        rawpath="/opt/CSNSDATA/TS1/BL01/Monitor/Histogram/"+mname+"/"+runno
        binfile=glob.glob(os.path.join(rawpath, '*.bin'))
        if len(binfile)==0:
            print "no data in ",runno, " for ",mname
        else:
            mname = mname.lower()
            pixels=int(monitorPixel[mname])
            parseMonitor(prepath, runno, mname, pixels)
            mpid=[]
            mtof=[]
            mvalue=[]
            mpid, mtof, mvalue = getMonitor(prepath, mname, pixels, logger)
            # mantid data processing
            LoadCSNSRaw(OutputWorkspace=mname, PixelID_bank=[0,1], TimeOfFlight_bank=[0,8], Counts_bank=[1,1], PixelID_monitor=mpid, TimeOfFlight_monitor=mtof, Counts_monitor=mvalue)
            CloneWorkspace(InputWorkspace=mname+'_2', OutputWorkspace=mname )
            LoadInstrument(Workspace=mname+"_2", Filename=prepath2+'/paramData/'+mname+'.xml', RewriteSpectraMap='True')
            SaveNexus(InputWorkspace=mname+'_2', Filename=prepath+'/'+mname+'.nxs')
        try:
            ConjoinWorkspaces(InputWorkspace1='monitor2',InputWorkspace2='monitor3',CheckOverlapping=False)
            LoadInstrument(Workspace='monitor2', Filename=prepath2+'/paramData/monitors.xml', RewriteSpectraMap='True') 
            SaveNexus(InputWorkspace='monitor2', Filename=prepath+'/monitors.nxs')
        except:
            pass
    
    logger.debug('finish save nexus for monitors')
    _cmd="rm -rf "+prepath+"/tmpData"
    subprocess.check_call(_cmd, shell=True)

    f=open("./database/"+runno, "w")
    f.close()
    try:
        f=open("complete", "w")
        f.close()
    except:
        pass

    _cmd = 'scp -r '+runno+' transfer@10.1.26.157:/home/transfer/nexus/CSNSDATA/TS1/BL01/'
    subprocess.check_call(_cmd, shell=True)

    _cmd = 'scp complete  transfer@10.1.26.157:/home/transfer/nexus/CSNSDATA/TS1/BL01/'+runno
    subprocess.check_call(_cmd, shell=True)

#!/usr/bin/python
import sys
import time
import os
import threading

class main(threading.Thread):
    def __init__(self,psize, logger):
        threading.Thread.__init__(self)
        self.logger=logger
        self.psize=psize
    def getRunNoList(self):
        dir="/opt/CSNSDATA/TS1/BL01/Control/"
        pattern="^RUN[0-9]{7}"
        runNo=[]

        for dirpath, dirnames, files in os.walk(dir):
            for dirname in dirnames:
                if re.match(pattern, dirname):
                    runNo.append(int(dirname[3:]))

        runNo.sort()
        return runNo

    def getNexusRunList(self):
        dir=os.getcwd()+"/database/"
        pattern="^RUN[0-9]{7}"
        runNo=[]

        runStr=glob.glob(dir+'RUN*')

        for r in runStr:
            runNo.append(int(r[-7:]))
            
        '''
        for dirpath, dirnames, files in os.walk(dir):
            for dirname in dirnames:
                if re.match(pattern, dirname):
                     runNo.append(int(dirname[3:]))
        '''
        runNo.sort()
        return runNo

    def getDaqCompleteList(self):
        dir="/opt/CSNSDATA/TS1/BL01/DAQ/Completed/"
        pattern="^RUN[0-9]{7}"
        runNo=[]

        runStr=glob.glob(dir+'RUN*')

        for r in runStr:
            if r[-7:].isdigit():
                runNo.append(int(r[-7:]))
            else:
                pass

        '''
        for dirpath, dirnames, files in os.walk(dir):
            for dirname in dirnames:
                if re.match(pattern, dirname):
                    runNo.append(int(dirname[3:]))
        '''

        runNo.sort()
        return runNo


    def getMonitorList(self,runNo):
        path='/opt/CSNSDATA/TS1/BL01/Monitor/Histogram/Monitor3/RUN'+str(runNo).zfill(7)+'/'
        data=glob.glob(path+'*.bin')
        if len(data)==0:
            return False
        else:
            return True

    def process(self):
        ctrlRunList=self.getRunNoList()
        nexusRunList=self.getNexusRunList()
        completeRunList=self.getDaqCompleteList()
        #print ctrlRunList
        newList=[]
        for cRun in ctrlRunList:
            #if cRun not in nexusRunList and cRun in completeRunList:
            if cRun not in nexusRunList:
                judge=self.getMonitorList(cRun)
                if judge:
                    newList.append(cRun)

        self.logger.debug("to be reconstructed: "+str(newList))
        #newList=[681]
        for runNo in newList:
            _b=time.time()
            #print "begin:", runNo
            createNexus(self.psize, runNo)
            self.logger.debug("end: "+str(runNo))

    def run(self):
        while True:
            #try:
            self.process()
            #except:
            #    pass
            time.sleep(300.0)

if __name__=="__main__":
    _log=myLog()
    logger= _log.getLog()
    psize=str(sys.argv[1])+'mm'
    threadDaemon = main(psize, logger)
    threadDaemon.setDaemon(True)
    threadDaemon.start()
    threadDaemon.join()
    sys.exit()
