from mantid.simpleapi import *
import json
import time
import sys
import numpy
import subprocess
import os
import matplotlib.pyplot as plt
import glob
import shutil
import re
from xml.etree import ElementTree as ET


def parseDaq(prepath,runno, T0start, T0end):
    for i in range(10):
        subprocess.check_call("python binary_hist.py "+runno+" "+str(i+1)+" "+prepath+" "+str(T0start)+" "+str(T0end)+" &", shell=True)
    for i in range(10):
        while not os.path.exists(prepath+"/tmpData/module"+str(i+1)+".dat"):
            print "no data"
            time.sleep(3)
        print "module",str(i+1)," exists!"
 
def parseMonitor(prepath, runno, monitor, pixels):
    _cmd="./main "+runno+" "+monitor+" "+str(pixels)+" "+prepath
    subprocess.check_call(_cmd, shell=True)
    while not os.path.exists(prepath+"/tmpData/"+monitor+".dat"):
        print "no data"
        time.sleep(3)
    print "finish parse monitor binary data for ", monitor
    
def getDaq(prepath, moduleList):
    root = ET.parse('configure.xml')
    tof  = root.find('tofInformation')
    m_tofstart= int(tof.attrib['tofstart'])
    m_tofstep = int(tof.attrib['tofstep'])
    m_tofbins = int(tof.attrib['tofbin'])
    tof = [m_tofstart+i*m_tofstep for i in xrange(m_tofbins+1)]
    mpid=[]
    value=[]
    for name in moduleList:
        for item in root.findall('type/component'):
            if name== item.attrib['name']:
                m_moduleinfo = item.attrib
                idstart = int(m_moduleinfo['idstart'])
                idsize  = int(m_moduleinfo['pixels'])
                _tmp = [idstart+i*1 for i in xrange(idsize)]
                for num in _tmp:
                    mpid.append(num)
        f0=open(prepath+'/tmpData/'+name+'.dat',"r")
        _tmpv=json.load(f0)
        v=[]
        for ix in _tmpv:
            for iy in ix:
                v.append(iy)
        for num in v:
            value.append(num)
    if len(mpid)*(len(tof)-1)==len(value):
        return mpid, tof ,value   
    else:
        print "daq data match failed!"
        sys.exit()

def getMonitor(prepath, monitor, pixels):
    mpid=[1+i for i in xrange(pixels)]
    tof=[0+i for i in xrange(40001)]
    f0=open(prepath+"/tmpData/"+monitor+".dat")
    _tmpv=json.load(f0)
    value=[]
    for ix in _tmpv:
        for iy in ix:
            value.append(iy)
    if len(mpid)*(len(tof)-1)==len(value):
        return mpid, tof ,value   
    else:
        print "monitor data match failed!"
        sys.exit()

# usage: python hist_nxs.py banknum 
def createNexus(runNo, T0start, T0end):
    runno="RUN"+str(runNo).zfill(7)

    prepath=sys.path[0]+"/"+runno
    prepath2=sys.path[0]
    if os.path.exists(prepath):
        pass
    else:
        os.mkdir(prepath)
    tmp=prepath+'/tmpData'
    if os.path.exists(tmp):
        _cmd="rm -rf "+prepath+"/tmpData/*"
        subprocess.check_call(_cmd, shell=True)
    else:
        os.mkdir(tmp)
    print 'mkdir ', tmp 
    moduleList=['module1','module2','module3','module4','module5','module6','module7','module8','module9','module10']
    rawpath="/opt/CSNSDATA/TS1/BL01/DAQ/"+runno
    xmlfile=glob.glob(os.path.join(rawpath, '*.xml'))
    if len(xmlfile)==0:
        print "no data in ",runno, " for DAQ"
    else:
        parseDaq(prepath, runno, T0start, T0end)
        spid, stof, svalue = getDaq(prepath, moduleList)
        LoadCSNSRaw(OutputWorkspace="sample", PixelID_bank=spid, TimeOfFlight_bank=stof, Counts_bank=svalue, PixelID_monitor=[0,1], TimeOfFlight_monitor=[0,16], Counts_monitor=[1,1])
        LoadInstrument(Workspace="sample_1", Filename=prepath2+'/paramData/detector.xml', RewriteSpectraMap='True')
        SaveNexus(InputWorkspace='sample_1', Filename=prepath+'/sample.nxs')
        print 'finish save nexus for detector  ',time.strftime('%Y-%m-%dT%H:%M:%S.%03d+08:00')
    monitorList=['Monitor1','Monitor2','Monitor3']
    #monitorList=[]
    monitorPixel={}
    monitorPixel['monitor1']=1024
    monitorPixel['monitor2']=1
    monitorPixel['monitor3']=1
    for mname in monitorList:
        rawpath="/opt/CSNSDATA/TS1/BL01/Monitor/Histogram/"+mname+"/"+runno
        binfile=glob.glob(os.path.join(rawpath, '*.bin'))
        if len(binfile)==0:
            print "no data in ",runno, " for ",mname
        else:
            mname = mname.lower()
            pixels=int(monitorPixel[mname])
            parseMonitor(prepath, runno, mname, pixels)
            mpid=[]
            mtof=[]
            mvalue=[]
            mpid, mtof, mvalue = getMonitor(prepath, mname, pixels)
            # mantid data processing
            LoadCSNSRaw(OutputWorkspace=mname, PixelID_bank=[0,1], TimeOfFlight_bank=[0,8], Counts_bank=[1,1], PixelID_monitor=mpid, TimeOfFlight_monitor=mtof, Counts_monitor=mvalue)
            CloneWorkspace(InputWorkspace=mname+'_2', OutputWorkspace=mname )
            LoadInstrument(Workspace=mname+"_2", Filename=prepath2+'/paramData/'+mname+'.xml', RewriteSpectraMap='True')
            SaveNexus(InputWorkspace=mname+'_2', Filename=prepath+'/'+mname+'.nxs')
        try:
            ConjoinWorkspaces(InputWorkspace1='monitor2',InputWorkspace2='monitor3',CheckOverlapping=False)
            LoadInstrument(Workspace='monitor2', Filename=prepath2+'/paramData/monitors.xml', RewriteSpectraMap='True') 
            SaveNexus(InputWorkspace='monitor2', Filename=prepath+'/monitors.nxs')
        except:
            pass
    
    print 'finish save nexus for monitors'
    _cmd="rm -rf "+prepath+"/tmpData"
    subprocess.check_call(_cmd, shell=True)

    f=open("./database/"+runno, "w")
    f.close()

    try:
        f=open("complete", "w")
        f.close()
    except:
        pass

    #_cmd = 'scp -r '+runno+' transfer@10.1.26.156:/home/transfer/nexus/CSNSDATA/TS1/BL01/'
    #subprocess.check_call(_cmd, shell=True)

    #_cmd = 'scp complete  transfer@10.1.26.156:/home/transfer/nexus/CSNSDATA/TS1/BL01/'+runno
    #subprocess.check_call(_cmd, shell=True)

def getT0(runno, localStart, localEnd):
    # because T0 filename is not in xml, So it needs input the filepath
    #parse daq xml
    runnum=str(runno).zfill(7)
    rawpath="/opt/CSNSDATA/TS1/BL01/DAQ/RUN"+runnum+"/"
    print rawpath
    xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
    print xmllist
    xmlfile=xmllist[0]
    root = ET.parse(xmlfile)
    ns=''
    nsmatch=re.match('\{.*\}', root.getroot().tag)
    if nsmatch:
        ns=nsmatch.group(0)
        print ns
    for item in root.findall(ns+'T0'):
        #print item
        item = item.find(ns+'files')
        filename = item.findtext(ns+'file')
    print filename
    filepath=rawpath+filename
    T0Start, T0End=DAQParser.parseT0(filepath, localStart, localEnd)
    return T0Start, T0End


#!/usr/bin/python
import sys
import time
import os
import DAQParser

if __name__=="__main__":

    runNo=511

    cropT0=False

    if cropT0:
        localStart='2018-03-25T16:20:00'
        localEnd='2018-03-25T16:36:02'
        T0Start, T0End=getT0(runNo, localStart, localEnd)
    else:
        T0Start=1
        T0End=30240000

    _b=time.time()
    print "begin:", runNo
    createNexus(runNo, T0start, T0end)
    print "end:", runNo, (time.time()-_b)/60.0
